/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import java.util.Map;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelShuttle;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hive.com.google.common.collect.ImmutableMap;

public class HiveSortLimit
extends Sort
implements HiveRelNode {
    private ImmutableMap<Integer, RexNode> mapOfInputRefToRexCall;
    private boolean ruleCreated;

    public HiveSortLimit(RelOptCluster cluster, RelTraitSet traitSet, RelNode child, RelCollation collation, RexNode offset, RexNode fetch) {
        super(cluster, TraitsUtil.getSortTraitSet(cluster, traitSet, collation), child, collation, offset, fetch);
    }

    public static HiveSortLimit create(RelNode input, RelCollation collation, RexNode offset, RexNode fetch) {
        RelOptCluster cluster = input.getCluster();
        collation = (RelCollation)RelCollationTraitDef.INSTANCE.canonize((RelTrait)collation);
        RelTraitSet traitSet = TraitsUtil.getSortTraitSet(cluster, input.getTraitSet(), collation);
        return new HiveSortLimit(cluster, traitSet, input, collation, offset, fetch);
    }

    public HiveSortLimit copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, RexNode offset, RexNode fetch) {
        RelCollation canonizedCollation = (RelCollation)traitSet.canonize((RelTrait)newCollation);
        HiveSortLimit sortLimit = new HiveSortLimit(this.getCluster(), traitSet, newInput, canonizedCollation, offset, fetch);
        sortLimit.setRuleCreated(this.ruleCreated);
        return sortLimit;
    }

    public RexNode getFetchExpr() {
        return this.fetch;
    }

    public RexNode getOffsetExpr() {
        return this.offset;
    }

    public void setInputRefToCallMap(ImmutableMap<Integer, RexNode> refToCall) {
        this.mapOfInputRefToRexCall = refToCall;
    }

    public Map<Integer, RexNode> getInputRefToCallMap() {
        return this.mapOfInputRefToRexCall;
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }

    public boolean isRuleCreated() {
        return this.ruleCreated;
    }

    public void setRuleCreated(boolean ruleCreated) {
        this.ruleCreated = ruleCreated;
    }

    public RelNode accept(RelShuttle shuttle) {
        if (shuttle instanceof HiveRelShuttle) {
            return ((HiveRelShuttle)shuttle).visit(this);
        }
        return shuttle.visit((RelNode)this);
    }
}

