/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMin;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.serde.serdeConstants;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hive.com.google.common.collect.Lists;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsOptimizer
extends Transform {
    private static final Logger Logger = LoggerFactory.getLogger(StatsOptimizer.class);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        if (pctx.getFetchTask() != null || !pctx.getQueryProperties().isQuery() || pctx.getQueryProperties().isAnalyzeRewrite() || pctx.getQueryProperties().isCTAS() || pctx.getLoadFileWork().size() > 1 || !pctx.getLoadTableWork().isEmpty() || !pctx.getNameToSplitSample().isEmpty()) {
            return pctx;
        }
        String TS = TableScanOperator.getOperatorName() + "%";
        String GBY = GroupByOperator.getOperatorName() + "%";
        String RS = ReduceSinkOperator.getOperatorName() + "%";
        String SEL = SelectOperator.getOperatorName() + "%";
        String FS = FileSinkOperator.getOperatorName() + "%";
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", TS + SEL + GBY + RS + GBY + SEL + FS), new MetaDataProcessor(pctx));
        opRules.put(new RuleRegExp("R2", TS + SEL + GBY + RS + GBY + FS), new MetaDataProcessor(pctx));
        StatsOptimizerProcContext soProcCtx = new StatsOptimizerProcContext();
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, soProcCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private static class MetaDataProcessor
    implements NodeProcessor {
        private final ParseContext pctx;

        public MetaDataProcessor(ParseContext pctx) {
            this.pctx = pctx;
        }

        private StatType getType(String origType) {
            if (serdeConstants.IntegralTypes.contains(origType)) {
                return StatType.Integeral;
            }
            if (origType.equals("double") || origType.equals("float")) {
                return StatType.Double;
            }
            if (origType.equals("binary")) {
                return StatType.Binary;
            }
            if (origType.equals("boolean")) {
                return StatType.Boolean;
            }
            if (origType.equals("string")) {
                return StatType.String;
            }
            return StatType.Unsupported;
        }

        private Long getNullcountFor(StatType type, ColumnStatisticsData statData) {
            switch (type) {
                case Integeral: {
                    return statData.getLongStats().getNumNulls();
                }
                case Double: {
                    return statData.getDoubleStats().getNumNulls();
                }
                case String: {
                    return statData.getStringStats().getNumNulls();
                }
                case Boolean: {
                    return statData.getBooleanStats().getNumNulls();
                }
                case Binary: {
                    return statData.getBinaryStats().getNumNulls();
                }
            }
            return null;
        }

        private GbyKeyType getGbyKeyType(GroupByOperator gbyOp) {
            int aggCols;
            GroupByDesc gbyDesc = (GroupByDesc)gbyOp.getConf();
            int numCols = gbyDesc.getOutputColumnNames().size();
            if (numCols == (aggCols = gbyDesc.getAggregators().size())) {
                return GbyKeyType.NULL;
            }
            List<String> dpCols = gbyOp.getSchema().getColumnNames().subList(0, numCols - aggCols);
            for (String dpCol : dpCols) {
                ExprNodeDesc end = ExprNodeDescUtils.findConstantExprOrigin(dpCol, gbyOp);
                if (end instanceof ExprNodeConstantDesc) continue;
                return GbyKeyType.OTHER;
            }
            return GbyKeyType.CONSTANT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            StatsOptimizerProcContext soProcCtx = (StatsOptimizerProcContext)procCtx;
            if (soProcCtx.stopProcess) {
                return null;
            }
            boolean isOptimized = false;
            try {
                Object var26_40;
                FileSinkOperator fsOp;
                ExprNodeDesc desc;
                TableScanOperator tsOp = (TableScanOperator)stack.get(0);
                if (tsOp.getNumParent() > 0) {
                    Object var8_9 = null;
                    return var8_9;
                }
                if (((TableScanDesc)tsOp.getConf()).getRowLimit() != -1) {
                    Object var8_10 = null;
                    return var8_10;
                }
                Table tbl = ((TableScanDesc)tsOp.getConf()).getTableMetadata();
                if (AcidUtils.isAcidTable(tbl)) {
                    Logger.info("Table " + tbl.getTableName() + " is ACID table. Skip StatsOptimizer.");
                    Object var9_12 = null;
                    return var9_12;
                }
                Long rowCnt = this.getRowCnt(this.pctx, tsOp, tbl);
                if (rowCnt == null) {
                    Object var10_14 = null;
                    return var10_14;
                }
                SelectOperator pselOp = (SelectOperator)stack.get(1);
                for (ExprNodeDesc desc2 : ((SelectDesc)pselOp.getConf()).getColList()) {
                    if (desc2 instanceof ExprNodeColumnDesc || desc2 instanceof ExprNodeConstantDesc) continue;
                    Object var13_18 = null;
                    return var13_18;
                }
                Map<String, ExprNodeDesc> exprMap = pselOp.getColumnExprMap();
                GroupByOperator pgbyOp = (GroupByOperator)stack.get(2);
                if (this.getGbyKeyType(pgbyOp) == GbyKeyType.OTHER) {
                    Object var13_19 = null;
                    return var13_19;
                }
                if (this.getGbyKeyType(pgbyOp) == GbyKeyType.CONSTANT && rowCnt == 0L) {
                    Object var13_20 = null;
                    return var13_20;
                }
                ReduceSinkOperator rsOp = (ReduceSinkOperator)stack.get(3);
                if (((ReduceSinkDesc)rsOp.getConf()).getDistinctColumnIndices().size() > 0) {
                    Object var14_22 = null;
                    return var14_22;
                }
                GroupByOperator cgbyOp = (GroupByOperator)stack.get(4);
                if (this.getGbyKeyType(cgbyOp) == GbyKeyType.OTHER) {
                    Object var15_24 = null;
                    return var15_24;
                }
                if (this.getGbyKeyType(cgbyOp) == GbyKeyType.CONSTANT && rowCnt == 0L) {
                    Object var15_25 = null;
                    return var15_25;
                }
                Operator last = (Operator)stack.get(5);
                SelectOperator cselOp = null;
                HashMap<Integer, Object> posToConstant = new HashMap<Integer, Object>();
                if (last instanceof SelectOperator) {
                    cselOp = (SelectOperator)last;
                    if (!cselOp.isIdentitySelect()) {
                        for (int pos = 0; pos < ((SelectDesc)cselOp.getConf()).getColList().size(); ++pos) {
                            desc = ((SelectDesc)cselOp.getConf()).getColList().get(pos);
                            if (desc instanceof ExprNodeConstantDesc) {
                                posToConstant.put(pos, ((ExprNodeConstantDesc)desc).getValue());
                                continue;
                            }
                            if (desc instanceof ExprNodeColumnDesc) continue;
                            Object var20_32 = null;
                            return var20_32;
                        }
                    }
                    last = (Operator)stack.get(6);
                }
                if ((fsOp = (FileSinkOperator)last).getNumChild() > 0) {
                    desc = null;
                    return desc;
                }
                ArrayList<Object> oneRow = new ArrayList<Object>();
                Hive hive = Hive.get(this.pctx.getConf());
                for (AggregationDesc aggr : ((GroupByDesc)pgbyOp.getConf()).getAggregators()) {
                    DoubleColumnStatsData dstats;
                    long curVal;
                    LongColumnStatsData lstats;
                    ColumnStatisticsData statData;
                    Collection<List<ColumnStatisticsObj>> result;
                    String name;
                    Object colDesc;
                    Iterator<List<ColumnStatisticsObj>> iterator;
                    Collection<List<ColumnStatisticsObj>> result2;
                    Set<Partition> parts;
                    List<ColumnStatisticsObj> stats;
                    StatType type;
                    String colName;
                    Object var27_41;
                    ExprNodeDesc desc3;
                    if (aggr.getDistinct()) {
                        Object var23_36 = null;
                        return var23_36;
                    }
                    GenericUDAFResolver udaf = FunctionRegistry.getGenericUDAFResolver(aggr.getGenericUDAFName());
                    if (udaf instanceof GenericUDAFSum) {
                        String constant;
                        desc3 = aggr.getParameters().get(0);
                        PrimitiveObjectInspector.PrimitiveCategory category = GenericUDAFSum.getReturnType(desc3.getTypeInfo());
                        if (category == null) {
                            var26_40 = null;
                            return var26_40;
                        }
                        if (desc3 instanceof ExprNodeConstantDesc) {
                            constant = ((ExprNodeConstantDesc)desc3).getValue().toString();
                        } else if (desc3 instanceof ExprNodeColumnDesc && exprMap.get(((ExprNodeColumnDesc)desc3).getColumn()) instanceof ExprNodeConstantDesc) {
                            constant = ((ExprNodeConstantDesc)exprMap.get(((ExprNodeColumnDesc)desc3).getColumn())).getValue().toString();
                        } else {
                            var27_41 = null;
                            return var27_41;
                        }
                        switch (category) {
                            case LONG: {
                                oneRow.add(Long.valueOf(constant) * rowCnt);
                                break;
                            }
                            case DOUBLE: {
                                oneRow.add(Double.valueOf(constant) * (double)rowCnt.longValue());
                                break;
                            }
                            case DECIMAL: {
                                oneRow.add(HiveDecimal.create(constant).multiply(HiveDecimal.create(rowCnt)));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("never");
                            }
                        }
                        continue;
                    }
                    if (udaf instanceof GenericUDAFCount) {
                        rowCnt = 0L;
                        if (aggr.getParameters().isEmpty()) {
                            rowCnt = this.getRowCnt(this.pctx, tsOp, tbl);
                            if (rowCnt == null) {
                                desc3 = null;
                                return desc3;
                            }
                        } else if (aggr.getParameters().get(0) instanceof ExprNodeConstantDesc) {
                            if (((ExprNodeConstantDesc)aggr.getParameters().get(0)).getValue() != null && (rowCnt = this.getRowCnt(this.pctx, tsOp, tbl)) == null) {
                                desc3 = null;
                                return desc3;
                            }
                        } else if (aggr.getParameters().get(0) instanceof ExprNodeColumnDesc && exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn()) instanceof ExprNodeConstantDesc) {
                            if (((ExprNodeConstantDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn())).getValue() != null && (rowCnt = this.getRowCnt(this.pctx, tsOp, tbl)) == null) {
                                desc3 = null;
                                return desc3;
                            }
                        } else {
                            ExprNodeColumnDesc desc2 = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                            colName = desc2.getColumn();
                            type = this.getType(desc2.getTypeString());
                            if (!tbl.isPartitioned()) {
                                if (!StatsSetupConst.areBasicStatsUptoDate(tbl.getParameters())) {
                                    Logger.debug("Stats for table : " + tbl.getTableName() + " are not up to date.");
                                    var27_41 = null;
                                    return var27_41;
                                }
                                rowCnt = Long.parseLong(tbl.getProperty("numRows"));
                                if (rowCnt == null) {
                                    Logger.debug("Table doesn't have up to date stats " + tbl.getTableName());
                                    var27_41 = null;
                                    return var27_41;
                                }
                                if (!StatsSetupConst.areColumnStatsUptoDate(tbl.getParameters(), colName)) {
                                    Logger.debug("Stats for table : " + tbl.getTableName() + " column " + colName + " are not up to date.");
                                    var27_41 = null;
                                    return var27_41;
                                }
                                stats = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), Lists.newArrayList(colName));
                                if (stats.isEmpty()) {
                                    Logger.debug("No stats for " + tbl.getTableName() + " column " + colName);
                                    Object var28_44 = null;
                                    return var28_44;
                                }
                                Long nullCnt = this.getNullcountFor(type, stats.get(0).getStatsData());
                                if (null == nullCnt) {
                                    Logger.debug("Unsupported type: " + desc2.getTypeString() + " encountered in metadata optimizer for column : " + colName);
                                    Object var29_48 = null;
                                    return var29_48;
                                }
                                rowCnt = rowCnt - nullCnt;
                            } else {
                                parts = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                                for (Partition partition : parts) {
                                    if (!StatsSetupConst.areBasicStatsUptoDate(partition.getParameters())) {
                                        Logger.debug("Stats for part : " + partition.getSpec() + " are not up to date.");
                                        Object var30_70 = null;
                                        return var30_70;
                                    }
                                    Long partRowCnt = Long.parseLong(partition.getParameters().get("numRows"));
                                    if (partRowCnt == null) {
                                        Logger.debug("Partition doesn't have up to date stats " + partition.getSpec());
                                        Object var31_71 = null;
                                        return var31_71;
                                    }
                                    rowCnt = rowCnt + partRowCnt;
                                }
                                result2 = this.verifyAndGetPartColumnStats(hive, tbl, colName, parts);
                                if (result2 == null) {
                                    Object var29_51 = null;
                                    return var29_51;
                                }
                                for (List<ColumnStatisticsObj> statObj : result2) {
                                    ColumnStatisticsData statData2 = this.validateSingleColStat(statObj);
                                    if (statData2 == null) {
                                        iterator = null;
                                        return iterator;
                                    }
                                    Long nullCnt = this.getNullcountFor(type, statData2);
                                    if (nullCnt == null) {
                                        Logger.debug("Unsupported type: " + desc2.getTypeString() + " encountered in metadata optimizer for column : " + colName);
                                        Object var33_73 = null;
                                        return var33_73;
                                    }
                                    rowCnt = rowCnt - nullCnt;
                                }
                            }
                        }
                        oneRow.add(rowCnt);
                        continue;
                    }
                    if (udaf instanceof GenericUDAFMax) {
                        colDesc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                        colName = ((ExprNodeColumnDesc)colDesc).getColumn();
                        type = this.getType(((ExprNodeDesc)colDesc).getTypeString());
                        if (!tbl.isPartitioned()) {
                            if (!StatsSetupConst.areColumnStatsUptoDate(tbl.getParameters(), colName)) {
                                Logger.debug("Stats for table : " + tbl.getTableName() + " column " + colName + " are not up to date.");
                                parts = null;
                                return parts;
                            }
                            stats = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), Lists.newArrayList(colName));
                            if (stats.isEmpty()) {
                                Logger.debug("No stats for " + tbl.getTableName() + " column " + colName);
                                result2 = null;
                                return result2;
                            }
                            ColumnStatisticsData statData3 = stats.get(0).getStatsData();
                            String string = ((ExprNodeDesc)colDesc).getTypeString().toUpperCase();
                            switch (type) {
                                case Integeral: {
                                    LongSubType subType2 = LongSubType.valueOf(string);
                                    LongColumnStatsData lstats2 = statData3.getLongStats();
                                    if (lstats2.isSetHighValue()) {
                                        oneRow.add(subType2.cast(lstats2.getHighValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                case Double: {
                                    DoubleSubType subType = DoubleSubType.valueOf(string);
                                    DoubleColumnStatsData dstats2 = statData3.getDoubleStats();
                                    if (dstats2.isSetHighValue()) {
                                        oneRow.add(subType.cast(dstats2.getHighValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                default: {
                                    Logger.debug("Unsupported type: " + ((ExprNodeDesc)colDesc).getTypeString() + " encountered in metadata optimizer for column : " + colName);
                                    DoubleSubType subType = null;
                                    return subType;
                                }
                            }
                            continue;
                        }
                        parts = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                        name = ((ExprNodeDesc)colDesc).getTypeString().toUpperCase();
                        switch (type) {
                            case Integeral: {
                                LongSubType longSubType = LongSubType.valueOf(name);
                                Number maxVal = null;
                                result = this.verifyAndGetPartColumnStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    iterator = null;
                                    return iterator;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        Object var35_75 = null;
                                        return var35_75;
                                    }
                                    lstats = statData.getLongStats();
                                    if (!lstats.isSetHighValue()) continue;
                                    curVal = lstats.getHighValue();
                                    maxVal = maxVal == null ? curVal : Math.max(maxVal, curVal);
                                }
                                if (maxVal != null) {
                                    oneRow.add(longSubType.cast((long)maxVal));
                                    break;
                                }
                                oneRow.add(maxVal);
                                break;
                            }
                            case Double: {
                                DoubleSubType doubleSubType = DoubleSubType.valueOf(name);
                                Number maxVal = null;
                                result = this.verifyAndGetPartColumnStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    iterator = null;
                                    return iterator;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        lstats = null;
                                        return lstats;
                                    }
                                    dstats = statData.getDoubleStats();
                                    if (!dstats.isSetHighValue()) continue;
                                    double curVal2 = statData.getDoubleStats().getHighValue();
                                    maxVal = maxVal == null ? curVal2 : Math.max((Double)maxVal, curVal2);
                                }
                                if (maxVal != null) {
                                    oneRow.add(doubleSubType.cast((Double)maxVal));
                                    break;
                                }
                                oneRow.add(null);
                                break;
                            }
                            default: {
                                Logger.debug("Unsupported type: " + ((ExprNodeDesc)colDesc).getTypeString() + " encountered in metadata optimizer for column : " + colName);
                                Object var29_56 = null;
                                return var29_56;
                            }
                        }
                        continue;
                    }
                    if (udaf instanceof GenericUDAFMin) {
                        colDesc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                        colName = ((ExprNodeColumnDesc)colDesc).getColumn();
                        type = this.getType(((ExprNodeDesc)colDesc).getTypeString());
                        if (!tbl.isPartitioned()) {
                            if (!StatsSetupConst.areColumnStatsUptoDate(tbl.getParameters(), colName)) {
                                Logger.debug("Stats for table : " + tbl.getTableName() + " column " + colName + " are not up to date.");
                                parts = null;
                                return parts;
                            }
                            ColumnStatisticsData statData4 = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), Lists.newArrayList(colName)).get(0).getStatsData();
                            name = ((ExprNodeDesc)colDesc).getTypeString().toUpperCase();
                            switch (type) {
                                case Integeral: {
                                    LongSubType longSubType = LongSubType.valueOf(name);
                                    LongColumnStatsData lstats3 = statData4.getLongStats();
                                    if (lstats3.isSetLowValue()) {
                                        oneRow.add(longSubType.cast(lstats3.getLowValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                case Double: {
                                    DoubleSubType doubleSubType = DoubleSubType.valueOf(name);
                                    DoubleColumnStatsData dstats3 = statData4.getDoubleStats();
                                    if (dstats3.isSetLowValue()) {
                                        oneRow.add(doubleSubType.cast(dstats3.getLowValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                default: {
                                    Logger.debug("Unsupported type: " + ((ExprNodeDesc)colDesc).getTypeString() + " encountered in metadata optimizer for column : " + colName);
                                    Object var29_60 = null;
                                    return var29_60;
                                }
                            }
                            continue;
                        }
                        parts = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                        name = ((ExprNodeDesc)colDesc).getTypeString().toUpperCase();
                        switch (type) {
                            case Integeral: {
                                LongSubType longSubType = LongSubType.valueOf(name);
                                Number minVal = null;
                                result = this.verifyAndGetPartColumnStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    iterator = null;
                                    return iterator;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        dstats = null;
                                        return dstats;
                                    }
                                    lstats = statData.getLongStats();
                                    if (!lstats.isSetLowValue()) continue;
                                    curVal = lstats.getLowValue();
                                    minVal = minVal == null ? curVal : Math.min(minVal, curVal);
                                }
                                if (minVal != null) {
                                    oneRow.add(longSubType.cast((long)minVal));
                                    break;
                                }
                                oneRow.add(minVal);
                                break;
                            }
                            case Double: {
                                DoubleSubType doubleSubType = DoubleSubType.valueOf(name);
                                Number minVal = null;
                                result = this.verifyAndGetPartColumnStats(hive, tbl, colName, parts);
                                if (result == null) {
                                    iterator = null;
                                    return iterator;
                                }
                                for (List<ColumnStatisticsObj> statObj : result) {
                                    statData = this.validateSingleColStat(statObj);
                                    if (statData == null) {
                                        lstats = null;
                                        return lstats;
                                    }
                                    dstats = statData.getDoubleStats();
                                    if (!dstats.isSetLowValue()) continue;
                                    double curVal3 = statData.getDoubleStats().getLowValue();
                                    minVal = minVal == null ? curVal3 : Math.min((Double)minVal, curVal3);
                                }
                                if (minVal != null) {
                                    oneRow.add(doubleSubType.cast((Double)minVal));
                                    break;
                                }
                                oneRow.add(minVal);
                                break;
                            }
                            default: {
                                Logger.debug("Unsupported type: " + ((ExprNodeDesc)colDesc).getTypeString() + " encountered in metadata optimizer for column : " + colName);
                                Object var29_64 = null;
                                return var29_64;
                            }
                        }
                        continue;
                    }
                    Logger.debug("Unsupported aggregation for metadata optimizer: " + aggr.getGenericUDAFName());
                    colDesc = null;
                    return colDesc;
                }
                ArrayList<List<Object>> allRows = new ArrayList<List<Object>>();
                ArrayList<String> colNames = new ArrayList<String>();
                ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
                if (cselOp == null) {
                    allRows.add(oneRow);
                    for (ColumnInfo colInfo : cgbyOp.getSchema().getSignature()) {
                        colNames.add(colInfo.getInternalName());
                        ois.add(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(colInfo.getType()));
                    }
                } else {
                    void var29_69;
                    HashMap<String, Integer> nameToIndex = new HashMap<String, Integer>();
                    for (int index = 0; index < ((GroupByDesc)cgbyOp.getConf()).getOutputColumnNames().size(); ++index) {
                        nameToIndex.put(((GroupByDesc)cgbyOp.getConf()).getOutputColumnNames().get(index), index);
                    }
                    List<String> outputColumnNames = ((SelectDesc)cselOp.getConf()).getOutputColumnNames();
                    HashMap cselOpTocgbyOp = new HashMap();
                    for (int index = 0; index < outputColumnNames.size(); ++index) {
                        if (posToConstant.containsKey(index)) continue;
                        String outputColumnName = outputColumnNames.get(index);
                        ExprNodeColumnDesc exprNodeColumnDesc = (ExprNodeColumnDesc)cselOp.getColumnExprMap().get(outputColumnName);
                        cselOpTocgbyOp.put(index, nameToIndex.get(exprNodeColumnDesc.getColumn()));
                    }
                    ArrayList list = new ArrayList(cselOpTocgbyOp.entrySet());
                    Collections.sort(list, new Comparator<Map.Entry<Integer, Integer>>(){

                        @Override
                        public int compare(Map.Entry<Integer, Integer> o1, Map.Entry<Integer, Integer> o2) {
                            return o1.getValue().compareTo(o2.getValue());
                        }
                    });
                    cselOpTocgbyOp.clear();
                    for (int index = 0; index < list.size(); ++index) {
                        cselOpTocgbyOp.put((Integer)((Map.Entry)list.get(index)).getKey(), index);
                    }
                    ArrayList<Object> oneRowWithConstant = new ArrayList<Object>();
                    boolean bl = false;
                    while (var29_69 < cselOp.getSchema().getSignature().size()) {
                        if (posToConstant.containsKey((int)var29_69)) {
                            oneRowWithConstant.add(posToConstant.get((int)var29_69));
                        } else {
                            oneRowWithConstant.add(oneRow.get((Integer)cselOpTocgbyOp.get((int)var29_69)));
                        }
                        ColumnInfo colInfo = cselOp.getSchema().getSignature().get((int)var29_69);
                        colNames.add(colInfo.getInternalName());
                        ois.add(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo(colInfo.getType()));
                        ++var29_69;
                    }
                    allRows.add(oneRowWithConstant);
                }
                FetchWork fWork = null;
                FetchTask fTask = this.pctx.getFetchTask();
                if (fTask != null) {
                    fWork = (FetchWork)fTask.getWork();
                    fWork.getRowsComputedUsingStats().addAll(allRows);
                } else {
                    StandardStructObjectInspector sOI = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, ois);
                    fWork = new FetchWork(allRows, sOI);
                    fTask = (FetchTask)TaskFactory.get(fWork, this.pctx.getConf(), new Task[0]);
                    this.pctx.setFetchTask(fTask);
                }
                fWork.setLimit(fWork.getRowsComputedUsingStats().size());
                isOptimized = true;
                var26_40 = null;
                return var26_40;
            }
            catch (Exception e) {
                Logger.debug("Failed to optimize using metadata optimizer", e);
                Object var8_11 = null;
                return var8_11;
            }
            finally {
                if (!isOptimized) {
                    soProcCtx.stopProcess = true;
                    this.pctx.setFetchTask(null);
                }
            }
        }

        private ColumnStatisticsData validateSingleColStat(List<ColumnStatisticsObj> statObj) {
            if (statObj.size() > 1) {
                Logger.error("More than one stat for a single column!");
                return null;
            }
            if (statObj.isEmpty()) {
                Logger.debug("No stats for some partition and column");
                return null;
            }
            return statObj.get(0).getStatsData();
        }

        private Collection<List<ColumnStatisticsObj>> verifyAndGetPartColumnStats(Hive hive, Table tbl, String colName, Set<Partition> parts) throws TException {
            ArrayList<String> partNames = new ArrayList<String>(parts.size());
            for (Partition part : parts) {
                if (!StatsSetupConst.areColumnStatsUptoDate(part.getParameters(), colName)) {
                    Logger.debug("Stats for part : " + part.getSpec() + " column " + colName + " are not up to date.");
                    return null;
                }
                partNames.add(part.getName());
            }
            Map<String, List<ColumnStatisticsObj>> result = hive.getMSC().getPartitionColumnStatistics(tbl.getDbName(), tbl.getTableName(), partNames, Lists.newArrayList(colName));
            if (result.size() != parts.size()) {
                Logger.debug("Received " + result.size() + " stats for " + parts.size() + " partitions");
                return null;
            }
            return result.values();
        }

        private Long getRowCnt(ParseContext pCtx, TableScanOperator tsOp, Table tbl) throws HiveException {
            Long rowCnt = 0L;
            if (tbl.isPartitioned()) {
                for (Partition part : this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions()) {
                    if (!StatsSetupConst.areBasicStatsUptoDate(part.getParameters())) {
                        return null;
                    }
                    Long partRowCnt = Long.parseLong(part.getParameters().get("numRows"));
                    if (partRowCnt == null || partRowCnt == 0L) {
                        Logger.debug("Partition doesn't have up to date stats " + part.getSpec());
                        return null;
                    }
                    rowCnt = rowCnt + partRowCnt;
                }
            } else {
                if (!StatsSetupConst.areBasicStatsUptoDate(tbl.getParameters())) {
                    return null;
                }
                rowCnt = Long.parseLong(tbl.getProperty("numRows"));
                if (rowCnt == null || rowCnt == 0L) {
                    Logger.debug("Table doesn't have up to date stats " + tbl.getTableName());
                    rowCnt = null;
                }
            }
            return rowCnt;
        }

        static enum GbyKeyType {
            NULL,
            CONSTANT,
            OTHER;

        }

        static enum DoubleSubType {
            DOUBLE{

                @Override
                Object cast(double doubleValue) {
                    return doubleValue;
                }
            }
            ,
            FLOAT{

                @Override
                Object cast(double doubleValue) {
                    return Float.valueOf((float)doubleValue);
                }
            };


            abstract Object cast(double var1);
        }

        static enum LongSubType {
            BIGINT{

                @Override
                Object cast(long longValue) {
                    return longValue;
                }
            }
            ,
            INT{

                @Override
                Object cast(long longValue) {
                    return (int)longValue;
                }
            }
            ,
            SMALLINT{

                @Override
                Object cast(long longValue) {
                    return (short)longValue;
                }
            }
            ,
            TINYINT{

                @Override
                Object cast(long longValue) {
                    return (byte)longValue;
                }
            };


            abstract Object cast(long var1);
        }

        static enum StatType {
            Integeral,
            Double,
            String,
            Boolean,
            Binary,
            Unsupported;

        }
    }

    private static class StatsOptimizerProcContext
    implements NodeProcessorCtx {
        boolean stopProcess = false;

        private StatsOptimizerProcContext() {
        }
    }
}

