/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.vector;

import hive.org.apache.parquet.ParquetRuntimeException;
import hive.org.apache.parquet.column.ColumnDescriptor;
import hive.org.apache.parquet.column.page.PageReadStore;
import hive.org.apache.parquet.filter2.compat.FilterCompat;
import hive.org.apache.parquet.filter2.compat.RowGroupFilter;
import hive.org.apache.parquet.format.converter.ParquetMetadataConverter;
import hive.org.apache.parquet.hadoop.ParquetFileReader;
import hive.org.apache.parquet.hadoop.ParquetInputFormat;
import hive.org.apache.parquet.hadoop.ParquetInputSplit;
import hive.org.apache.parquet.hadoop.metadata.BlockMetaData;
import hive.org.apache.parquet.hadoop.metadata.ParquetMetadata;
import hive.org.apache.parquet.schema.InvalidSchemaException;
import hive.org.apache.parquet.schema.MessageType;
import hive.org.apache.parquet.schema.PrimitiveType;
import hive.org.apache.parquet.schema.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.io.parquet.ParquetRecordReaderBase;
import org.apache.hadoop.hive.ql.io.parquet.ProjectionPusher;
import org.apache.hadoop.hive.ql.io.parquet.read.DataWritableReadSupport;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedColumnReader;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedDummyColumnReader;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedListColumnReader;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedPrimitiveColumnReader;
import org.apache.hadoop.hive.ql.io.parquet.vector.VectorizedStructColumnReader;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorizedParquetRecordReader
extends ParquetRecordReaderBase
implements RecordReader<NullWritable, VectorizedRowBatch> {
    public static final Logger LOG = LoggerFactory.getLogger(VectorizedParquetRecordReader.class);
    private List<Integer> colsToInclude;
    protected MessageType fileSchema;
    protected MessageType requestedSchema;
    private List<String> columnNamesList;
    private List<TypeInfo> columnTypesList;
    private VectorizedRowBatchCtx rbCtx;
    private List<Integer> indexColumnsWanted;
    private Object[] partitionValues;
    private VectorizedColumnReader[] columnReaders;
    private long rowsReturned = 0L;
    private long totalCountLoadedSoFar = 0L;
    protected long totalRowCount = 0L;

    @VisibleForTesting
    public VectorizedParquetRecordReader(org.apache.hadoop.mapreduce.InputSplit inputSplit, JobConf conf) {
        try {
            this.serDeStats = new SerDeStats();
            this.projectionPusher = new ProjectionPusher();
            this.initialize(inputSplit, conf);
            this.colsToInclude = ColumnProjectionUtils.getReadColumnIDs((Configuration)conf);
            this.rbCtx = Utilities.getVectorizedRowBatchCtx((Configuration)conf);
        }
        catch (Throwable e) {
            LOG.error("Failed to create the vectorized reader due to exception " + e);
            throw new RuntimeException(e);
        }
    }

    public VectorizedParquetRecordReader(InputSplit oldInputSplit, JobConf conf) {
        try {
            this.serDeStats = new SerDeStats();
            this.projectionPusher = new ProjectionPusher();
            this.initialize((org.apache.hadoop.mapreduce.InputSplit)this.getSplit(oldInputSplit, conf), conf);
            this.colsToInclude = ColumnProjectionUtils.getReadColumnIDs((Configuration)conf);
            this.rbCtx = Utilities.getVectorizedRowBatchCtx((Configuration)conf);
            this.initPartitionValues((FileSplit)oldInputSplit, conf);
        }
        catch (Throwable e) {
            LOG.error("Failed to create the vectorized reader due to exception " + e);
            throw new RuntimeException(e);
        }
    }

    private void initPartitionValues(FileSplit fileSplit, JobConf conf) throws IOException {
        int partitionColumnCount = this.rbCtx.getPartitionColumnCount();
        if (partitionColumnCount > 0) {
            this.partitionValues = new Object[partitionColumnCount];
            VectorizedRowBatchCtx.getPartitionValues(this.rbCtx, (Configuration)conf, fileSplit, this.partitionValues);
        } else {
            this.partitionValues = null;
        }
    }

    public void initialize(org.apache.hadoop.mapreduce.InputSplit oldSplit, JobConf configuration) throws IOException, InterruptedException {
        MessageType tableSchema;
        int i;
        List<BlockMetaData> blocks;
        Object filter;
        ParquetMetadata footer;
        if (oldSplit == null) {
            return;
        }
        this.jobConf = configuration;
        ParquetInputSplit split = (ParquetInputSplit)oldSplit;
        boolean indexAccess = configuration.getBoolean("parquet.column.index.access", false);
        this.file = split.getPath();
        long[] rowGroupOffsets = split.getRowGroupOffsets();
        String columnNames = configuration.get("columns");
        this.columnNamesList = DataWritableReadSupport.getColumnNames(columnNames);
        String columnTypes = configuration.get("columns.types");
        this.columnTypesList = DataWritableReadSupport.getColumnTypes(columnTypes);
        if (rowGroupOffsets == null) {
            footer = ParquetFileReader.readFooter((Configuration)configuration, this.file, ParquetMetadataConverter.range(split.getStart(), split.getEnd()));
            MessageType fileSchema = footer.getFileMetaData().getSchema();
            filter = ParquetInputFormat.getFilter((Configuration)configuration);
            blocks = RowGroupFilter.filterRowGroups((FilterCompat.Filter)filter, footer.getBlocks(), fileSchema);
        } else {
            footer = ParquetFileReader.readFooter((Configuration)configuration, this.file, ParquetMetadataConverter.NO_FILTER);
            HashSet<Long> offsets = new HashSet<Long>();
            for (long offset : rowGroupOffsets) {
                offsets.add(offset);
            }
            blocks = new ArrayList<BlockMetaData>();
            filter = footer.getBlocks().iterator();
            while (filter.hasNext()) {
                BlockMetaData block = (BlockMetaData)filter.next();
                if (!offsets.contains(block.getStartingPos())) continue;
                blocks.add(block);
            }
            if (blocks.size() != rowGroupOffsets.length) {
                long[] foundRowGroupOffsets = new long[footer.getBlocks().size()];
                for (i = 0; i < foundRowGroupOffsets.length; ++i) {
                    foundRowGroupOffsets[i] = footer.getBlocks().get(i).getStartingPos();
                }
                throw new IllegalStateException("All the offsets listed in the split should be found in the file. expected: " + Arrays.toString(rowGroupOffsets) + " found: " + blocks + " out of: " + Arrays.toString(foundRowGroupOffsets) + " in range " + split.getStart() + ", " + split.getEnd());
            }
        }
        for (BlockMetaData block : blocks) {
            this.totalRowCount += block.getRowCount();
        }
        this.fileSchema = footer.getFileMetaData().getSchema();
        if (indexAccess) {
            ArrayList<Integer> indexSequence = new ArrayList<Integer>();
            for (i = 0; i < this.columnNamesList.size(); ++i) {
                indexSequence.add(i);
            }
            tableSchema = DataWritableReadSupport.getSchemaByIndex(this.fileSchema, this.columnNamesList, indexSequence);
        } else {
            tableSchema = DataWritableReadSupport.getSchemaByName(this.fileSchema, this.columnNamesList, this.columnTypesList);
        }
        this.indexColumnsWanted = ColumnProjectionUtils.getReadColumnIDs((Configuration)configuration);
        this.requestedSchema = !ColumnProjectionUtils.isReadAllColumns((Configuration)configuration) && !this.indexColumnsWanted.isEmpty() ? DataWritableReadSupport.getSchemaByIndex(tableSchema, this.columnNamesList, this.indexColumnsWanted) : this.fileSchema;
        this.reader = new ParquetFileReader((Configuration)configuration, footer.getFileMetaData(), this.file, blocks, this.requestedSchema.getColumns());
    }

    public boolean next(NullWritable nullWritable, VectorizedRowBatch vectorizedRowBatch) throws IOException {
        return this.nextBatch(vectorizedRowBatch);
    }

    public NullWritable createKey() {
        return NullWritable.get();
    }

    public VectorizedRowBatch createValue() {
        return this.rbCtx.createVectorizedRowBatch();
    }

    public long getPos() throws IOException {
        return 0L;
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
        }
    }

    public float getProgress() throws IOException {
        return 0.0f;
    }

    private boolean nextBatch(VectorizedRowBatch columnarBatch) throws IOException {
        columnarBatch.reset();
        if (this.rowsReturned >= this.totalRowCount) {
            return false;
        }
        if (this.partitionValues != null) {
            this.rbCtx.addPartitionColsToBatch(columnarBatch, this.partitionValues);
        }
        this.checkEndOfRowGroup();
        int num = (int)Math.min(1024L, this.totalCountLoadedSoFar - this.rowsReturned);
        if (this.colsToInclude.size() > 0) {
            for (int i = 0; i < this.columnReaders.length; ++i) {
                if (this.columnReaders[i] == null) continue;
                columnarBatch.cols[this.colsToInclude.get((int)i).intValue()].isRepeating = true;
                this.columnReaders[i].readBatch(num, columnarBatch.cols[this.colsToInclude.get(i)], this.columnTypesList.get(this.colsToInclude.get(i)));
            }
        }
        this.rowsReturned += (long)num;
        columnarBatch.size = num;
        return true;
    }

    private void checkEndOfRowGroup() throws IOException {
        if (this.rowsReturned != this.totalCountLoadedSoFar) {
            return;
        }
        PageReadStore pages = this.reader.readNextRowGroup();
        if (pages == null) {
            throw new IOException("expecting more rows but reached last block. Read " + this.rowsReturned + " out of " + this.totalRowCount);
        }
        List<ColumnDescriptor> columns = this.requestedSchema.getColumns();
        List<Type> types = this.requestedSchema.getFields();
        this.columnReaders = new VectorizedColumnReader[columns.size()];
        if (!ColumnProjectionUtils.isReadAllColumns((Configuration)this.jobConf) && !this.indexColumnsWanted.isEmpty()) {
            for (int i = 0; i < types.size(); ++i) {
                this.columnReaders[i] = this.buildVectorizedParquetReader(this.columnTypesList.get(this.indexColumnsWanted.get(i)), types.get(i), pages, this.requestedSchema.getColumns(), this.skipTimestampConversion, 0);
            }
        } else {
            for (int i = 0; i < types.size(); ++i) {
                this.columnReaders[i] = this.buildVectorizedParquetReader(this.columnTypesList.get(i), types.get(i), pages, this.requestedSchema.getColumns(), this.skipTimestampConversion, 0);
            }
        }
        this.totalCountLoadedSoFar += pages.getRowCount();
    }

    private List<ColumnDescriptor> getAllColumnDescriptorByType(int depth, Type type, List<ColumnDescriptor> columns) throws ParquetRuntimeException {
        ArrayList<ColumnDescriptor> res = new ArrayList<ColumnDescriptor>();
        for (ColumnDescriptor descriptor : columns) {
            if (depth >= descriptor.getPath().length) {
                throw new InvalidSchemaException("Corrupted Parquet schema");
            }
            if (!type.getName().equals(descriptor.getPath()[depth])) continue;
            res.add(descriptor);
        }
        return res;
    }

    private PrimitiveType getElementType(Type type) {
        if (type.isPrimitive()) {
            return type.asPrimitiveType();
        }
        if (type.asGroupType().getFields().size() > 1) {
            throw new RuntimeException("Current Parquet Vectorization reader doesn't support nested type");
        }
        return type.asGroupType().getFields().get(0).asGroupType().getFields().get(0).asPrimitiveType();
    }

    private VectorizedColumnReader buildVectorizedParquetReader(TypeInfo typeInfo, Type type, PageReadStore pages, List<ColumnDescriptor> columnDescriptors, boolean skipTimestampConversion, int depth) throws IOException {
        List<ColumnDescriptor> descriptors = this.getAllColumnDescriptorByType(depth, type, columnDescriptors);
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                if (columnDescriptors == null || columnDescriptors.isEmpty()) {
                    throw new RuntimeException("Failed to find related Parquet column descriptor with type " + type);
                }
                if (this.fileSchema.getColumns().contains(descriptors.get(0))) {
                    return new VectorizedPrimitiveColumnReader(descriptors.get(0), pages.getPageReader(descriptors.get(0)), skipTimestampConversion, type, typeInfo);
                }
                return new VectorizedDummyColumnReader();
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                ArrayList<VectorizedColumnReader> fieldReaders = new ArrayList<VectorizedColumnReader>();
                ArrayList<TypeInfo> fieldTypes = structTypeInfo.getAllStructFieldTypeInfos();
                List<Type> types = type.asGroupType().getFields();
                for (int i = 0; i < fieldTypes.size(); ++i) {
                    VectorizedColumnReader r = this.buildVectorizedParquetReader((TypeInfo)fieldTypes.get(i), types.get(i), pages, descriptors, skipTimestampConversion, depth + 1);
                    if (r == null) {
                        throw new RuntimeException("Fail to build Parquet vectorized reader based on Hive type " + ((TypeInfo)fieldTypes.get(i)).getTypeName() + " and Parquet type" + types.get(i).toString());
                    }
                    fieldReaders.add(r);
                }
                return new VectorizedStructColumnReader(fieldReaders);
            }
            case LIST: {
                this.checkListColumnSupport(((ListTypeInfo)typeInfo).getListElementTypeInfo());
                if (columnDescriptors == null || columnDescriptors.isEmpty()) {
                    throw new RuntimeException("Failed to find related Parquet column descriptor with type " + type);
                }
                return new VectorizedListColumnReader(descriptors.get(0), pages.getPageReader(descriptors.get(0)), skipTimestampConversion, this.getElementType(type), typeInfo);
            }
        }
        throw new RuntimeException("Unsupported category " + typeInfo.getCategory().name());
    }

    private void checkListColumnSupport(TypeInfo elementType) {
        if (elementType instanceof PrimitiveTypeInfo) {
            switch (((PrimitiveTypeInfo)elementType).getPrimitiveCategory()) {
                case INTERVAL_DAY_TIME: 
                case TIMESTAMP: {
                    throw new RuntimeException("Unsupported primitive type used in list:: " + elementType);
                }
            }
        } else {
            throw new RuntimeException("Unsupported type used in list:" + elementType);
        }
    }
}

