/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.merge;

import hive.org.apache.commons.lang.StringUtils;
import java.io.IOException;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHelper;
import org.apache.hadoop.hive.ql.exec.mr.HadoopJobExecHook;
import org.apache.hadoop.hive.ql.exec.mr.Throttle;
import org.apache.hadoop.hive.ql.io.HiveFileFormatUtils;
import org.apache.hadoop.hive.ql.io.HiveOutputFormatImpl;
import org.apache.hadoop.hive.ql.io.merge.MergeFileMapper;
import org.apache.hadoop.hive.ql.io.merge.MergeFileWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;

public class MergeFileTask
extends Task<MergeFileWork>
implements Serializable,
HadoopJobExecHook {
    private transient JobConf job;
    private HadoopJobExecHelper jobExecHelper;
    private boolean success = true;

    @Override
    public void initialize(QueryState queryState, QueryPlan queryPlan, DriverContext driverContext, CompilationOpContext opContext) {
        super.initialize(queryState, queryPlan, driverContext, opContext);
        this.job = new JobConf((Configuration)this.conf, MergeFileTask.class);
        this.jobExecHelper = new HadoopJobExecHelper(this.job, this.console, this, this);
    }

    @Override
    public boolean requireLock() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int execute(DriverContext driverContext) {
        Context ctx = driverContext.getCtx();
        boolean ctxCreated = false;
        RunningJob rj = null;
        int returnVal = 0;
        try {
            if (ctx == null) {
                ctx = new Context((Configuration)this.job);
                ctxCreated = true;
            }
            HiveFileFormatUtils.prepareJobOutput(this.job);
            this.job.setInputFormat(((MergeFileWork)this.work).getInputformatClass());
            this.job.setOutputFormat(HiveOutputFormatImpl.class);
            this.job.setMapperClass(MergeFileMapper.class);
            this.job.setMapOutputKeyClass(NullWritable.class);
            this.job.setMapOutputValueClass(NullWritable.class);
            this.job.setOutputKeyClass(NullWritable.class);
            this.job.setOutputValueClass(NullWritable.class);
            this.job.setNumReduceTasks(0);
            Object outputPath = ((MergeFileWork)this.work).getOutputDir();
            Path path = Utilities.toTempPath((Path)outputPath);
            FileSystem fs = path.getFileSystem((Configuration)this.job);
            if (!fs.exists(path)) {
                fs.mkdirs(path);
            }
            ExecDriver.propagateSplitSettings(this.job, (MapWork)this.work);
            boolean noName = StringUtils.isEmpty(this.job.get("mapreduce.job.name"));
            String jobName = null;
            if (noName && this.getQueryPlan() != null) {
                int maxlen = this.conf.getIntVar(HiveConf.ConfVars.HIVEJOBNAMELENGTH);
                jobName = Utilities.abbreviate(this.getQueryPlan().getQueryStr(), maxlen - 6);
            }
            if (noName) {
                this.job.set("mapreduce.job.name", jobName != null ? jobName : "JOB" + Utilities.randGen.nextInt());
            }
            this.addInputPaths(this.job, (MergeFileWork)this.work);
            Utilities.setMapWork((Configuration)this.job, (MapWork)this.work, ctx.getMRTmpPath(), true);
            String pwd = HiveConf.getVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD);
            if (pwd != null) {
                HiveConf.setVar((Configuration)this.job, HiveConf.ConfVars.METASTOREPWD, "HIVE");
            }
            JobClient jc = new JobClient(this.job);
            String addedJars = Utilities.getResourceFiles((Configuration)this.job, SessionState.ResourceType.JAR);
            if (!addedJars.isEmpty()) {
                this.job.set("tmpjars", addedJars);
            }
            Throttle.checkJobTracker(this.job, LOG);
            rj = jc.submitJob(this.job);
            this.jobID = rj.getJobID();
            this.saveJobIdToFile();
            returnVal = this.jobExecHelper.progress(rj, jc, ctx);
            this.success = returnVal == 0;
            try {
                if (ctxCreated) {
                    ctx.clear();
                }
                if (rj != null) {
                    if (returnVal != 0) {
                        rj.killJob();
                    }
                    this.deleteFileWithJobId();
                }
                if (rj == null) return returnVal;
                if (((MergeFileWork)this.work).getAliasToWork() == null) return returnVal;
                outputPath = ((MergeFileWork)this.work).getAliasToWork().values().iterator();
                while (outputPath.hasNext()) {
                    Operator operator = (Operator)outputPath.next();
                    operator.jobClose((Configuration)this.job, this.success);
                }
                return returnVal;
            }
            catch (Exception e) {
                LOG.warn("Job close failed ", e);
                if (!this.success) return returnVal;
                this.setException(e);
                this.success = false;
                returnVal = 3;
                String string = "Job Commit failed with exception '" + Utilities.getNameMessage(e) + "'";
                this.console.printError(string, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                return returnVal;
            }
            finally {
                HadoopJobExecHelper.runningJobs.remove(rj);
            }
        }
        catch (Exception e) {
            void var7_18;
            this.setException(e);
            String string = " with exception '" + Utilities.getNameMessage(e) + "'";
            if (rj != null) {
                String string2 = "Ended Job = " + rj.getJobID() + string;
            } else {
                String string3 = "Job Submission failed" + string;
            }
            this.console.printError((String)var7_18, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            this.success = false;
            returnVal = 1;
            return returnVal;
        }
        finally {
            try {
                if (ctxCreated) {
                    ctx.clear();
                }
                if (rj != null) {
                    if (returnVal != 0) {
                        rj.killJob();
                    }
                    this.deleteFileWithJobId();
                }
                if (rj != null && ((MergeFileWork)this.work).getAliasToWork() != null) {
                    for (Operator<? extends OperatorDesc> operator : ((MergeFileWork)this.work).getAliasToWork().values()) {
                        operator.jobClose((Configuration)this.job, this.success);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Job close failed ", e);
                if (this.success) {
                    this.setException(e);
                    this.success = false;
                    returnVal = 3;
                    String string = "Job Commit failed with exception '" + Utilities.getNameMessage(e) + "'";
                    this.console.printError(string, "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
                }
            }
            finally {
                HadoopJobExecHelper.runningJobs.remove(rj);
            }
        }
    }

    private void addInputPaths(JobConf job, MergeFileWork work) {
        for (Path path : work.getInputPaths()) {
            FileInputFormat.addInputPath((JobConf)job, (Path)path);
        }
    }

    @Override
    public String getName() {
        return "MergeFileTask";
    }

    @Override
    public StageType getType() {
        return StageType.MAPRED;
    }

    @Override
    public boolean checkFatalErrors(Counters ctrs, StringBuilder errMsg) {
        return false;
    }

    @Override
    public void logPlanProgress(SessionState ss) throws IOException {
    }
}

