/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.values.deltalengthbytearray;

import hive.org.apache.parquet.column.values.ValuesReader;
import hive.org.apache.parquet.column.values.delta.DeltaBinaryPackingValuesReader;
import hive.org.apache.parquet.io.api.Binary;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaLengthByteArrayValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(DeltaLengthByteArrayValuesReader.class);
    private ValuesReader lengthReader = new DeltaBinaryPackingValuesReader();
    private byte[] in;
    private int offset;

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        LOG.debug("init from page at offset {} for length {}", (Object)offset, (Object)(in.length - offset));
        this.lengthReader.initFromPage(valueCount, in, offset);
        offset = this.lengthReader.getNextOffset();
        this.in = in;
        this.offset = offset;
    }

    @Override
    public Binary readBytes() {
        int length = this.lengthReader.readInteger();
        int start = this.offset;
        this.offset = start + length;
        return Binary.fromConstantByteArray(this.in, start, length);
    }

    @Override
    public void skip() {
        int length = this.lengthReader.readInteger();
        this.offset += length;
    }
}

