/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy;

import java.nio.charset.CharacterCodingException;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.primitive.LazyFloatObjectInspector;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LazyFloat
extends LazyPrimitive<LazyFloatObjectInspector, FloatWritable> {
    private static final Logger LOG = LoggerFactory.getLogger(LazyFloat.class);

    public LazyFloat(LazyFloatObjectInspector oi) {
        super(oi);
        this.data = new FloatWritable();
    }

    public LazyFloat(LazyFloat copy) {
        super(copy);
        this.data = new FloatWritable(((FloatWritable)copy.data).get());
    }

    @Override
    public void init(ByteArrayRef bytes, int start, int length) {
        String byteData = null;
        if (!LazyUtils.isNumberMaybe(bytes.getData(), start, length)) {
            this.isNull = true;
            return;
        }
        try {
            byteData = Text.decode((byte[])bytes.getData(), (int)start, (int)length);
            ((FloatWritable)this.data).set(Float.parseFloat(byteData));
            this.isNull = false;
        }
        catch (NumberFormatException e) {
            this.isNull = true;
            LOG.debug("Data not in the Float data type range so converted to null. Given data is :" + byteData, e);
        }
        catch (CharacterCodingException e) {
            this.isNull = true;
            LOG.debug("Data not in the Float data type range so converted to null.", e);
        }
    }
}

