/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.session;

import java.io.IOException;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hive.com.google.common.annotations.VisibleForTesting;

final class ClearScratchDirUtil {
    private ClearScratchDirUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean hasActiveJobs(FileSystem fs, Path activeJobsPath, HiveConf conf) throws IOException {
        try (JobClient jobClient = new JobClient((Configuration)conf);){
            boolean bl = ClearScratchDirUtil.hasActiveJobs(fs, activeJobsPath, jobClient);
            return bl;
        }
    }

    @VisibleForTesting
    static boolean hasActiveJobs(FileSystem fs, Path activeJobsPath, JobClient jobClient) throws IOException {
        if (fs.exists(activeJobsPath)) {
            RemoteIterator activeJobs = fs.listFiles(activeJobsPath, false);
            while (activeJobs.hasNext()) {
                RunningJob runningJob = jobClient.getJob(JobID.forName((String)((LocatedFileStatus)activeJobs.next()).getPath().getName()));
                if (runningJob == null || runningJob.isComplete()) continue;
                return true;
            }
        }
        return false;
    }

    static boolean hasActiveApps(FileSystem fs, Path activeAppsPath, HiveConf conf) throws IOException, YarnException {
        try (YarnClient yarnClient = YarnClient.createYarnClient();){
            yarnClient.init((Configuration)conf);
            yarnClient.start();
            boolean bl = ClearScratchDirUtil.hasActiveApps(fs, activeAppsPath, yarnClient);
            return bl;
        }
    }

    @VisibleForTesting
    static boolean hasActiveApps(FileSystem fs, Path activeAppsPath, YarnClient yarnClient) throws IOException, YarnException {
        if (fs.exists(activeAppsPath)) {
            RemoteIterator activeApps = fs.listFiles(activeAppsPath, false);
            while (activeApps.hasNext()) {
                ApplicationId applicationId = ClearScratchDirUtil.parseFrom(((LocatedFileStatus)activeApps.next()).getPath().getName());
                ApplicationReport applicationReport = yarnClient.getApplicationReport(applicationId);
                YarnApplicationState state = applicationReport.getYarnApplicationState();
                YarnApplicationState[] done = new YarnApplicationState[]{YarnApplicationState.FINISHED, YarnApplicationState.FAILED, YarnApplicationState.KILLED};
                if (Arrays.asList(done).contains(state)) continue;
                return true;
            }
        }
        return false;
    }

    static ApplicationId parseFrom(String appIdAsString) {
        String[] rawData = appIdAsString.split("\\_");
        long clusterTimestamp = Long.parseLong(rawData[1]);
        int id = Integer.parseInt(rawData[2]);
        return ApplicationId.newInstance((long)clusterTimestamp, (int)id);
    }
}

