/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TableUtils {
    private static final Logger LOG = LoggerFactory.getLogger(TableUtils.class.getName());

    private TableUtils() {
    }

    public static Table findTable(ASTNode tree, HiveConf conf) throws SemanticException {
        try {
            return TableUtils.findTable(tree, Hive.get(conf));
        }
        catch (HiveException e) {
            throw new SemanticException(e.getMessage(), e);
        }
    }

    public static Table findTable(ASTNode tree, Hive db) throws SemanticException {
        Table mTable;
        boolean isMerge = tree.getType() == 820;
        List children = tree.getChildren();
        ASTNode astNode = (ASTNode)children.get(0);
        if (isMerge) {
            astNode = (ASTNode)((ArrayList)astNode.getChildren()).get(0);
        }
        String[] tableName = BaseSemanticAnalyzer.getQualifiedTableName(astNode);
        try {
            mTable = db.getTable(tableName[0], tableName[1]);
        }
        catch (InvalidTableException e) {
            LOG.error("Failed to find table " + BaseSemanticAnalyzer.getDotName(tableName) + " got exception " + e.getMessage());
            throw new SemanticException(ErrorMsg.INVALID_TABLE.getMsg(BaseSemanticAnalyzer.getDotName(tableName)), e);
        }
        catch (HiveException e) {
            LOG.error("Failed to find table " + BaseSemanticAnalyzer.getDotName(tableName) + " got exception " + e.getMessage());
            throw new SemanticException(e.getMessage(), e);
        }
        return mTable;
    }

    public static void verifyLocation(String location) {
        if (location != null && location.contains("hdfs")) {
            LOG.warn("hdfs:// is deprecated filesystem and will be removed in future releases. Use maprfs:// instead");
        }
    }
}

