/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public class CastDecimalToDecimal
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    int inputColumn;
    int outputColumn;

    public CastDecimalToDecimal(int inputColumn, int outputColumn) {
        this.inputColumn = inputColumn;
        this.outputColumn = outputColumn;
        this.outputType = "decimal";
    }

    public CastDecimalToDecimal() {
        this.outputType = "decimal";
    }

    protected void convert(DecimalColumnVector outV, DecimalColumnVector inV, int i) {
        outV.vector[i].set(inV.vector[i]);
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inV = (DecimalColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        DecimalColumnVector outV = (DecimalColumnVector)batch.cols[this.outputColumn];
        boolean[] outputIsNull = outV.isNull;
        if (n == 0) {
            return;
        }
        outV.isRepeating = false;
        if (inV.isRepeating) {
            outV.isRepeating = true;
            if (inV.noNulls || !inV.isNull[0]) {
                outV.isNull[0] = false;
                this.convert(outV, inV, 0);
            } else {
                outV.isNull[0] = true;
                outV.noNulls = false;
            }
            return;
        }
        if (inV.noNulls) {
            if (batch.selectedInUse) {
                if (!outV.noNulls) {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        outputIsNull[i] = false;
                        this.convert(outV, inV, i);
                    }
                } else {
                    for (int j = 0; j != n; ++j) {
                        int i = sel[j];
                        this.convert(outV, inV, i);
                    }
                }
            } else {
                if (!outV.noNulls) {
                    Arrays.fill(outputIsNull, false);
                    outV.noNulls = true;
                }
                for (int i = 0; i != n; ++i) {
                    this.convert(outV, inV, i);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i = sel[j];
                if (!inV.isNull[i]) {
                    outV.isNull[i] = false;
                    this.convert(outV, inV, i);
                    continue;
                }
                outV.isNull[i] = true;
                outV.noNulls = false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                if (!inV.isNull[i]) {
                    outV.isNull[i] = false;
                    this.convert(outV, inV, i);
                    continue;
                }
                outV.isNull[i] = true;
                outV.noNulls = false;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    public void setOutputColumn(int outputColumn) {
        this.outputColumn = outputColumn;
    }

    public int getInputColumn() {
        return this.inputColumn;
    }

    public void setInputColumn(int inputColumn) {
        this.inputColumn = inputColumn;
    }

    @Override
    public String vectorExpressionParameters() {
        return "col " + this.inputColumn;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DECIMAL).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

