/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.hadoop.io;

import hive.org.apache.avro.Schema;
import hive.org.apache.avro.generic.GenericData;
import hive.org.apache.avro.hadoop.io.AvroKeyDeserializer;
import hive.org.apache.avro.hadoop.io.AvroSerializer;
import hive.org.apache.avro.hadoop.io.AvroValueDeserializer;
import hive.org.apache.avro.io.DatumReader;
import hive.org.apache.avro.io.DatumWriter;
import hive.org.apache.avro.mapred.AvroKey;
import hive.org.apache.avro.mapred.AvroValue;
import hive.org.apache.avro.mapred.AvroWrapper;
import hive.org.apache.avro.reflect.ReflectData;
import java.lang.reflect.Constructor;
import java.util.Collection;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.serializer.Deserializer;
import org.apache.hadoop.io.serializer.Serialization;
import org.apache.hadoop.io.serializer.Serializer;
import org.apache.hadoop.util.ReflectionUtils;

public class AvroSerialization<T>
extends Configured
implements Serialization<AvroWrapper<T>> {
    private static final String CONF_KEY_WRITER_SCHEMA = "avro.serialization.key.writer.schema";
    private static final String CONF_KEY_READER_SCHEMA = "avro.serialization.key.reader.schema";
    private static final String CONF_VALUE_WRITER_SCHEMA = "avro.serialization.value.writer.schema";
    private static final String CONF_VALUE_READER_SCHEMA = "avro.serialization.value.reader.schema";
    private static final String CONF_DATA_MODEL = "avro.serialization.data.model";

    public boolean accept(Class<?> c) {
        return AvroKey.class.isAssignableFrom(c) || AvroValue.class.isAssignableFrom(c);
    }

    public Deserializer<AvroWrapper<T>> getDeserializer(Class<AvroWrapper<T>> c) {
        Configuration conf = this.getConf();
        GenericData dataModel = AvroSerialization.createDataModel(conf);
        if (AvroKey.class.isAssignableFrom(c)) {
            Schema writerSchema = AvroSerialization.getKeyWriterSchema(conf);
            Schema readerSchema = AvroSerialization.getKeyReaderSchema(conf);
            DatumReader datumReader = readerSchema != null ? dataModel.createDatumReader(writerSchema, readerSchema) : dataModel.createDatumReader(writerSchema);
            return new AvroKeyDeserializer(writerSchema, readerSchema, datumReader);
        }
        if (AvroValue.class.isAssignableFrom(c)) {
            Schema writerSchema = AvroSerialization.getValueWriterSchema(conf);
            Schema readerSchema = AvroSerialization.getValueReaderSchema(conf);
            DatumReader datumReader = readerSchema != null ? dataModel.createDatumReader(writerSchema, readerSchema) : dataModel.createDatumReader(writerSchema);
            return new AvroValueDeserializer(writerSchema, readerSchema, datumReader);
        }
        throw new IllegalStateException("Only AvroKey and AvroValue are supported.");
    }

    public Serializer<AvroWrapper<T>> getSerializer(Class<AvroWrapper<T>> c) {
        Schema schema;
        Configuration conf = this.getConf();
        if (AvroKey.class.isAssignableFrom(c)) {
            schema = AvroSerialization.getKeyWriterSchema(conf);
        } else if (AvroValue.class.isAssignableFrom(c)) {
            schema = AvroSerialization.getValueWriterSchema(conf);
        } else {
            throw new IllegalStateException("Only AvroKey and AvroValue are supported.");
        }
        GenericData dataModel = AvroSerialization.createDataModel(conf);
        DatumWriter datumWriter = dataModel.createDatumWriter(schema);
        return new AvroSerializer(schema, datumWriter);
    }

    public static void addToConfiguration(Configuration conf) {
        Collection serializations = conf.getStringCollection("io.serializations");
        if (!serializations.contains(AvroSerialization.class.getName())) {
            serializations.add(AvroSerialization.class.getName());
            conf.setStrings("io.serializations", serializations.toArray(new String[serializations.size()]));
        }
    }

    public static void setKeyWriterSchema(Configuration conf, Schema schema) {
        if (null == schema) {
            throw new IllegalArgumentException("Writer schema may not be null");
        }
        conf.set(CONF_KEY_WRITER_SCHEMA, schema.toString());
    }

    public static void setKeyReaderSchema(Configuration conf, Schema schema) {
        conf.set(CONF_KEY_READER_SCHEMA, schema.toString());
    }

    public static void setValueWriterSchema(Configuration conf, Schema schema) {
        if (null == schema) {
            throw new IllegalArgumentException("Writer schema may not be null");
        }
        conf.set(CONF_VALUE_WRITER_SCHEMA, schema.toString());
    }

    public static void setValueReaderSchema(Configuration conf, Schema schema) {
        conf.set(CONF_VALUE_READER_SCHEMA, schema.toString());
    }

    public static void setDataModelClass(Configuration conf, Class<? extends GenericData> modelClass) {
        conf.setClass(CONF_DATA_MODEL, modelClass, GenericData.class);
    }

    public static Schema getKeyWriterSchema(Configuration conf) {
        String json = conf.get(CONF_KEY_WRITER_SCHEMA);
        return null == json ? null : Schema.parse(json);
    }

    public static Schema getKeyReaderSchema(Configuration conf) {
        String json = conf.get(CONF_KEY_READER_SCHEMA);
        return null == json ? null : Schema.parse(json);
    }

    public static Schema getValueWriterSchema(Configuration conf) {
        String json = conf.get(CONF_VALUE_WRITER_SCHEMA);
        return null == json ? null : Schema.parse(json);
    }

    public static Schema getValueReaderSchema(Configuration conf) {
        String json = conf.get(CONF_VALUE_READER_SCHEMA);
        return null == json ? null : Schema.parse(json);
    }

    public static Class<? extends GenericData> getDataModelClass(Configuration conf) {
        return conf.getClass(CONF_DATA_MODEL, ReflectData.class, GenericData.class);
    }

    private static GenericData newDataModelInstance(Class<? extends GenericData> modelClass, Configuration conf) {
        GenericData dataModel;
        try {
            Constructor<? extends GenericData> ctor = modelClass.getDeclaredConstructor(ClassLoader.class);
            ctor.setAccessible(true);
            dataModel = ctor.newInstance(conf.getClassLoader());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ReflectionUtils.setConf((Object)dataModel, (Configuration)conf);
        return dataModel;
    }

    public static GenericData createDataModel(Configuration conf) {
        Class<GenericData> modelClass = AvroSerialization.getDataModelClass(conf);
        return AvroSerialization.newDataModelInstance(modelClass, conf);
    }
}

