/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hive.spark.client.rpc;

import hive.com.google.common.annotations.VisibleForTesting;
import hive.com.google.common.base.Preconditions;
import hive.com.google.common.base.Throwables;
import hive.com.google.common.collect.Lists;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hive.spark.client.rpc.KryoMessageCodec;
import org.apache.hive.spark.client.rpc.RpcConfiguration;
import org.apache.hive.spark.client.rpc.RpcDispatcher;
import org.apache.hive.spark.client.rpc.SaslHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class Rpc
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(Rpc.class);
    static final String SASL_REALM = "rsc";
    static final String SASL_USER = "rsc";
    static final String SASL_PROTOCOL = "rsc";
    static final String SASL_AUTH_CONF = "auth-conf";
    private final RpcConfiguration config;
    private final AtomicBoolean rpcClosed;
    private final AtomicLong rpcId;
    private final Channel channel;
    private final Collection<Listener> listeners;
    private final EventExecutorGroup egroup;
    private volatile RpcDispatcher dispatcher;

    public static Promise<Rpc> createClient(Map<String, String> config, final NioEventLoopGroup eloop, String host, int port, final String clientId, final String secret, final RpcDispatcher dispatcher) throws Exception {
        final RpcConfiguration rpcConf = new RpcConfiguration(config);
        int connectTimeoutMs = (int)rpcConf.getConnectTimeoutMs();
        final ChannelFuture cf = ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eloop)).handler((ChannelHandler)new ChannelInboundHandlerAdapter(){})).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeoutMs)).connect(host, port);
        final Promise promise = eloop.next().newPromise();
        AtomicReference rpc = new AtomicReference();
        Runnable timeoutTask = new Runnable(){

            @Override
            public void run() {
                promise.setFailure((Throwable)new TimeoutException("Timed out waiting for RPC server connection."));
            }
        };
        final ScheduledFuture timeoutFuture = eloop.schedule(timeoutTask, (long)connectTimeoutMs, TimeUnit.MILLISECONDS);
        cf.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture cf) throws Exception {
                if (cf.isSuccess()) {
                    SaslClientHandler saslHandler = new SaslClientHandler(rpcConf, clientId, (Promise<Rpc>)promise, timeoutFuture, secret, dispatcher);
                    Rpc rpc = Rpc.createRpc(rpcConf, saslHandler, (SocketChannel)cf.channel(), (EventExecutorGroup)eloop);
                    saslHandler.rpc = rpc;
                    saslHandler.sendHello(cf.channel());
                } else {
                    promise.setFailure(cf.cause());
                }
            }
        });
        promise.addListener((GenericFutureListener)new GenericFutureListener<Promise<Rpc>>(){

            public void operationComplete(Promise<Rpc> p) {
                if (p.isCancelled()) {
                    cf.cancel(true);
                }
            }
        });
        return promise;
    }

    static Rpc createServer(SaslHandler saslHandler, RpcConfiguration config, SocketChannel channel, EventExecutorGroup egroup) throws IOException {
        return Rpc.createRpc(config, saslHandler, channel, egroup);
    }

    private static Rpc createRpc(RpcConfiguration config, SaslHandler saslHandler, SocketChannel client, EventExecutorGroup egroup) throws IOException {
        LogLevel logLevel = LogLevel.TRACE;
        if (config.getRpcChannelLogLevel() != null) {
            try {
                logLevel = LogLevel.valueOf((String)config.getRpcChannelLogLevel());
            }
            catch (Exception e) {
                LOG.warn("Invalid log level {}, reverting to default.", (Object)config.getRpcChannelLogLevel());
            }
        }
        boolean logEnabled = false;
        switch (logLevel) {
            case DEBUG: {
                logEnabled = LOG.isDebugEnabled();
                break;
            }
            case ERROR: {
                logEnabled = LOG.isErrorEnabled();
                break;
            }
            case INFO: {
                logEnabled = LOG.isInfoEnabled();
                break;
            }
            case TRACE: {
                logEnabled = LOG.isTraceEnabled();
                break;
            }
            case WARN: {
                logEnabled = LOG.isWarnEnabled();
            }
        }
        if (logEnabled) {
            client.pipeline().addLast("logger", (ChannelHandler)new LoggingHandler(Rpc.class, logLevel));
        }
        KryoMessageCodec kryo = new KryoMessageCodec(config.getMaxMessageSize(), MessageHeader.class, NullMessage.class, SaslMessage.class);
        saslHandler.setKryoMessageCodec(kryo);
        client.pipeline().addLast("codec", (ChannelHandler)kryo).addLast("sasl", (ChannelHandler)saslHandler);
        return new Rpc(config, (Channel)client, egroup);
    }

    @VisibleForTesting
    static Rpc createEmbedded(RpcDispatcher dispatcher) {
        EmbeddedChannel c = new EmbeddedChannel(new ChannelHandler[]{new LoggingHandler(Rpc.class), new KryoMessageCodec(0, MessageHeader.class, NullMessage.class), dispatcher});
        Rpc rpc = new Rpc(new RpcConfiguration(Collections.emptyMap()), (Channel)c, (EventExecutorGroup)ImmediateEventExecutor.INSTANCE);
        rpc.dispatcher = dispatcher;
        return rpc;
    }

    private Rpc(RpcConfiguration config, Channel channel, EventExecutorGroup egroup) {
        Preconditions.checkArgument(channel != null);
        Preconditions.checkArgument(egroup != null);
        this.config = config;
        this.channel = channel;
        this.dispatcher = null;
        this.egroup = egroup;
        this.listeners = Lists.newLinkedList();
        this.rpcClosed = new AtomicBoolean();
        this.rpcId = new AtomicLong();
        channel.pipeline().addLast("monitor", (ChannelHandler)new ChannelInboundHandlerAdapter(){

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                Rpc.this.close();
                super.channelInactive(ctx);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener l) {
        Collection<Listener> collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(l);
        }
    }

    public Future<Void> call(Object msg) {
        return this.call(msg, Void.class);
    }

    public boolean isActive() {
        return this.channel.isActive();
    }

    public <T> Future<T> call(final Object msg, Class<T> retType) {
        Preconditions.checkArgument(msg != null);
        Preconditions.checkState(this.channel.isActive(), "RPC channel is closed.");
        try {
            final long id = this.rpcId.getAndIncrement();
            final Promise<T> promise = this.createPromise();
            final ChannelFutureListener listener = new ChannelFutureListener(){

                public void operationComplete(ChannelFuture cf) {
                    if (!cf.isSuccess() && !promise.isDone()) {
                        LOG.warn("Failed to send RPC, closing connection.", cf.cause());
                        promise.setFailure(cf.cause());
                        Rpc.this.dispatcher.discardRpc(id);
                        Rpc.this.close();
                    }
                }
            };
            this.dispatcher.registerRpc(id, promise, msg.getClass().getName());
            this.channel.eventLoop().submit(new Runnable(){

                @Override
                public void run() {
                    Rpc.this.channel.write((Object)new MessageHeader(id, MessageType.CALL)).addListener((GenericFutureListener)listener);
                    Rpc.this.channel.writeAndFlush(msg).addListener((GenericFutureListener)listener);
                }
            });
            return promise;
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    public <T> Promise<T> createPromise() {
        return this.egroup.next().newPromise();
    }

    @VisibleForTesting
    Channel getChannel() {
        return this.channel;
    }

    void setDispatcher(RpcDispatcher dispatcher) {
        Preconditions.checkNotNull(dispatcher);
        Preconditions.checkState(this.dispatcher == null);
        this.dispatcher = dispatcher;
        this.channel.pipeline().addLast("dispatcher", (ChannelHandler)dispatcher);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.rpcClosed.compareAndSet(false, true)) {
            return;
        }
        try {
            this.channel.close().sync();
        }
        catch (InterruptedException ie) {
            Thread.interrupted();
        }
        finally {
            Collection<Listener> collection = this.listeners;
            synchronized (collection) {
                for (Listener l : this.listeners) {
                    try {
                        l.rpcClosed(this);
                    }
                    catch (Exception e) {
                        LOG.warn("Error caught in Rpc.Listener invocation.", (Throwable)e);
                    }
                }
            }
        }
    }

    private static class SaslClientHandler
    extends SaslHandler
    implements CallbackHandler {
        private final SaslClient client;
        private final String clientId;
        private final String secret;
        private final RpcDispatcher dispatcher;
        private Promise<Rpc> promise;
        private ScheduledFuture<?> timeout;
        private Rpc rpc;

        SaslClientHandler(RpcConfiguration config, String clientId, Promise<Rpc> promise, ScheduledFuture<?> timeout, String secret, RpcDispatcher dispatcher) throws IOException {
            super(config);
            this.clientId = clientId;
            this.promise = promise;
            this.timeout = timeout;
            this.secret = secret;
            this.dispatcher = dispatcher;
            this.client = Sasl.createSaslClient(new String[]{config.getSaslMechanism()}, null, "rsc", "rsc", config.getSaslOptions(), this);
        }

        @Override
        protected boolean isComplete() {
            return this.client.isComplete();
        }

        @Override
        protected String getNegotiatedProperty(String name) {
            return (String)this.client.getNegotiatedProperty(name);
        }

        @Override
        protected SaslMessage update(SaslMessage challenge) throws IOException {
            byte[] response = this.client.evaluateChallenge(challenge.payload);
            return response != null ? new SaslMessage(response) : null;
        }

        @Override
        public byte[] wrap(byte[] data, int offset, int len) throws IOException {
            return this.client.wrap(data, offset, len);
        }

        @Override
        public byte[] unwrap(byte[] data, int offset, int len) throws IOException {
            return this.client.unwrap(data, offset, len);
        }

        @Override
        public void dispose() throws IOException {
            if (!this.client.isComplete()) {
                this.onError(new SaslException("Client closed before SASL negotiation finished."));
            }
            this.client.dispose();
        }

        @Override
        protected void onComplete() throws Exception {
            this.timeout.cancel(true);
            this.rpc.setDispatcher(this.dispatcher);
            this.promise.setSuccess((Object)this.rpc);
            this.timeout = null;
            this.promise = null;
        }

        @Override
        protected void onError(Throwable error) {
            this.timeout.cancel(true);
            if (!this.promise.isDone()) {
                this.promise.setFailure(error);
            }
        }

        @Override
        public void handle(Callback[] callbacks) {
            for (Callback cb : callbacks) {
                if (cb instanceof NameCallback) {
                    ((NameCallback)cb).setName(this.clientId);
                    continue;
                }
                if (cb instanceof PasswordCallback) {
                    ((PasswordCallback)cb).setPassword(this.secret.toCharArray());
                    continue;
                }
                if (!(cb instanceof RealmCallback)) continue;
                RealmCallback rb = (RealmCallback)cb;
                rb.setText(rb.getDefaultText());
            }
        }

        void sendHello(Channel c) throws Exception {
            byte[] hello = this.client.hasInitialResponse() ? this.client.evaluateChallenge(new byte[0]) : new byte[]{};
            c.writeAndFlush((Object)new SaslMessage(this.clientId, hello));
        }
    }

    static class SaslMessage {
        final String clientId;
        final byte[] payload;

        SaslMessage() {
            this(null, null);
        }

        SaslMessage(byte[] payload) {
            this(null, payload);
        }

        SaslMessage(String clientId, byte[] payload) {
            this.clientId = clientId;
            this.payload = payload;
        }
    }

    static class NullMessage {
        NullMessage() {
        }
    }

    static class MessageHeader {
        final long id;
        final MessageType type;

        MessageHeader() {
            this(-1L, null);
        }

        MessageHeader(long id, MessageType type) {
            this.id = id;
            this.type = type;
        }
    }

    static enum MessageType {
        CALL,
        REPLY,
        ERROR;

    }

    public static interface Listener {
        public void rpcClosed(Rpc var1);
    }
}

