/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import hive.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedExpressions;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringRTrim;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseTrim;

@Description(name="rtrim", value="_FUNC_(str) - Removes the trailing space characters from str ", extended="Example:\n  > SELECT _FUNC_('facebook   ') FROM src LIMIT 1;\n  'facebook'")
@VectorizedExpressions(value={StringRTrim.class})
public class GenericUDFRTrim
extends GenericUDFBaseTrim {
    public GenericUDFRTrim() {
        super("rtrim");
    }

    @Override
    protected String performOp(String val) {
        return StringUtils.stripEnd(val, " ");
    }
}

