/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.security.authorization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.PrincipalPrivilegeSet;
import org.apache.hadoop.hive.metastore.api.PrivilegeGrantInfo;
import org.apache.hadoop.hive.ql.metadata.AuthorizationException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.security.authorization.HiveAuthorizationProviderBase;
import org.apache.hadoop.hive.ql.security.authorization.Privilege;

public abstract class BitSetCheckedAuthorizationProvider
extends HiveAuthorizationProviderBase {
    @Override
    public void authorize(Privilege[] inputRequiredPriv, Privilege[] outputRequiredPriv) throws HiveException, AuthorizationException {
        BitSetChecker checker = BitSetChecker.getBitSetChecker(inputRequiredPriv, outputRequiredPriv);
        boolean[] inputCheck = checker.inputCheck;
        boolean[] outputCheck = checker.outputCheck;
        this.authorizeUserPriv(inputRequiredPriv, inputCheck, outputRequiredPriv, outputCheck);
        this.checkAndThrowAuthorizationException(inputRequiredPriv, outputRequiredPriv, inputCheck, outputCheck, null, null, null, null);
    }

    @Override
    public void authorize(Path path, Privilege[] inputRequiredPriv, Privilege[] outputRequiredPriv) throws HiveException, AuthorizationException {
        BitSetChecker checker = BitSetChecker.getBitSetChecker(inputRequiredPriv, outputRequiredPriv);
        boolean[] inputCheck = checker.inputCheck;
        boolean[] outputCheck = checker.outputCheck;
        this.authorizeUserPriv(inputRequiredPriv, inputCheck, outputRequiredPriv, outputCheck);
        this.checkAndThrowAuthorizationException(inputRequiredPriv, outputRequiredPriv, inputCheck, outputCheck, null, null, null, null);
    }

    @Override
    public void authorize(Database db, Privilege[] inputRequiredPriv, Privilege[] outputRequiredPriv) throws HiveException, AuthorizationException {
        BitSetChecker checker = BitSetChecker.getBitSetChecker(inputRequiredPriv, outputRequiredPriv);
        boolean[] inputCheck = checker.inputCheck;
        boolean[] outputCheck = checker.outputCheck;
        this.authorizeUserAndDBPriv(db, inputRequiredPriv, outputRequiredPriv, inputCheck, outputCheck);
        this.checkAndThrowAuthorizationException(inputRequiredPriv, outputRequiredPriv, inputCheck, outputCheck, db.getName(), null, null, null);
    }

    @Override
    public void authorize(Table table, Privilege[] inputRequiredPriv, Privilege[] outputRequiredPriv) throws HiveException {
        BitSetChecker checker = BitSetChecker.getBitSetChecker(inputRequiredPriv, outputRequiredPriv);
        boolean[] inputCheck = checker.inputCheck;
        boolean[] outputCheck = checker.outputCheck;
        this.authorizeUserDBAndTable(table, inputRequiredPriv, outputRequiredPriv, inputCheck, outputCheck);
        this.checkAndThrowAuthorizationException(inputRequiredPriv, outputRequiredPriv, inputCheck, outputCheck, table.getDbName(), table.getTableName(), null, null);
    }

    @Override
    public void authorize(Partition part, Privilege[] inputRequiredPriv, Privilege[] outputRequiredPriv) throws HiveException {
        Table table = part.getTable();
        if (table.getParameters().get("PARTITION_LEVEL_PRIVILEGE") == null || "FALSE".equalsIgnoreCase(table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
            this.authorize(part.getTable(), inputRequiredPriv, outputRequiredPriv);
            return;
        }
        BitSetChecker checker = BitSetChecker.getBitSetChecker(inputRequiredPriv, outputRequiredPriv);
        boolean[] inputCheck = checker.inputCheck;
        boolean[] outputCheck = checker.outputCheck;
        if (this.authorizeUserDbAndPartition(part, inputRequiredPriv, outputRequiredPriv, inputCheck, outputCheck)) {
            return;
        }
        this.checkAndThrowAuthorizationException(inputRequiredPriv, outputRequiredPriv, inputCheck, outputCheck, part.getTable().getDbName(), part.getTable().getTableName(), part.getName(), null);
    }

    @Override
    public void authorize(Table table, Partition part, List<String> columns, Privilege[] inputRequiredPriv, Privilege[] outputRequiredPriv) throws HiveException {
        BitSetChecker checker = BitSetChecker.getBitSetChecker(inputRequiredPriv, outputRequiredPriv);
        boolean[] inputCheck = checker.inputCheck;
        boolean[] outputCheck = checker.outputCheck;
        String partName = null;
        List<String> partValues = null;
        if (part != null && table.getParameters().get("PARTITION_LEVEL_PRIVILEGE") != null && "TRUE".equalsIgnoreCase(table.getParameters().get("PARTITION_LEVEL_PRIVILEGE"))) {
            partName = part.getName();
            partValues = part.getValues();
        }
        if (partValues == null ? this.authorizeUserDBAndTable(table, inputRequiredPriv, outputRequiredPriv, inputCheck, outputCheck) : this.authorizeUserDbAndPartition(part, inputRequiredPriv, outputRequiredPriv, inputCheck, outputCheck)) {
            return;
        }
        for (String col : columns) {
            BitSetChecker checker2 = BitSetChecker.getBitSetChecker(inputRequiredPriv, outputRequiredPriv);
            boolean[] inputCheck2 = checker2.inputCheck;
            boolean[] outputCheck2 = checker2.outputCheck;
            PrincipalPrivilegeSet partColumnPrivileges = this.hive_db.get_privilege_set(HiveObjectType.COLUMN, table.getDbName(), table.getTableName(), partValues, col, this.getAuthenticator().getUserName(), this.getAuthenticator().getGroupNames());
            this.authorizePrivileges(partColumnPrivileges, inputRequiredPriv, inputCheck2, outputRequiredPriv, outputCheck2);
            if (inputCheck2 != null) {
                BitSetCheckedAuthorizationProvider.booleanArrayOr(inputCheck2, inputCheck);
            }
            if (outputCheck2 != null) {
                BitSetCheckedAuthorizationProvider.booleanArrayOr(inputCheck2, inputCheck);
            }
            this.checkAndThrowAuthorizationException(inputRequiredPriv, outputRequiredPriv, inputCheck2, outputCheck2, table.getDbName(), table.getTableName(), partName, col);
        }
    }

    protected boolean authorizeUserPriv(Privilege[] inputRequiredPriv, boolean[] inputCheck, Privilege[] outputRequiredPriv, boolean[] outputCheck) throws HiveException {
        PrincipalPrivilegeSet privileges = this.hive_db.get_privilege_set(HiveObjectType.GLOBAL, null, null, null, null, this.getAuthenticator().getUserName(), this.getAuthenticator().getGroupNames());
        return this.authorizePrivileges(privileges, inputRequiredPriv, inputCheck, outputRequiredPriv, outputCheck);
    }

    private boolean authorizeUserAndDBPriv(Database db, Privilege[] inputRequiredPriv, Privilege[] outputRequiredPriv, boolean[] inputCheck, boolean[] outputCheck) throws HiveException {
        if (this.authorizeUserPriv(inputRequiredPriv, inputCheck, outputRequiredPriv, outputCheck)) {
            return true;
        }
        PrincipalPrivilegeSet dbPrivileges = this.hive_db.get_privilege_set(HiveObjectType.DATABASE, db.getName(), null, null, null, this.getAuthenticator().getUserName(), this.getAuthenticator().getGroupNames());
        return this.authorizePrivileges(dbPrivileges, inputRequiredPriv, inputCheck, outputRequiredPriv, outputCheck);
    }

    private boolean authorizeUserDBAndTable(Table table, Privilege[] inputRequiredPriv, Privilege[] outputRequiredPriv, boolean[] inputCheck, boolean[] outputCheck) throws HiveException {
        if (this.authorizeUserAndDBPriv(this.hive_db.getDatabase(table.getDbName()), inputRequiredPriv, outputRequiredPriv, inputCheck, outputCheck)) {
            return true;
        }
        PrincipalPrivilegeSet tablePrivileges = this.hive_db.get_privilege_set(HiveObjectType.TABLE, table.getDbName(), table.getTableName(), null, null, this.getAuthenticator().getUserName(), this.getAuthenticator().getGroupNames());
        return this.authorizePrivileges(tablePrivileges, inputRequiredPriv, inputCheck, outputRequiredPriv, outputCheck);
    }

    private boolean authorizeUserDbAndPartition(Partition part, Privilege[] inputRequiredPriv, Privilege[] outputRequiredPriv, boolean[] inputCheck, boolean[] outputCheck) throws HiveException {
        if (this.authorizeUserAndDBPriv(this.hive_db.getDatabase(part.getTable().getDbName()), inputRequiredPriv, outputRequiredPriv, inputCheck, outputCheck)) {
            return true;
        }
        PrincipalPrivilegeSet partPrivileges = part.getTPartition().getPrivileges();
        if (partPrivileges == null) {
            partPrivileges = this.hive_db.get_privilege_set(HiveObjectType.PARTITION, part.getTable().getDbName(), part.getTable().getTableName(), part.getValues(), null, this.getAuthenticator().getUserName(), this.getAuthenticator().getGroupNames());
        }
        return this.authorizePrivileges(partPrivileges, inputRequiredPriv, inputCheck, outputRequiredPriv, outputCheck);
    }

    protected boolean authorizePrivileges(PrincipalPrivilegeSet privileges, Privilege[] inputPriv, boolean[] inputCheck, Privilege[] outputPriv, boolean[] outputCheck) throws HiveException {
        boolean pass = true;
        if (inputPriv != null) {
            boolean bl = pass = pass && this.matchPrivs(inputPriv, privileges, inputCheck);
        }
        if (outputPriv != null) {
            pass = pass && this.matchPrivs(outputPriv, privileges, outputCheck);
        }
        return pass;
    }

    private boolean matchPrivs(Privilege[] inputPriv, PrincipalPrivilegeSet privileges, boolean[] check) {
        Collection<List<PrivilegeGrantInfo>> rolePrivsCollection;
        List<String> rolePrivs;
        Collection<List<PrivilegeGrantInfo>> groupPrivCollection;
        List<String> groupPrivs;
        Collection<List<PrivilegeGrantInfo>> privCollection;
        List<String> userPrivs;
        if (inputPriv == null) {
            return true;
        }
        if (privileges == null) {
            return false;
        }
        HashSet<String> privSet = new HashSet<String>();
        if (privileges.getUserPrivileges() != null && privileges.getUserPrivileges().size() > 0 && (userPrivs = this.getPrivilegeStringList(privCollection = privileges.getUserPrivileges().values())) != null && userPrivs.size() > 0) {
            for (String priv : userPrivs) {
                if (priv == null || priv.trim().equals("")) continue;
                if (priv.equalsIgnoreCase(Privilege.ALL.toString())) {
                    BitSetCheckedAuthorizationProvider.setBooleanArray(check, true);
                    return true;
                }
                privSet.add(priv.toLowerCase());
            }
        }
        if (privileges.getGroupPrivileges() != null && privileges.getGroupPrivileges().size() > 0 && (groupPrivs = this.getPrivilegeStringList(groupPrivCollection = privileges.getGroupPrivileges().values())) != null && groupPrivs.size() > 0) {
            for (String priv : groupPrivs) {
                if (priv == null || priv.trim().equals("")) continue;
                if (priv.equalsIgnoreCase(Privilege.ALL.toString())) {
                    BitSetCheckedAuthorizationProvider.setBooleanArray(check, true);
                    return true;
                }
                privSet.add(priv.toLowerCase());
            }
        }
        if (privileges.getRolePrivileges() != null && privileges.getRolePrivileges().size() > 0 && (rolePrivs = this.getPrivilegeStringList(rolePrivsCollection = privileges.getRolePrivileges().values())) != null && rolePrivs.size() > 0) {
            for (String priv : rolePrivs) {
                if (priv == null || priv.trim().equals("")) continue;
                if (priv.equalsIgnoreCase(Privilege.ALL.toString())) {
                    BitSetCheckedAuthorizationProvider.setBooleanArray(check, true);
                    return true;
                }
                privSet.add(priv.toLowerCase());
            }
        }
        for (int i = 0; i < inputPriv.length; ++i) {
            String toMatch = inputPriv[i].toString();
            if (check[i]) continue;
            check[i] = privSet.contains(toMatch.toLowerCase());
        }
        return this.firstFalseIndex(check) < 0;
    }

    private List<String> getPrivilegeStringList(Collection<List<PrivilegeGrantInfo>> privCollection) {
        ArrayList<String> userPrivs = new ArrayList<String>();
        if (privCollection != null && privCollection.size() > 0) {
            for (List<PrivilegeGrantInfo> grantList : privCollection) {
                if (grantList == null) continue;
                for (int i = 0; i < grantList.size(); ++i) {
                    PrivilegeGrantInfo grant = grantList.get(i);
                    userPrivs.add(grant.getPrivilege());
                }
            }
        }
        return userPrivs;
    }

    private static void setBooleanArray(boolean[] check, boolean b) {
        for (int i = 0; i < check.length; ++i) {
            check[i] = b;
        }
    }

    private static void booleanArrayOr(boolean[] output, boolean[] input) {
        for (int i = 0; i < output.length && i < input.length; ++i) {
            output[i] = output[i] || input[i];
        }
    }

    private void checkAndThrowAuthorizationException(Privilege[] inputRequiredPriv, Privilege[] outputRequiredPriv, boolean[] inputCheck, boolean[] outputCheck, String dbName, String tableName, String partitionName, String columnName) {
        int output;
        int input;
        String hiveObject = "{ ";
        if (dbName != null) {
            hiveObject = hiveObject + "database:" + dbName;
        }
        if (tableName != null) {
            hiveObject = hiveObject + ", table:" + tableName;
        }
        if (partitionName != null) {
            hiveObject = hiveObject + ", partitionName:" + partitionName;
        }
        if (columnName != null) {
            hiveObject = hiveObject + ", columnName:" + columnName;
        }
        hiveObject = hiveObject + "}";
        if (inputCheck != null && (input = this.firstFalseIndex(inputCheck)) >= 0) {
            throw new AuthorizationException("No privilege '" + inputRequiredPriv[input].toString() + "' found for inputs " + hiveObject);
        }
        if (outputCheck != null && (output = this.firstFalseIndex(outputCheck)) >= 0) {
            throw new AuthorizationException("No privilege '" + outputRequiredPriv[output].toString() + "' found for outputs " + hiveObject);
        }
    }

    private int firstFalseIndex(boolean[] inputCheck) {
        if (inputCheck != null) {
            for (int i = 0; i < inputCheck.length; ++i) {
                if (inputCheck[i]) continue;
                return i;
            }
        }
        return -1;
    }

    static class BitSetChecker {
        boolean[] inputCheck = null;
        boolean[] outputCheck = null;

        BitSetChecker() {
        }

        public static BitSetChecker getBitSetChecker(Privilege[] inputRequiredPriv, Privilege[] outputRequiredPriv) {
            int i;
            BitSetChecker checker = new BitSetChecker();
            if (inputRequiredPriv != null) {
                checker.inputCheck = new boolean[inputRequiredPriv.length];
                for (i = 0; i < checker.inputCheck.length; ++i) {
                    checker.inputCheck[i] = false;
                }
            }
            if (outputRequiredPriv != null) {
                checker.outputCheck = new boolean[outputRequiredPriv.length];
                for (i = 0; i < checker.outputCheck.length; ++i) {
                    checker.outputCheck[i] = false;
                }
            }
            return checker;
        }
    }
}

