/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.processors;

import hive.com.google.common.annotations.VisibleForTesting;
import hive.com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveEntry;
import org.apache.commons.compress.archivers.jar.JarArchiveOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hive.conf.HiveVariableSource;
import org.apache.hadoop.hive.conf.VariableSubstitution;
import org.apache.hadoop.hive.ql.CommandNeedRetryException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.processors.CommandProcessor;
import org.apache.hadoop.hive.ql.processors.CommandProcessorResponse;
import org.apache.hadoop.hive.ql.processors.CommandUtil;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.Path;
import org.codehaus.groovy.ant.Groovyc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompileProcessor
implements CommandProcessor {
    public static final Logger LOG = LoggerFactory.getLogger((String)CompileProcessor.class.getName());
    public static final SessionState.LogHelper console = new SessionState.LogHelper(LOG);
    public static final String IO_TMP_DIR = "java.io.tmpdir";
    public static final String GROOVY = "GROOVY";
    public static final String AS = "AS";
    public static final String NAMED = "NAMED";
    private static final String SYNTAX = "syntax: COMPILE ` some code here ` AS groovy NAMED something.groovy";
    private static final AtomicInteger runCount = new AtomicInteger(0);
    private String lang;
    private String code;
    private String named;
    private String command;
    private int myId;

    @Override
    public void init() {
    }

    @Override
    public CommandProcessorResponse run(String command) throws CommandNeedRetryException {
        SessionState ss = SessionState.get();
        this.command = command;
        CommandProcessorResponse authErrResp = CommandUtil.authorizeCommand(ss, HiveOperationType.COMPILE, Arrays.asList(command));
        if (authErrResp != null) {
            return authErrResp;
        }
        this.myId = runCount.getAndIncrement();
        try {
            this.parse(ss);
        }
        catch (CompileProcessorException e) {
            return CommandProcessorResponse.create(e);
        }
        CommandProcessorResponse result = null;
        try {
            result = this.compile(ss);
        }
        catch (CompileProcessorException e) {
            return CommandProcessorResponse.create(e);
        }
        return result;
    }

    @VisibleForTesting
    void parse(SessionState ss) throws CompileProcessorException {
        if (ss != null) {
            this.command = new VariableSubstitution(new HiveVariableSource(){

                @Override
                public Map<String, String> getHiveVariable() {
                    return SessionState.get().getHiveVariables();
                }
            }).substitute(ss.getConf(), this.command);
        }
        if (this.command == null || this.command.length() == 0) {
            throw new CompileProcessorException("Command was empty");
        }
        StringBuilder toCompile = new StringBuilder();
        int startPosition = 0;
        int endPosition = -1;
        while (this.command.charAt(startPosition++) != '`' && startPosition < this.command.length()) {
        }
        if (startPosition == this.command.length()) {
            throw new CompileProcessorException(SYNTAX);
        }
        for (int i = startPosition; i < this.command.length(); ++i) {
            if (this.command.charAt(i) == '\\') {
                toCompile.append(this.command.charAt(i + 1));
                ++i;
                continue;
            }
            if (this.command.charAt(i) == '`') {
                endPosition = i;
                break;
            }
            toCompile.append(this.command.charAt(i));
        }
        if (endPosition == -1) {
            throw new CompileProcessorException(SYNTAX);
        }
        StringTokenizer st = new StringTokenizer(this.command.substring(endPosition + 1), " ");
        if (st.countTokens() != 4) {
            throw new CompileProcessorException(SYNTAX);
        }
        String shouldBeAs = st.nextToken();
        if (!shouldBeAs.equalsIgnoreCase(AS)) {
            throw new CompileProcessorException(SYNTAX);
        }
        this.setLang(st.nextToken());
        if (!this.lang.equalsIgnoreCase(GROOVY)) {
            throw new CompileProcessorException("Can not compile " + this.lang + ". Hive can only compile " + GROOVY);
        }
        String shouldBeNamed = st.nextToken();
        if (!shouldBeNamed.equalsIgnoreCase(NAMED)) {
            throw new CompileProcessorException(SYNTAX);
        }
        this.setNamed(st.nextToken());
        this.setCode(toCompile.toString());
    }

    @VisibleForTesting
    CommandProcessorResponse compile(SessionState ss) throws CompileProcessorException {
        Project proj = new Project();
        String ioTempDir = System.getProperty(IO_TMP_DIR);
        File ioTempFile = new File(ioTempDir);
        if (!ioTempFile.exists()) {
            throw new CompileProcessorException(ioTempDir + " does not exists");
        }
        if (!ioTempFile.isDirectory() || !ioTempFile.canWrite()) {
            throw new CompileProcessorException(ioTempDir + " is not a writable directory");
        }
        Groovyc g = new Groovyc();
        long runStamp = System.currentTimeMillis();
        String jarId = this.myId + "_" + runStamp;
        g.setProject(proj);
        Path sourcePath = new Path(proj);
        File destination = new File(ioTempFile, jarId + "out");
        g.setDestdir(destination);
        File input = new File(ioTempFile, jarId + "in");
        sourcePath.setLocation(input);
        g.setSrcdir(sourcePath);
        input.mkdir();
        File fileToWrite = new File(input, this.named);
        try {
            Files.write(this.code, fileToWrite, Charset.forName("UTF-8"));
        }
        catch (IOException e1) {
            throw new CompileProcessorException("writing file", e1);
        }
        destination.mkdir();
        try {
            g.execute();
        }
        catch (BuildException ex) {
            throw new CompileProcessorException("Problem compiling", ex);
        }
        File testArchive = new File(ioTempFile, jarId + ".jar");
        JarArchiveOutputStream out = null;
        try {
            out = new JarArchiveOutputStream((OutputStream)new FileOutputStream(testArchive));
            for (File f : destination.listFiles()) {
                JarArchiveEntry jentry = new JarArchiveEntry(f.getName());
                FileInputStream fis = new FileInputStream(f);
                out.putArchiveEntry((ArchiveEntry)jentry);
                IOUtils.copy((InputStream)fis, (OutputStream)out);
                fis.close();
                out.closeArchiveEntry();
            }
            out.finish();
        }
        catch (IOException e) {
            throw new CompileProcessorException("Exception while writing jar", e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (ss != null) {
            ss.add_resource(SessionState.ResourceType.JAR, testArchive.getAbsolutePath());
        }
        CommandProcessorResponse good = new CommandProcessorResponse(0, testArchive.getAbsolutePath(), null);
        return good;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getNamed() {
        return this.named;
    }

    public void setNamed(String named) {
        this.named = named;
    }

    public String getCommand() {
        return this.command;
    }

    class CompileProcessorException
    extends HiveException {
        private static final long serialVersionUID = 1L;

        CompileProcessorException(String s, Throwable t) {
            super(s, t);
        }

        CompileProcessorException(String s) {
            super(s);
        }
    }
}

