/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import hive.com.google.common.annotations.VisibleForTesting;
import hive.com.google.common.base.Preconditions;
import hive.org.apache.commons.lang.ArrayUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javolution.util.FastBitSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.KeyWrapper;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorAggregationBufferRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorGroupKeyHelper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapper;
import org.apache.hadoop.hive.ql.exec.vector.VectorHashKeyWrapperBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorUtilBatchObjectPool;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContextRegion;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatchCtx;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ConstantVectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriter;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpressionWriterFactory;
import org.apache.hadoop.hive.ql.exec.vector.expressions.aggregates.VectorAggregateExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorGroupByDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.DataOutputBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorGroupByOperator
extends Operator<GroupByDesc>
implements VectorizationContextRegion {
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorGroupByOperator.class.getName());
    private VectorGroupByDesc vectorDesc;
    private VectorAggregateExpression[] aggregators;
    private VectorExpression[] keyExpressions;
    private int outputKeyLength;
    private boolean isVectorOutput;
    private VectorizationContext vOutContext = null;
    private transient VectorExpressionWriter[] keyOutputWriters;
    private transient VectorAggregationBufferBatch aggregationBatchInfo;
    private transient VectorHashKeyWrapperBatch keyWrappersBatch;
    private transient Object[] forwardCache;
    private transient VectorizedRowBatch outputBatch;
    private transient VectorizedRowBatchCtx vrbCtx;
    private transient VectorAssignRow vectorAssignRow;
    private transient boolean groupingSetsPresent;
    private transient int[] groupingSets;
    private transient int groupingSetsPosition;
    private transient ConstantVectorExpression groupingSetsDummyVectorExpression;
    private transient boolean[][] allGroupingSetsOverrideIsNulls;
    private transient int numEntriesHashTable;
    private transient long maxHashTblMemory;
    private transient long maxMemory;
    private float memoryThreshold;
    private transient IProcessingMode processingMode;
    private static final long serialVersionUID = 1L;

    public VectorGroupByOperator(CompilationOpContext ctx, VectorizationContext vContext, OperatorDesc conf) throws HiveException {
        this(ctx);
        GroupByDesc desc = (GroupByDesc)conf;
        this.conf = desc;
        this.vectorDesc = (VectorGroupByDesc)desc.getVectorDesc();
        this.keyExpressions = this.vectorDesc.getKeyExpressions();
        this.aggregators = this.vectorDesc.getAggregators();
        this.isVectorOutput = this.vectorDesc.isVectorOutput();
        this.vOutContext = new VectorizationContext(this.getName(), desc.getOutputColumnNames(), vContext);
    }

    @VisibleForTesting
    public VectorGroupByOperator() {
    }

    public VectorGroupByOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    private void setupGroupingSets() {
        this.groupingSetsPresent = ((GroupByDesc)this.conf).isGroupingSetsPresent();
        if (!this.groupingSetsPresent) {
            this.groupingSets = null;
            this.groupingSetsPosition = -1;
            this.groupingSetsDummyVectorExpression = null;
            this.allGroupingSetsOverrideIsNulls = null;
            return;
        }
        this.groupingSets = ArrayUtils.toPrimitive(((GroupByDesc)this.conf).getListGroupingSets().toArray(new Integer[0]));
        this.groupingSetsPosition = ((GroupByDesc)this.conf).getGroupingSetPosition();
        this.allGroupingSetsOverrideIsNulls = new boolean[this.groupingSets.length][];
        int pos = 0;
        for (int groupingSet : this.groupingSets) {
            boolean[] groupingSetsOverrideIsNull = new boolean[this.keyExpressions.length];
            Arrays.fill(groupingSetsOverrideIsNull, true);
            groupingSetsOverrideIsNull[this.groupingSetsPosition] = false;
            FastBitSet bitset = GroupByOperator.groupingSet2BitSet(groupingSet, this.groupingSetsPosition);
            int keyPos = bitset.nextClearBit(0);
            while (keyPos < this.groupingSetsPosition) {
                groupingSetsOverrideIsNull[keyPos] = false;
                keyPos = bitset.nextClearBit(keyPos + 1);
            }
            this.allGroupingSetsOverrideIsNulls[pos] = groupingSetsOverrideIsNull;
            ++pos;
        }
        this.groupingSetsDummyVectorExpression = (ConstantVectorExpression)this.keyExpressions[this.groupingSetsPosition];
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        super.initializeOp(hconf);
        ArrayList<ObjectInspector> objectInspectors = new ArrayList<ObjectInspector>();
        ArrayList<ExprNodeDesc> keysDesc = ((GroupByDesc)this.conf).getKeys();
        try {
            int i;
            ArrayList<String> outputFieldNames = ((GroupByDesc)this.conf).getOutputColumnNames();
            this.outputKeyLength = ((GroupByDesc)this.conf).pruneGroupingSetId() ? this.keyExpressions.length - 1 : this.keyExpressions.length;
            this.keyOutputWriters = new VectorExpressionWriter[this.outputKeyLength];
            for (i = 0; i < this.outputKeyLength; ++i) {
                this.keyOutputWriters[i] = VectorExpressionWriterFactory.genVectorExpressionWritable((ExprNodeDesc)keysDesc.get(i));
                objectInspectors.add(this.keyOutputWriters[i].getObjectInspector());
            }
            for (i = 0; i < this.aggregators.length; ++i) {
                this.aggregators[i].init(((GroupByDesc)this.conf).getAggregators().get(i));
                objectInspectors.add(this.aggregators[i].getOutputObjectInspector());
            }
            this.keyWrappersBatch = VectorHashKeyWrapperBatch.compileKeyWrapperBatch(this.keyExpressions);
            this.aggregationBatchInfo = new VectorAggregationBufferBatch();
            this.aggregationBatchInfo.compileAggregationBatchInfo(this.aggregators);
            LOG.info("VectorGroupByOperator is vector output {}", (Object)this.isVectorOutput);
            this.outputObjInspector = ObjectInspectorFactory.getStandardStructObjectInspector(outputFieldNames, objectInspectors);
            if (this.isVectorOutput) {
                this.vrbCtx = new VectorizedRowBatchCtx();
                this.vrbCtx.init((StructObjectInspector)this.outputObjInspector, this.vOutContext.getScratchColumnTypeNames());
                this.outputBatch = this.vrbCtx.createVectorizedRowBatch();
                this.vectorAssignRow = new VectorAssignRow();
                this.vectorAssignRow.init((StructObjectInspector)this.outputObjInspector, this.vOutContext.getProjectedColumns());
            }
        }
        catch (HiveException he) {
            throw he;
        }
        catch (Throwable e) {
            throw new HiveException(e);
        }
        this.forwardCache = new Object[this.outputKeyLength + this.aggregators.length];
        this.setupGroupingSets();
        switch (this.vectorDesc.getProcessingMode()) {
            case GLOBAL: {
                Preconditions.checkState(this.outputKeyLength == 0);
                Preconditions.checkState(!this.groupingSetsPresent);
                this.processingMode = new ProcessingModeGlobalAggregate();
                break;
            }
            case HASH: {
                this.processingMode = new ProcessingModeHashAggregate();
                break;
            }
            case MERGE_PARTIAL: {
                Preconditions.checkState(!this.groupingSetsPresent);
                this.processingMode = new ProcessingModeReduceMergePartial();
                break;
            }
            case STREAMING: {
                this.processingMode = new ProcessingModeStreaming();
                break;
            }
            default: {
                throw new RuntimeException("Unsupported vector GROUP BY processing mode " + this.vectorDesc.getProcessingMode().name());
            }
        }
        this.processingMode.initialize(hconf);
    }

    private void changeToStreamingMode() throws HiveException {
        this.processingMode = new ProcessingModeStreaming();
        this.processingMode.initialize(null);
        LOG.trace("switched to streaming mode");
    }

    @Override
    public void startGroup() throws HiveException {
        this.processingMode.startGroup();
    }

    @Override
    public void endGroup() throws HiveException {
        this.processingMode.endGroup();
    }

    @Override
    public void process(Object row, int tag) throws HiveException {
        VectorizedRowBatch batch = (VectorizedRowBatch)row;
        if (batch.size > 0) {
            this.processingMode.processBatch(batch);
        }
    }

    private void writeSingleRow(VectorHashKeyWrapper kw, VectorAggregationBufferRow agg) throws HiveException {
        int fi = 0;
        if (!this.isVectorOutput) {
            int i;
            for (i = 0; i < this.outputKeyLength; ++i) {
                this.forwardCache[fi++] = this.keyWrappersBatch.getWritableKeyValue(kw, i, this.keyOutputWriters[i]);
            }
            for (i = 0; i < this.aggregators.length; ++i) {
                this.forwardCache[fi++] = this.aggregators[i].evaluateOutput(agg.getAggregationBuffer(i));
            }
            this.forward(this.forwardCache, this.outputObjInspector);
        } else {
            int i;
            for (i = 0; i < this.outputKeyLength; ++i) {
                this.vectorAssignRow.assignRowColumn(this.outputBatch, this.outputBatch.size, fi++, this.keyWrappersBatch.getWritableKeyValue(kw, i, this.keyOutputWriters[i]));
            }
            for (i = 0; i < this.aggregators.length; ++i) {
                this.vectorAssignRow.assignRowColumn(this.outputBatch, this.outputBatch.size, fi++, this.aggregators[i].evaluateOutput(agg.getAggregationBuffer(i)));
            }
            ++this.outputBatch.size;
            if (this.outputBatch.size == 1024) {
                this.flushOutput();
            }
        }
    }

    private void writeGroupRow(VectorAggregationBufferRow agg, DataOutputBuffer buffer) throws HiveException {
        int fi = this.outputKeyLength;
        for (int i = 0; i < this.aggregators.length; ++i) {
            this.vectorAssignRow.assignRowColumn(this.outputBatch, this.outputBatch.size, fi++, this.aggregators[i].evaluateOutput(agg.getAggregationBuffer(i)));
        }
        ++this.outputBatch.size;
        if (this.outputBatch.size == 1024) {
            this.flushOutput();
            buffer.reset();
        }
    }

    private void flushOutput() throws HiveException {
        this.forward(this.outputBatch, null);
        this.outputBatch.reset();
    }

    @Override
    public void closeOp(boolean aborted) throws HiveException {
        this.processingMode.close(aborted);
        if (!aborted && this.isVectorOutput && this.outputBatch.size > 0) {
            this.flushOutput();
        }
    }

    public VectorExpression[] getKeyExpressions() {
        return this.keyExpressions;
    }

    public void setKeyExpressions(VectorExpression[] keyExpressions) {
        this.keyExpressions = keyExpressions;
    }

    public VectorAggregateExpression[] getAggregators() {
        return this.aggregators;
    }

    public void setAggregators(VectorAggregateExpression[] aggregators) {
        this.aggregators = aggregators;
    }

    @Override
    public VectorizationContext getOuputVectorizationContext() {
        return this.vOutContext;
    }

    @Override
    public OperatorType getType() {
        return OperatorType.GROUPBY;
    }

    @Override
    public String getName() {
        return VectorGroupByOperator.getOperatorName();
    }

    public static String getOperatorName() {
        return "GBY";
    }

    private class ProcessingModeReduceMergePartial
    extends ProcessingModeBase {
        private boolean inGroup;
        private boolean first;
        VectorGroupKeyHelper groupKeyHelper;
        private VectorAggregationBufferRow groupAggregators;
        private DataOutputBuffer buffer;

        private ProcessingModeReduceMergePartial() {
        }

        @Override
        public void initialize(Configuration hconf) throws HiveException {
            this.inGroup = false;
            this.groupKeyHelper = new VectorGroupKeyHelper(VectorGroupByOperator.this.outputKeyLength);
            this.groupKeyHelper.init(VectorGroupByOperator.this.keyExpressions);
            this.groupAggregators = this.allocateAggregationBuffer();
            this.buffer = new DataOutputBuffer();
            LOG.info("using sorted group batch aggregation processing mode");
        }

        @Override
        public void startGroup() throws HiveException {
            this.inGroup = true;
            this.first = true;
        }

        @Override
        public void endGroup() throws HiveException {
            if (this.inGroup && !this.first) {
                VectorGroupByOperator.this.writeGroupRow(this.groupAggregators, this.buffer);
                this.groupAggregators.reset();
            }
            this.inGroup = false;
        }

        @Override
        public void doProcessBatch(VectorizedRowBatch batch, boolean isFirstGroupingSet, boolean[] currentGroupingSetsOverrideIsNulls) throws HiveException {
            assert (this.inGroup);
            if (this.first) {
                this.first = false;
                this.groupKeyHelper.copyGroupKey(batch, VectorGroupByOperator.this.outputBatch, this.buffer);
            }
            for (int i = 0; i < VectorGroupByOperator.this.aggregators.length; ++i) {
                VectorGroupByOperator.this.aggregators[i].aggregateInput(this.groupAggregators.getAggregationBuffer(i), batch);
            }
        }

        @Override
        public void close(boolean aborted) throws HiveException {
            if (!aborted && this.inGroup && !this.first) {
                VectorGroupByOperator.this.writeGroupRow(this.groupAggregators, this.buffer);
            }
        }
    }

    private class ProcessingModeStreaming
    extends ProcessingModeBase {
        private VectorAggregationBufferRow currentStreamingAggregators;
        private VectorHashKeyWrapper streamingKey;
        private final VectorHashKeyWrapper[] keysToFlush;
        private final VectorAggregationBufferRow[] rowsToFlush;
        private VectorUtilBatchObjectPool<VectorAggregationBufferRow> streamAggregationBufferRowPool;

        private ProcessingModeStreaming() {
            this.keysToFlush = new VectorHashKeyWrapper[1024];
            this.rowsToFlush = new VectorAggregationBufferRow[1024];
        }

        @Override
        public void initialize(Configuration hconf) throws HiveException {
            this.streamAggregationBufferRowPool = new VectorUtilBatchObjectPool<VectorAggregationBufferRow>(1024, new VectorUtilBatchObjectPool.IAllocator<VectorAggregationBufferRow>(){

                @Override
                public VectorAggregationBufferRow alloc() throws HiveException {
                    return ProcessingModeStreaming.this.allocateAggregationBuffer();
                }

                @Override
                public void free(VectorAggregationBufferRow t) {
                }
            });
            LOG.info("using unsorted streaming aggregation processing mode");
        }

        @Override
        public void doProcessBatch(VectorizedRowBatch batch, boolean isFirstGroupingSet, boolean[] currentGroupingSetsOverrideIsNulls) throws HiveException {
            int i;
            if (!VectorGroupByOperator.this.groupingSetsPresent || isFirstGroupingSet) {
                for (int i2 = 0; i2 < VectorGroupByOperator.this.keyExpressions.length; ++i2) {
                    VectorGroupByOperator.this.keyExpressions[i2].evaluate(batch);
                }
            }
            if (!VectorGroupByOperator.this.groupingSetsPresent) {
                VectorGroupByOperator.this.keyWrappersBatch.evaluateBatch(batch);
            } else {
                VectorGroupByOperator.this.keyWrappersBatch.evaluateBatchGroupingSets(batch, currentGroupingSetsOverrideIsNulls);
            }
            VectorHashKeyWrapper[] batchKeys = VectorGroupByOperator.this.keyWrappersBatch.getVectorHashKeyWrappers();
            if (this.streamingKey == null) {
                this.currentStreamingAggregators = this.streamAggregationBufferRowPool.getFromPool();
                this.streamingKey = (VectorHashKeyWrapper)batchKeys[0].copyKey();
            }
            VectorGroupByOperator.this.aggregationBatchInfo.startBatch();
            int flushMark = 0;
            for (i = 0; i < batch.size; ++i) {
                if (!batchKeys[i].equals(this.streamingKey)) {
                    this.rowsToFlush[flushMark] = this.currentStreamingAggregators;
                    if (this.keysToFlush[flushMark] == null) {
                        this.keysToFlush[flushMark] = (VectorHashKeyWrapper)this.streamingKey.copyKey();
                    } else {
                        this.streamingKey.duplicateTo(this.keysToFlush[flushMark]);
                    }
                    this.currentStreamingAggregators = this.streamAggregationBufferRowPool.getFromPool();
                    batchKeys[i].duplicateTo(this.streamingKey);
                    ++flushMark;
                }
                VectorGroupByOperator.this.aggregationBatchInfo.mapAggregationBufferSet(this.currentStreamingAggregators, i);
            }
            this.processAggregators(batch);
            for (i = 0; i < flushMark; ++i) {
                VectorGroupByOperator.this.writeSingleRow(this.keysToFlush[i], this.rowsToFlush[i]);
                this.rowsToFlush[i].reset();
                this.streamAggregationBufferRowPool.putInPool(this.rowsToFlush[i]);
            }
        }

        @Override
        public void close(boolean aborted) throws HiveException {
            if (!aborted && null != this.streamingKey) {
                VectorGroupByOperator.this.writeSingleRow(this.streamingKey, this.currentStreamingAggregators);
            }
        }
    }

    private class ProcessingModeHashAggregate
    extends ProcessingModeBase {
        private Map<KeyWrapper, VectorAggregationBufferRow> mapKeysAggregationBuffers;
        private int fixedHashEntrySize;
        private int avgVariableSize;
        private int numEntriesSinceCheck;
        private long sumBatchSize;
        private int maxHtEntries;
        private int checkInterval;
        private float percentEntriesToFlush;
        private SoftReference<Object> gcCanary;
        private long gcCanaryFlushes;
        private long lastModeCheckRowCount;
        private float minReductionHashAggr;
        private long numRowsCompareHashAggr;

        private ProcessingModeHashAggregate() {
            this.maxHtEntries = 1000000;
            this.checkInterval = 10000;
            this.percentEntriesToFlush = 0.1f;
            this.gcCanary = new SoftReference<Object>(new Object());
            this.gcCanaryFlushes = 0L;
            this.lastModeCheckRowCount = 0L;
        }

        @Override
        public void initialize(Configuration hconf) throws HiveException {
            if (null != hconf) {
                this.percentEntriesToFlush = HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_FLUSH_PERCENT);
                this.checkInterval = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_CHECKINTERVAL);
                this.maxHtEntries = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_MAXENTRIES);
                this.minReductionHashAggr = HiveConf.getFloatVar(hconf, HiveConf.ConfVars.HIVEMAPAGGRHASHMINREDUCTION);
                this.numRowsCompareHashAggr = HiveConf.getIntVar(hconf, HiveConf.ConfVars.HIVEGROUPBYMAPINTERVAL);
            } else {
                this.percentEntriesToFlush = HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_FLUSH_PERCENT.defaultFloatVal;
                this.checkInterval = HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_CHECKINTERVAL.defaultIntVal;
                this.maxHtEntries = HiveConf.ConfVars.HIVE_VECTORIZATION_GROUPBY_MAXENTRIES.defaultIntVal;
                this.minReductionHashAggr = HiveConf.ConfVars.HIVEMAPAGGRHASHMINREDUCTION.defaultFloatVal;
                this.numRowsCompareHashAggr = HiveConf.ConfVars.HIVEGROUPBYMAPINTERVAL.defaultIntVal;
            }
            this.sumBatchSize = 0L;
            this.mapKeysAggregationBuffers = new HashMap<KeyWrapper, VectorAggregationBufferRow>();
            this.computeMemoryLimits();
            LOG.debug("using hash aggregation processing mode");
        }

        @Override
        public void doProcessBatch(VectorizedRowBatch batch, boolean isFirstGroupingSet, boolean[] currentGroupingSetsOverrideIsNulls) throws HiveException {
            if (!VectorGroupByOperator.this.groupingSetsPresent || isFirstGroupingSet) {
                for (int i = 0; i < VectorGroupByOperator.this.keyExpressions.length; ++i) {
                    VectorGroupByOperator.this.keyExpressions[i].evaluate(batch);
                }
            }
            if (!VectorGroupByOperator.this.groupingSetsPresent) {
                VectorGroupByOperator.this.keyWrappersBatch.evaluateBatch(batch);
            } else {
                VectorGroupByOperator.this.keyWrappersBatch.evaluateBatchGroupingSets(batch, currentGroupingSetsOverrideIsNulls);
            }
            this.prepareBatchAggregationBufferSets(batch);
            this.processAggregators(batch);
            int preFlushEntriesCount = VectorGroupByOperator.this.numEntriesHashTable;
            while (this.shouldFlush(batch)) {
                this.flush(false);
                if (this.gcCanary.get() == null) {
                    ++this.gcCanaryFlushes;
                    this.gcCanary = new SoftReference<Object>(new Object());
                }
                if (VectorGroupByOperator.this.numEntriesHashTable >= preFlushEntriesCount) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug(String.format("Flush did not progress: %d entries before, %d entries after", preFlushEntriesCount, VectorGroupByOperator.this.numEntriesHashTable));
                    break;
                }
                preFlushEntriesCount = VectorGroupByOperator.this.numEntriesHashTable;
            }
            if (this.sumBatchSize == 0L && 0 != batch.size) {
                this.updateAvgVariableSize(batch);
            }
            this.sumBatchSize += (long)batch.size;
            this.lastModeCheckRowCount += (long)batch.size;
            this.checkHashModeEfficiency();
        }

        @Override
        public void close(boolean aborted) throws HiveException {
            if (!aborted) {
                this.flush(true);
            }
        }

        private void prepareBatchAggregationBufferSets(VectorizedRowBatch batch) throws HiveException {
            VectorGroupByOperator.this.aggregationBatchInfo.startBatch();
            VectorHashKeyWrapper[] keyWrappers = VectorGroupByOperator.this.keyWrappersBatch.getVectorHashKeyWrappers();
            for (int i = 0; i < batch.size; ++i) {
                VectorHashKeyWrapper kw = keyWrappers[i];
                VectorAggregationBufferRow aggregationBuffer = this.mapKeysAggregationBuffers.get(kw);
                if (null == aggregationBuffer) {
                    aggregationBuffer = this.allocateAggregationBuffer();
                    this.mapKeysAggregationBuffers.put(kw.copyKey(), aggregationBuffer);
                    VectorGroupByOperator.this.numEntriesHashTable++;
                    ++this.numEntriesSinceCheck;
                }
                VectorGroupByOperator.this.aggregationBatchInfo.mapAggregationBufferSet(aggregationBuffer, i);
            }
        }

        private void computeMemoryLimits() {
            JavaDataModel model = JavaDataModel.get();
            this.fixedHashEntrySize = model.hashMapEntry() + VectorGroupByOperator.this.keyWrappersBatch.getKeysFixedSize() + VectorGroupByOperator.this.aggregationBatchInfo.getAggregatorsFixedSize();
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            VectorGroupByOperator.this.maxMemory = memoryMXBean.getHeapMemoryUsage().getMax();
            VectorGroupByOperator.this.memoryThreshold = ((GroupByDesc)VectorGroupByOperator.this.conf).getMemoryThreshold();
            if (VectorGroupByOperator.this.memoryThreshold == 0.0f) {
                VectorGroupByOperator.this.memoryThreshold = 1.0f;
            }
            VectorGroupByOperator.this.maxHashTblMemory = (int)((float)VectorGroupByOperator.this.maxMemory * VectorGroupByOperator.this.memoryThreshold);
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("maxMemory:%dMb (%d * %f) fixSize:%d (key:%d agg:%d)", VectorGroupByOperator.this.maxHashTblMemory / 1024L / 1024L, VectorGroupByOperator.this.maxMemory / 1024L / 1024L, Float.valueOf(VectorGroupByOperator.this.memoryThreshold), this.fixedHashEntrySize, VectorGroupByOperator.this.keyWrappersBatch.getKeysFixedSize(), VectorGroupByOperator.this.aggregationBatchInfo.getAggregatorsFixedSize()));
            }
        }

        private void flush(boolean all) throws HiveException {
            int entriesToFlush = all ? VectorGroupByOperator.this.numEntriesHashTable : (int)((float)VectorGroupByOperator.this.numEntriesHashTable * this.percentEntriesToFlush);
            int entriesFlushed = 0;
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Flush %d %s entries:%d fixed:%d variable:%d (used:%dMb max:%dMb) gcCanary:%s", entriesToFlush, all ? "(all)" : "", VectorGroupByOperator.this.numEntriesHashTable, this.fixedHashEntrySize, this.avgVariableSize, VectorGroupByOperator.this.numEntriesHashTable * (this.fixedHashEntrySize + this.avgVariableSize) / 1024 / 1024, VectorGroupByOperator.this.maxHashTblMemory / 1024L / 1024L, this.gcCanary.get() == null ? "dead" : "alive"));
            }
            Iterator<Map.Entry<KeyWrapper, VectorAggregationBufferRow>> iter = this.mapKeysAggregationBuffers.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<KeyWrapper, VectorAggregationBufferRow> pair = iter.next();
                VectorGroupByOperator.this.writeSingleRow((VectorHashKeyWrapper)pair.getKey(), pair.getValue());
                if (all) continue;
                iter.remove();
                --VectorGroupByOperator.this.numEntriesHashTable;
                if (++entriesFlushed < entriesToFlush) continue;
                break;
            }
            if (all) {
                this.mapKeysAggregationBuffers.clear();
                VectorGroupByOperator.this.numEntriesHashTable = 0;
            }
            if (all && LOG.isDebugEnabled()) {
                LOG.debug(String.format("GC canary caused %d flushes", this.gcCanaryFlushes));
            }
        }

        private boolean shouldFlush(VectorizedRowBatch batch) {
            if (batch.size == 0) {
                return false;
            }
            if (this.numEntriesSinceCheck >= this.checkInterval) {
                this.updateAvgVariableSize(batch);
                this.numEntriesSinceCheck = 0;
            }
            if (VectorGroupByOperator.this.numEntriesHashTable > this.maxHtEntries || (long)(VectorGroupByOperator.this.numEntriesHashTable * (this.fixedHashEntrySize + this.avgVariableSize)) > VectorGroupByOperator.this.maxHashTblMemory) {
                return true;
            }
            return this.gcCanary.get() == null;
        }

        private void updateAvgVariableSize(VectorizedRowBatch batch) {
            int keyVariableSize = VectorGroupByOperator.this.keyWrappersBatch.getVariableSize(batch.size);
            int aggVariableSize = VectorGroupByOperator.this.aggregationBatchInfo.getVariableSize(batch.size);
            this.avgVariableSize = (int)(((long)this.avgVariableSize * this.sumBatchSize + (long)keyVariableSize + (long)aggVariableSize) / (this.sumBatchSize + (long)batch.size));
        }

        private void checkHashModeEfficiency() throws HiveException {
            if (this.lastModeCheckRowCount > this.numRowsCompareHashAggr) {
                this.lastModeCheckRowCount = 0L;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("checkHashModeEfficiency: HT:%d RC:%d MIN:%d", VectorGroupByOperator.this.numEntriesHashTable, this.sumBatchSize, (long)((float)this.sumBatchSize * this.minReductionHashAggr)));
                }
                if ((float)VectorGroupByOperator.this.numEntriesHashTable > (float)this.sumBatchSize * this.minReductionHashAggr) {
                    this.flush(true);
                    VectorGroupByOperator.this.changeToStreamingMode();
                }
            }
        }
    }

    private class ProcessingModeGlobalAggregate
    extends ProcessingModeBase {
        private VectorAggregationBufferRow aggregationBuffers;

        private ProcessingModeGlobalAggregate() {
        }

        @Override
        public void initialize(Configuration hconf) throws HiveException {
            this.aggregationBuffers = this.allocateAggregationBuffer();
            LOG.info("using global aggregation processing mode");
        }

        @Override
        public void doProcessBatch(VectorizedRowBatch batch, boolean isFirstGroupingSet, boolean[] currentGroupingSetsOverrideIsNulls) throws HiveException {
            for (int i = 0; i < VectorGroupByOperator.this.aggregators.length; ++i) {
                VectorGroupByOperator.this.aggregators[i].aggregateInput(this.aggregationBuffers.getAggregationBuffer(i), batch);
            }
        }

        @Override
        public void close(boolean aborted) throws HiveException {
            if (!aborted) {
                VectorGroupByOperator.this.writeSingleRow(null, this.aggregationBuffers);
            }
        }
    }

    private abstract class ProcessingModeBase
    implements IProcessingMode {
        private ProcessingModeBase() {
        }

        @Override
        public void startGroup() throws HiveException {
        }

        @Override
        public void endGroup() throws HiveException {
        }

        protected abstract void doProcessBatch(VectorizedRowBatch var1, boolean var2, boolean[] var3) throws HiveException;

        @Override
        public void processBatch(VectorizedRowBatch batch) throws HiveException {
            if (!VectorGroupByOperator.this.groupingSetsPresent) {
                this.doProcessBatch(batch, false, null);
                return;
            }
            int size = VectorGroupByOperator.this.groupingSets.length;
            for (int i = 0; i < size; ++i) {
                VectorGroupByOperator.this.groupingSetsDummyVectorExpression.setLongValue(VectorGroupByOperator.this.groupingSets[i]);
                VectorGroupByOperator.this.groupingSetsDummyVectorExpression.evaluate(batch);
                this.doProcessBatch(batch, i == 0, VectorGroupByOperator.this.allGroupingSetsOverrideIsNulls[i]);
            }
        }

        protected void processAggregators(VectorizedRowBatch batch) throws HiveException {
            VectorAggregationBufferRow[] aggregationBufferSets = VectorGroupByOperator.this.aggregationBatchInfo.getAggregationBuffers();
            if (VectorGroupByOperator.this.aggregationBatchInfo.getDistinctBufferSetCount() == 1) {
                VectorAggregateExpression.AggregationBuffer[] aggregationBuffers = aggregationBufferSets[0].getAggregationBuffers();
                for (int i = 0; i < VectorGroupByOperator.this.aggregators.length; ++i) {
                    VectorGroupByOperator.this.aggregators[i].aggregateInput(aggregationBuffers[i], batch);
                }
            } else {
                for (int i = 0; i < VectorGroupByOperator.this.aggregators.length; ++i) {
                    VectorGroupByOperator.this.aggregators[i].aggregateInputSelection(aggregationBufferSets, i, batch);
                }
            }
        }

        protected VectorAggregationBufferRow allocateAggregationBuffer() throws HiveException {
            VectorAggregateExpression.AggregationBuffer[] aggregationBuffers = new VectorAggregateExpression.AggregationBuffer[VectorGroupByOperator.this.aggregators.length];
            for (int i = 0; i < VectorGroupByOperator.this.aggregators.length; ++i) {
                aggregationBuffers[i] = VectorGroupByOperator.this.aggregators[i].getNewAggregationBuffer();
                VectorGroupByOperator.this.aggregators[i].reset(aggregationBuffers[i]);
            }
            VectorAggregationBufferRow bufferSet = new VectorAggregationBufferRow(aggregationBuffers);
            return bufferSet;
        }
    }

    private static interface IProcessingMode {
        public void initialize(Configuration var1) throws HiveException;

        public void startGroup() throws HiveException;

        public void endGroup() throws HiveException;

        public void processBatch(VectorizedRowBatch var1) throws HiveException;

        public void close(boolean var1) throws HiveException;
    }
}

