/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import hive.com.google.common.base.Charsets;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorExtractRow {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VectorExtractRow.class);
    int[] projectionColumnNums;
    ObjectInspector.Category[] categories;
    PrimitiveObjectInspector.PrimitiveCategory[] primitiveCategories;
    int[] maxLengths;
    Writable[] primitiveWritables;

    private void allocateArrays(int count) {
        this.projectionColumnNums = new int[count];
        this.categories = new ObjectInspector.Category[count];
        this.primitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[count];
        this.maxLengths = new int[count];
        this.primitiveWritables = new Writable[count];
    }

    private void initEntry(int logicalColumnIndex, int projectionColumnNum, TypeInfo typeInfo) {
        ObjectInspector.Category category;
        this.projectionColumnNums[logicalColumnIndex] = projectionColumnNum;
        this.categories[logicalColumnIndex] = category = typeInfo.getCategory();
        if (category == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector.PrimitiveCategory primitiveCategory;
            PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
            this.primitiveCategories[logicalColumnIndex] = primitiveCategory = primitiveTypeInfo.getPrimitiveCategory();
            switch (primitiveCategory) {
                case CHAR: {
                    this.maxLengths[logicalColumnIndex] = ((CharTypeInfo)primitiveTypeInfo).getLength();
                    break;
                }
                case VARCHAR: {
                    this.maxLengths[logicalColumnIndex] = ((VarcharTypeInfo)primitiveTypeInfo).getLength();
                    break;
                }
            }
            this.primitiveWritables[logicalColumnIndex] = VectorizedBatchUtil.getPrimitiveWritable(primitiveCategory);
        }
    }

    public void init(StructObjectInspector structObjectInspector, List<Integer> projectedColumns) throws HiveException {
        List<? extends StructField> fields = structObjectInspector.getAllStructFieldRefs();
        int count = fields.size();
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int projectionColumnNum = projectedColumns.get(i);
            StructField field = fields.get(i);
            ObjectInspector fieldInspector = field.getFieldObjectInspector();
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(fieldInspector.getTypeName());
            this.initEntry(i, projectionColumnNum, typeInfo);
        }
    }

    public void init(TypeInfo[] typeInfos, int[] projectedColumns) throws HiveException {
        int count = typeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int projectionColumnNum = projectedColumns[i];
            TypeInfo typeInfo = typeInfos[i];
            this.initEntry(i, projectionColumnNum, typeInfo);
        }
    }

    public void init(List<String> typeNames) throws HiveException {
        int count = typeNames.size();
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            TypeInfo typeInfo = TypeInfoUtils.getTypeInfoFromTypeString(typeNames.get(i));
            this.initEntry(i, i, typeInfo);
        }
    }

    public int getCount() {
        return this.projectionColumnNums.length;
    }

    public Object extractRowColumn(VectorizedRowBatch batch, int batchIndex, int logicalColumnIndex) {
        int adjustedIndex;
        int projectionColumnNum = this.projectionColumnNums[logicalColumnIndex];
        ColumnVector colVector = batch.cols[projectionColumnNum];
        if (colVector == null) {
            return null;
        }
        int n = adjustedIndex = colVector.isRepeating ? 0 : batchIndex;
        if (!colVector.noNulls && colVector.isNull[adjustedIndex]) {
            return null;
        }
        ObjectInspector.Category category = this.categories[logicalColumnIndex];
        switch (category) {
            case PRIMITIVE: {
                Writable primitiveWritable = this.primitiveWritables[logicalColumnIndex];
                PrimitiveObjectInspector.PrimitiveCategory primitiveCategory = this.primitiveCategories[logicalColumnIndex];
                switch (primitiveCategory) {
                    case VOID: {
                        return null;
                    }
                    case BOOLEAN: {
                        ((BooleanWritable)primitiveWritable).set(((LongColumnVector)batch.cols[projectionColumnNum]).vector[adjustedIndex] != 0L);
                        return primitiveWritable;
                    }
                    case BYTE: {
                        ((ByteWritable)primitiveWritable).set((byte)((LongColumnVector)batch.cols[projectionColumnNum]).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case SHORT: {
                        ((ShortWritable)primitiveWritable).set((short)((LongColumnVector)batch.cols[projectionColumnNum]).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case INT: {
                        ((IntWritable)primitiveWritable).set((int)((LongColumnVector)batch.cols[projectionColumnNum]).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case LONG: {
                        ((LongWritable)primitiveWritable).set(((LongColumnVector)batch.cols[projectionColumnNum]).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case TIMESTAMP: {
                        ((TimestampWritable)primitiveWritable).set(((TimestampColumnVector)batch.cols[projectionColumnNum]).asScratchTimestamp(adjustedIndex));
                        return primitiveWritable;
                    }
                    case DATE: {
                        ((DateWritable)primitiveWritable).set((int)((LongColumnVector)batch.cols[projectionColumnNum]).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case FLOAT: {
                        ((FloatWritable)primitiveWritable).set((float)((DoubleColumnVector)batch.cols[projectionColumnNum]).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case DOUBLE: {
                        ((DoubleWritable)primitiveWritable).set(((DoubleColumnVector)batch.cols[projectionColumnNum]).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case BINARY: {
                        BytesColumnVector bytesColVector = (BytesColumnVector)batch.cols[projectionColumnNum];
                        byte[] bytes = bytesColVector.vector[adjustedIndex];
                        int start = bytesColVector.start[adjustedIndex];
                        int length = bytesColVector.length[adjustedIndex];
                        if (bytes == null) {
                            LOG.info("null binary entry: batchIndex " + batchIndex + " projection column num " + projectionColumnNum);
                        }
                        BytesWritable bytesWritable = (BytesWritable)primitiveWritable;
                        bytesWritable.set(bytes, start, length);
                        return primitiveWritable;
                    }
                    case STRING: {
                        BytesColumnVector bytesColVector = (BytesColumnVector)batch.cols[projectionColumnNum];
                        byte[] bytes = bytesColVector.vector[adjustedIndex];
                        int start = bytesColVector.start[adjustedIndex];
                        int length = bytesColVector.length[adjustedIndex];
                        if (bytes == null) {
                            this.nullBytesReadError(primitiveCategory, batchIndex, projectionColumnNum);
                        }
                        ((Text)primitiveWritable).set(bytes, start, length);
                        return primitiveWritable;
                    }
                    case VARCHAR: {
                        BytesColumnVector bytesColVector = (BytesColumnVector)batch.cols[projectionColumnNum];
                        byte[] bytes = bytesColVector.vector[adjustedIndex];
                        int start = bytesColVector.start[adjustedIndex];
                        int length = bytesColVector.length[adjustedIndex];
                        if (bytes == null) {
                            this.nullBytesReadError(primitiveCategory, batchIndex, projectionColumnNum);
                        }
                        int adjustedLength = StringExpr.truncate(bytes, start, length, this.maxLengths[logicalColumnIndex]);
                        HiveVarcharWritable hiveVarcharWritable = (HiveVarcharWritable)primitiveWritable;
                        hiveVarcharWritable.set(new String(bytes, start, adjustedLength, Charsets.UTF_8), -1);
                        return primitiveWritable;
                    }
                    case CHAR: {
                        BytesColumnVector bytesColVector = (BytesColumnVector)batch.cols[projectionColumnNum];
                        byte[] bytes = bytesColVector.vector[adjustedIndex];
                        int start = bytesColVector.start[adjustedIndex];
                        int length = bytesColVector.length[adjustedIndex];
                        if (bytes == null) {
                            this.nullBytesReadError(primitiveCategory, batchIndex, projectionColumnNum);
                        }
                        int adjustedLength = StringExpr.rightTrimAndTruncate(bytes, start, length, this.maxLengths[logicalColumnIndex]);
                        HiveCharWritable hiveCharWritable = (HiveCharWritable)primitiveWritable;
                        hiveCharWritable.set(new String(bytes, start, adjustedLength, Charsets.UTF_8), this.maxLengths[logicalColumnIndex]);
                        return primitiveWritable;
                    }
                    case DECIMAL: {
                        ((HiveDecimalWritable)primitiveWritable).set(((DecimalColumnVector)batch.cols[projectionColumnNum]).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        ((HiveIntervalYearMonthWritable)primitiveWritable).set((int)((LongColumnVector)batch.cols[projectionColumnNum]).vector[adjustedIndex]);
                        return primitiveWritable;
                    }
                    case INTERVAL_DAY_TIME: {
                        ((HiveIntervalDayTimeWritable)primitiveWritable).set(((IntervalDayTimeColumnVector)batch.cols[projectionColumnNum]).asScratchIntervalDayTime(adjustedIndex));
                        return primitiveWritable;
                    }
                }
                throw new RuntimeException("Primitive category " + primitiveCategory.name() + " not supported");
            }
        }
        throw new RuntimeException("Category " + category.name() + " not supported");
    }

    public void extractRow(VectorizedRowBatch batch, int batchIndex, Object[] objects) {
        for (int i = 0; i < this.projectionColumnNums.length; ++i) {
            objects[i] = this.extractRowColumn(batch, batchIndex, i);
        }
    }

    private void nullBytesReadError(PrimitiveObjectInspector.PrimitiveCategory primitiveCategory, int batchIndex, int projectionColumnNum) {
        throw new RuntimeException("null " + primitiveCategory.name() + " entry: batchIndex " + batchIndex + " projection column num " + projectionColumnNum);
    }
}

