/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.txn;

import hive.com.google.common.annotations.VisibleForTesting;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hive.common.classification.InterfaceAudience;
import org.apache.hadoop.hive.common.classification.InterfaceStability;
import org.apache.hadoop.hive.common.classification.RetrySemantics;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.AbortTxnRequest;
import org.apache.hadoop.hive.metastore.api.AbortTxnsRequest;
import org.apache.hadoop.hive.metastore.api.AddDynamicPartitions;
import org.apache.hadoop.hive.metastore.api.CheckLockRequest;
import org.apache.hadoop.hive.metastore.api.CommitTxnRequest;
import org.apache.hadoop.hive.metastore.api.CompactionRequest;
import org.apache.hadoop.hive.metastore.api.CompactionResponse;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsInfoResponse;
import org.apache.hadoop.hive.metastore.api.GetOpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.HeartbeatRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeRequest;
import org.apache.hadoop.hive.metastore.api.HeartbeatTxnRangeResponse;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchLockException;
import org.apache.hadoop.hive.metastore.api.NoSuchTxnException;
import org.apache.hadoop.hive.metastore.api.OpenTxnRequest;
import org.apache.hadoop.hive.metastore.api.OpenTxnsResponse;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.ShowCompactRequest;
import org.apache.hadoop.hive.metastore.api.ShowCompactResponse;
import org.apache.hadoop.hive.metastore.api.ShowLocksRequest;
import org.apache.hadoop.hive.metastore.api.ShowLocksResponse;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.TxnAbortedException;
import org.apache.hadoop.hive.metastore.api.TxnOpenException;
import org.apache.hadoop.hive.metastore.api.UnlockRequest;
import org.apache.hadoop.hive.metastore.txn.CompactionInfo;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public interface TxnStore {
    public static final String INITIATED_RESPONSE = "initiated";
    public static final String WORKING_RESPONSE = "working";
    public static final String CLEANING_RESPONSE = "ready for cleaning";
    public static final String FAILED_RESPONSE = "failed";
    public static final String SUCCEEDED_RESPONSE = "succeeded";
    public static final String ATTEMPTED_RESPONSE = "attempted";
    public static final int TIMED_OUT_TXN_ABORT_BATCH_SIZE = 50000;

    public void setConf(HiveConf var1);

    @RetrySemantics.ReadOnly
    public GetOpenTxnsInfoResponse getOpenTxnsInfo() throws MetaException;

    @RetrySemantics.ReadOnly
    public GetOpenTxnsResponse getOpenTxns() throws MetaException;

    @RetrySemantics.ReadOnly
    public void countOpenTxns() throws MetaException;

    @RetrySemantics.Idempotent
    public OpenTxnsResponse openTxns(OpenTxnRequest var1) throws MetaException;

    @RetrySemantics.Idempotent
    public void abortTxn(AbortTxnRequest var1) throws NoSuchTxnException, MetaException, TxnAbortedException;

    @RetrySemantics.Idempotent
    public void abortTxns(AbortTxnsRequest var1) throws NoSuchTxnException, MetaException;

    @RetrySemantics.Idempotent
    public void commitTxn(CommitTxnRequest var1) throws NoSuchTxnException, TxnAbortedException, MetaException;

    @RetrySemantics.CannotRetry
    public LockResponse lock(LockRequest var1) throws NoSuchTxnException, TxnAbortedException, MetaException;

    @RetrySemantics.SafeToRetry
    public LockResponse checkLock(CheckLockRequest var1) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException;

    @RetrySemantics.Idempotent
    public void unlock(UnlockRequest var1) throws NoSuchLockException, TxnOpenException, MetaException;

    @RetrySemantics.ReadOnly
    public ShowLocksResponse showLocks(ShowLocksRequest var1) throws MetaException;

    @RetrySemantics.SafeToRetry
    public void heartbeat(HeartbeatRequest var1) throws NoSuchTxnException, NoSuchLockException, TxnAbortedException, MetaException;

    @RetrySemantics.SafeToRetry
    public HeartbeatTxnRangeResponse heartbeatTxnRange(HeartbeatTxnRangeRequest var1) throws MetaException;

    @RetrySemantics.Idempotent
    public CompactionResponse compact(CompactionRequest var1) throws MetaException;

    @RetrySemantics.ReadOnly
    public ShowCompactResponse showCompact(ShowCompactRequest var1) throws MetaException;

    @RetrySemantics.SafeToRetry
    public void addDynamicPartitions(AddDynamicPartitions var1) throws NoSuchTxnException, TxnAbortedException, MetaException;

    @RetrySemantics.Idempotent
    public void cleanupRecords(HiveObjectType var1, Database var2, Table var3, Iterator<Partition> var4) throws MetaException;

    @RetrySemantics.Idempotent
    public void performTimeOuts();

    @RetrySemantics.ReadOnly
    public Set<CompactionInfo> findPotentialCompactions(int var1) throws MetaException;

    @RetrySemantics.Idempotent
    public void setRunAs(long var1, String var3) throws MetaException;

    @RetrySemantics.ReadOnly
    public CompactionInfo findNextToCompact(String var1) throws MetaException;

    @RetrySemantics.SafeToRetry
    public void markCompacted(CompactionInfo var1) throws MetaException;

    @RetrySemantics.ReadOnly
    public List<CompactionInfo> findReadyToClean() throws MetaException;

    @RetrySemantics.CannotRetry
    public void markCleaned(CompactionInfo var1) throws MetaException;

    @RetrySemantics.CannotRetry
    public void markFailed(CompactionInfo var1) throws MetaException;

    @RetrySemantics.SafeToRetry
    public void cleanEmptyAbortedTxns() throws MetaException;

    @RetrySemantics.Idempotent
    public void revokeFromLocalWorkers(String var1) throws MetaException;

    @RetrySemantics.Idempotent
    public void revokeTimedoutWorkers(long var1) throws MetaException;

    @RetrySemantics.ReadOnly
    public List<String> findColumnsWithStats(CompactionInfo var1) throws MetaException;

    @RetrySemantics.Idempotent
    public void setCompactionHighestTxnId(CompactionInfo var1, long var2) throws MetaException;

    @RetrySemantics.SafeToRetry
    public void purgeCompactionHistory() throws MetaException;

    @RetrySemantics.SafeToRetry
    public void performWriteSetGC();

    @RetrySemantics.ReadOnly
    public boolean checkFailedCompactions(CompactionInfo var1) throws MetaException;

    @VisibleForTesting
    public int numLocksInLockTable() throws SQLException, MetaException;

    @VisibleForTesting
    public long setTimeout(long var1);

    @RetrySemantics.Idempotent
    public MutexAPI getMutexAPI();

    @RetrySemantics.Idempotent
    public void setHadoopJobId(String var1, long var2);

    public static interface MutexAPI {
        public LockHandle acquireLock(String var1) throws MetaException;

        public void acquireLock(String var1, LockHandle var2) throws MetaException;

        public static interface LockHandle {
            public void releaseLocks();
        }
    }

    public static enum MUTEX_KEY {
        Initiator,
        Cleaner,
        HouseKeeper,
        CompactionHistory,
        CheckLock,
        WriteSetCleaner,
        CompactionScheduler;

    }
}

