/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.partition.spec;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.partition.spec.CompositePartitionSpecProxy;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionListComposingSpecProxy;
import org.apache.hadoop.hive.metastore.partition.spec.PartitionSpecWithSharedSDProxy;

public abstract class PartitionSpecProxy {
    public abstract int size();

    public abstract void setDbName(String var1);

    public abstract void setTableName(String var1);

    public abstract String getDbName();

    public abstract String getTableName();

    public abstract PartitionIterator getPartitionIterator();

    public abstract List<PartitionSpec> toPartitionSpec();

    public abstract void setRootLocation(String var1) throws MetaException;

    public static class SimplePartitionWrapperIterator
    implements PartitionIterator {
        private Partition partition;

        public SimplePartitionWrapperIterator(Partition partition) {
            this.partition = partition;
        }

        @Override
        public Partition getCurrent() {
            return this.partition;
        }

        @Override
        public String getDbName() {
            return this.partition.getDbName();
        }

        @Override
        public String getTableName() {
            return this.partition.getTableName();
        }

        @Override
        public Map<String, String> getParameters() {
            return this.partition.getParameters();
        }

        @Override
        public void setParameters(Map<String, String> parameters) {
            this.partition.setParameters(parameters);
        }

        @Override
        public void putToParameters(String key, String value) {
            this.partition.putToParameters(key, value);
        }

        @Override
        public String getLocation() {
            return this.partition.getSd().getLocation();
        }

        @Override
        public void setCreateTime(long time) {
            this.partition.setCreateTime((int)time);
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Partition next() {
            return null;
        }

        @Override
        public void remove() {
        }
    }

    public static interface PartitionIterator
    extends Iterator<Partition> {
        public Partition getCurrent();

        public String getDbName();

        public String getTableName();

        public Map<String, String> getParameters();

        public void setParameters(Map<String, String> var1);

        public void putToParameters(String var1, String var2);

        public String getLocation();

        public void setCreateTime(long var1);
    }

    public static class Factory {
        public static PartitionSpecProxy get(PartitionSpec partSpec) {
            if (partSpec == null) {
                return null;
            }
            if (partSpec.isSetPartitionList()) {
                return new PartitionListComposingSpecProxy(partSpec);
            }
            if (partSpec.isSetSharedSDPartitionSpec()) {
                return new PartitionSpecWithSharedSDProxy(partSpec);
            }
            assert (false) : "Unsupported type of PartitionSpec!";
            return null;
        }

        public static PartitionSpecProxy get(List<PartitionSpec> partitionSpecs) {
            return new CompositePartitionSpecProxy(partitionSpecs);
        }
    }
}

