/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.messaging.json;

import hive.com.fasterxml.jackson.annotation.JsonProperty;
import hive.com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.messaging.InsertMessage;
import org.apache.hadoop.hive.metastore.messaging.json.JSONMessageDeserializer;

public class JSONInsertMessage
extends InsertMessage {
    @JsonProperty
    String server;
    @JsonProperty
    String servicePrincipal;
    @JsonProperty
    String db;
    @JsonProperty
    String table;
    @JsonProperty
    Long timestamp;
    @JsonProperty
    List<String> files;
    @JsonProperty
    Map<String, String> partKeyVals;

    public JSONInsertMessage() {
    }

    public JSONInsertMessage(String server, String servicePrincipal, String db, String table, Map<String, String> partKeyVals, Iterator<String> fileIter, Long timestamp) {
        this.server = server;
        this.servicePrincipal = servicePrincipal;
        this.db = db;
        this.table = table;
        this.timestamp = timestamp;
        this.partKeyVals = partKeyVals;
        this.files = Lists.newArrayList(fileIter);
        this.checkValid();
    }

    @Override
    public String getTable() {
        return this.table;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public Map<String, String> getPartitionKeyValues() {
        return this.partKeyVals;
    }

    @Override
    public Iterable<String> getFiles() {
        return this.files;
    }

    @Override
    public String getServicePrincipal() {
        return this.servicePrincipal;
    }

    @Override
    public String getDB() {
        return this.db;
    }

    @Override
    public Long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        try {
            return JSONMessageDeserializer.mapper.writeValueAsString(this);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Could not serialize: ", exception);
        }
    }
}

