/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.conf;

import hive.org.apache.commons.lang3.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MapRSecurityUtil {
    private static final Logger LOG = LoggerFactory.getLogger((String)MapRSecurityUtil.class.getName());
    private static String authMethod = "not-defined";
    private static String mapRHome = null;
    private static ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    private MapRSecurityUtil() {
    }

    public static boolean isMapRSecurityEnabled() {
        if (MapRSecurityUtil.isAuthMethodSet()) {
            return "maprsasl".equals(authMethod);
        }
        return MapRSecurityUtil.mapRClusterConfContains("secure=true") && !MapRSecurityUtil.mapRClusterConfContains("kerberosEnable=true") && !MapRSecurityUtil.isCustomSecureFlagExists();
    }

    public static boolean isKerberosEnabled() {
        if (MapRSecurityUtil.isAuthMethodSet()) {
            return "kerberos".equals(authMethod);
        }
        return MapRSecurityUtil.mapRClusterConfContains("kerberosEnable=true") && !MapRSecurityUtil.isCustomSecureFlagExists();
    }

    public static boolean isAuthMethodSet() {
        return !"not-defined".equals(authMethod);
    }

    static boolean isCustomSecurityEnabled() {
        if (MapRSecurityUtil.isAuthMethodSet()) {
            return "custom".equals(authMethod);
        }
        return MapRSecurityUtil.isCustomSecureFlagExists();
    }

    public static String getAuthMethod() {
        if (MapRSecurityUtil.isMapRSecurityEnabled()) {
            return "maprsasl";
        }
        if (MapRSecurityUtil.isKerberosEnabled()) {
            return "kerberos";
        }
        if (MapRSecurityUtil.isCustomSecurityEnabled()) {
            return "custom";
        }
        if (MapRSecurityUtil.isNoSecurity()) {
            return "none";
        }
        LOG.warn("Authentication method is not defined");
        return "";
    }

    public static Configuration buildConfigurationFromDefaultFiles() {
        Configuration conf = new Configuration();
        URL hiveSiteURL = HiveConf.findConfigFile(classLoader, "hive-site.xml", true);
        URL hivemetastoreSiteUrl = HiveConf.findConfigFile(classLoader, "hivemetastore-site.xml", false);
        URL hiveServer2SiteUrl = HiveConf.findConfigFile(classLoader, "hiveserver2-site.xml", false);
        if (hiveSiteURL != null) {
            conf.addResource(hiveSiteURL, false);
        }
        if (hivemetastoreSiteUrl != null && HiveConf.isLoadMetastoreConfig()) {
            conf.addResource(hivemetastoreSiteUrl, false);
        }
        if (hiveServer2SiteUrl != null && HiveConf.isLoadHiveServer2Config()) {
            conf.addResource(hiveServer2SiteUrl, false);
        }
        HiveConf.applySystemProperties(conf);
        return conf;
    }

    public static boolean isExpiryTimeValidation() {
        return MapRSecurityUtil.buildConfigurationFromDefaultFiles().getBoolean(HiveConf.ConfVars.HIVE_VALIDATE_EXPIRY_TIME_FOR_MAPR_TICKET.varname, HiveConf.ConfVars.HIVE_VALIDATE_EXPIRY_TIME_FOR_MAPR_TICKET.defaultBoolVal);
    }

    public static String getSslProtocolVersion() {
        return MapRSecurityUtil.buildConfigurationFromDefaultFiles().get(HiveConf.ConfVars.HIVE_SSL_PROTOCOL_VERSION.varname, HiveConf.ConfVars.HIVE_SSL_PROTOCOL_VERSION.defaultStrVal);
    }

    static boolean isNoSecurity() {
        if (MapRSecurityUtil.isAuthMethodSet()) {
            return "none".equals(authMethod);
        }
        return MapRSecurityUtil.mapRClusterConfContains("secure=false") && !MapRSecurityUtil.isCustomSecureFlagExists();
    }

    private static boolean mapRClusterConfContains(String value) {
        String path = MapRSecurityUtil.getMapRHome() + "/conf/mapr-clusters.conf";
        if (MapRSecurityUtil.exists(path)) {
            return MapRSecurityUtil.readFile(path).contains(value);
        }
        LOG.warn(String.format("File %s does not exists", path));
        return false;
    }

    private static boolean isCustomSecureFlagExists() {
        return MapRSecurityUtil.exists(MapRSecurityUtil.getMapRHome() + "/conf/.customSecure");
    }

    public static String findMapRHome() {
        String maprHome = System.getenv("MAPR_HOME");
        if (maprHome == null) {
            LOG.warn("Environment variable MAPR_HOME is null");
            maprHome = System.getProperty("mapr.home.dir");
            if (maprHome == null) {
                LOG.warn("System property mapr.home.dir is null");
                maprHome = SystemUtils.IS_OS_WINDOWS ? "C:/opt/mapr" : "/opt/mapr";
                LOG.warn("Setting MapR home as {} by default", (Object)maprHome);
            }
        }
        return maprHome;
    }

    private static String getMapRHome() {
        if (mapRHome == null) {
            mapRHome = MapRSecurityUtil.findMapRHome();
        }
        return mapRHome;
    }

    private static boolean exists(String filePath) {
        return new File(filePath).exists();
    }

    private static String readFile(String filePath) {
        String content = "";
        try {
            content = new String(Files.readAllBytes(Paths.get(filePath, new String[0])));
        }
        catch (IOException e) {
            LOG.error(e.toString());
        }
        return content;
    }

    static {
        if (classLoader == null) {
            classLoader = MapRSecurityUtil.class.getClassLoader();
        }
    }
}

