/*
 * Decompiled with CFR 0.152.
 */
package hive.shaded.parquet.org.apache.thrift;

import hive.shaded.parquet.org.apache.thrift.TBase;
import hive.shaded.parquet.org.apache.thrift.TException;
import hive.shaded.parquet.org.apache.thrift.protocol.TBinaryProtocol;
import hive.shaded.parquet.org.apache.thrift.protocol.TProtocol;
import hive.shaded.parquet.org.apache.thrift.protocol.TProtocolFactory;
import hive.shaded.parquet.org.apache.thrift.transport.TIOStreamTransport;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;

public class TSerializer {
    private final ByteArrayOutputStream baos_ = new ByteArrayOutputStream();
    private final TIOStreamTransport transport_ = new TIOStreamTransport(this.baos_);
    private TProtocol protocol_;

    public TSerializer() {
        this(new TBinaryProtocol.Factory());
    }

    public TSerializer(TProtocolFactory protocolFactory) {
        this.protocol_ = protocolFactory.getProtocol(this.transport_);
    }

    public byte[] serialize(TBase base) throws TException {
        this.baos_.reset();
        base.write(this.protocol_);
        return this.baos_.toByteArray();
    }

    public String toString(TBase base, String charset) throws TException {
        try {
            return new String(this.serialize(base), charset);
        }
        catch (UnsupportedEncodingException uex) {
            throw new TException("JVM DOES NOT SUPPORT ENCODING: " + charset);
        }
    }

    public String toString(TBase base) throws TException {
        return new String(this.serialize(base));
    }
}

