/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.parquet.column.values.bitpacking;

import hive.org.apache.parquet.bytes.BytesUtils;
import hive.org.apache.parquet.column.values.ValuesReader;
import hive.org.apache.parquet.column.values.bitpacking.BitPacking;
import hive.org.apache.parquet.io.ParquetDecodingException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitPackingValuesReader
extends ValuesReader {
    private static final Logger LOG = LoggerFactory.getLogger(BitPackingValuesReader.class);
    private ByteArrayInputStream in;
    private BitPacking.BitPackingReader bitPackingReader;
    private final int bitsPerValue;
    private int nextOffset;

    public BitPackingValuesReader(int bound) {
        this.bitsPerValue = BytesUtils.getWidthFromMaxInt(bound);
    }

    @Override
    public int readInteger() {
        try {
            return this.bitPackingReader.read();
        }
        catch (IOException e) {
            throw new ParquetDecodingException(e);
        }
    }

    @Override
    public void initFromPage(int valueCount, byte[] in, int offset) throws IOException {
        int effectiveBitLength = valueCount * this.bitsPerValue;
        int length = BytesUtils.paddedByteCountFromBits(effectiveBitLength);
        LOG.debug("reading {} bytes for {} values of size {} bits.", new Object[]{length, valueCount, this.bitsPerValue});
        this.in = new ByteArrayInputStream(in, offset, length);
        this.bitPackingReader = BitPacking.createBitPackingReader(this.bitsPerValue, this.in, valueCount);
        this.nextOffset = offset + length;
    }

    @Override
    public int getNextOffset() {
        return this.nextOffset;
    }

    @Override
    public void skip() {
        this.readInteger();
    }
}

