/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.mapred;

import hive.org.apache.avro.file.SeekableInput;
import java.io.Closeable;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class FsInput
implements Closeable,
SeekableInput {
    private final FSDataInputStream stream;
    private final long len;

    public FsInput(Path path, Configuration conf) throws IOException {
        this(path, path.getFileSystem(conf));
    }

    public FsInput(Path path, FileSystem fileSystem) throws IOException {
        this.len = fileSystem.getFileStatus(path).getLen();
        this.stream = fileSystem.open(path);
    }

    @Override
    public long length() {
        return this.len;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.stream.read(b, off, len);
    }

    @Override
    public void seek(long p) throws IOException {
        this.stream.seek(p);
    }

    @Override
    public long tell() throws IOException {
        return this.stream.getPos();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }
}

