/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.file;

import hive.org.apache.avro.file.Codec;
import hive.org.apache.avro.file.CodecFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorOutputStream;
import org.apache.commons.compress.utils.IOUtils;

public class XZCodec
extends Codec {
    public static final int DEFAULT_COMPRESSION = 6;
    private ByteArrayOutputStream outputBuffer;
    private int compressionLevel;

    public XZCodec(int compressionLevel) {
        this.compressionLevel = compressionLevel;
    }

    @Override
    public String getName() {
        return "xz";
    }

    @Override
    public ByteBuffer compress(ByteBuffer data) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(data.remaining());
        try (XZCompressorOutputStream outputStream = new XZCompressorOutputStream((OutputStream)baos, this.compressionLevel);){
            outputStream.write(data.array(), XZCodec.computeOffset(data), data.remaining());
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }

    @Override
    public ByteBuffer decompress(ByteBuffer data) throws IOException {
        ByteArrayOutputStream baos = this.getOutputBuffer(data.remaining());
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(data.array(), XZCodec.computeOffset(data), data.remaining());
        try (XZCompressorInputStream ios = new XZCompressorInputStream((InputStream)bytesIn);){
            IOUtils.copy((InputStream)ios, (OutputStream)baos);
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }

    private ByteArrayOutputStream getOutputBuffer(int suggestedLength) {
        if (null == this.outputBuffer) {
            this.outputBuffer = new ByteArrayOutputStream(suggestedLength);
        }
        this.outputBuffer.reset();
        return this.outputBuffer;
    }

    @Override
    public int hashCode() {
        return this.compressionLevel;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        XZCodec other = (XZCodec)obj;
        return this.compressionLevel == other.compressionLevel;
    }

    @Override
    public String toString() {
        return this.getName() + "-" + this.compressionLevel;
    }

    static class Option
    extends CodecFactory {
        private int compressionLevel;

        Option(int compressionLevel) {
            this.compressionLevel = compressionLevel;
        }

        @Override
        protected Codec createInstance() {
            return new XZCodec(this.compressionLevel);
        }
    }
}

