/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl.writer;

import hive.com.google.protobuf.ByteString;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.orc.ColumnStatistics;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.MemoryManager;
import org.apache.orc.OrcFile;
import org.apache.orc.OrcProto;
import org.apache.orc.OrcUtils;
import org.apache.orc.PhysicalWriter;
import org.apache.orc.StripeInformation;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.impl.OutStream;
import org.apache.orc.impl.PhysicalFsWriter;
import org.apache.orc.impl.ReaderImpl;
import org.apache.orc.impl.StreamName;
import org.apache.orc.impl.WriterImpl;
import org.apache.orc.impl.WriterInternal;
import org.apache.orc.impl.writer.TreeWriter;
import org.apache.orc.impl.writer.WriterContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WriterImplV2
implements WriterInternal,
MemoryManager.Callback {
    private static final Logger LOG = LoggerFactory.getLogger(WriterImplV2.class);
    private static final int MIN_ROW_INDEX_STRIDE = 1000;
    private final Path path;
    private long adjustedStripeSize;
    private final int rowIndexStride;
    private final CompressionKind compress;
    private int bufferSize;
    private final TypeDescription schema;
    private final PhysicalWriter physicalWriter;
    private final OrcFile.WriterVersion writerVersion;
    private long rowCount = 0L;
    private long rowsInStripe = 0L;
    private long rawDataSize = 0L;
    private int rowsInIndex = 0;
    private long lastFlushOffset = 0L;
    private int stripesAtLastFlush = -1;
    private final List<OrcProto.StripeInformation> stripes = new ArrayList<OrcProto.StripeInformation>();
    private final OrcProto.Metadata.Builder fileMetadata = OrcProto.Metadata.newBuilder();
    private final Map<String, ByteString> userMetadata = new TreeMap<String, ByteString>();
    private final TreeWriter treeWriter;
    private final boolean buildIndex;
    private final MemoryManager memoryManager;
    private final OrcFile.Version version;
    private final Configuration conf;
    private final OrcFile.WriterCallback callback;
    private final OrcFile.WriterContext callbackContext;
    private final OrcFile.EncodingStrategy encodingStrategy;
    private final OrcFile.CompressionStrategy compressionStrategy;
    private final boolean[] bloomFilterColumns;
    private final double bloomFilterFpp;
    private final OrcFile.BloomFilterVersion bloomFilterVersion;
    private final boolean writeTimeZone;
    private final boolean useUTCTimeZone;

    public WriterImplV2(FileSystem fs, Path path, OrcFile.WriterOptions opts) throws IOException {
        this.path = path;
        this.conf = opts.getConfiguration();
        this.callback = opts.getCallback();
        this.schema = opts.getSchema();
        this.writerVersion = opts.getWriterVersion();
        this.bloomFilterVersion = opts.getBloomFilterVersion();
        this.callbackContext = this.callback != null ? new OrcFile.WriterContext(){

            @Override
            public Writer getWriter() {
                return WriterImplV2.this;
            }
        } : null;
        this.writeTimeZone = WriterImplV2.hasTimestamp(this.schema);
        this.useUTCTimeZone = opts.getUseUTCTimestamp();
        this.adjustedStripeSize = opts.getStripeSize();
        this.version = opts.getVersion();
        this.encodingStrategy = opts.getEncodingStrategy();
        this.compressionStrategy = opts.getCompressionStrategy();
        this.compress = opts.getCompress();
        this.rowIndexStride = opts.getRowIndexStride();
        this.memoryManager = opts.getMemoryManager();
        this.buildIndex = this.rowIndexStride > 0;
        int numColumns = this.schema.getMaximumId() + 1;
        if (opts.isEnforceBufferSize()) {
            OutStream.assertBufferSizeValid(opts.getBufferSize());
            this.bufferSize = opts.getBufferSize();
        } else {
            this.bufferSize = WriterImpl.getEstimatedBufferSize(this.adjustedStripeSize, numColumns, opts.getBufferSize());
        }
        if (this.version == OrcFile.Version.FUTURE) {
            throw new IllegalArgumentException("Can not write in a unknown version.");
        }
        if (this.version == OrcFile.Version.UNSTABLE_PRE_2_0) {
            LOG.warn("ORC files written in " + this.version.getName() + " will not be readable by other versions of the software. It is only for developer testing.");
        }
        this.bloomFilterColumns = this.version == OrcFile.Version.V_0_11 ? new boolean[this.schema.getMaximumId() + 1] : OrcUtils.includeColumns(opts.getBloomFilterColumns(), this.schema);
        this.bloomFilterFpp = opts.getBloomFilterFpp();
        this.physicalWriter = opts.getPhysicalWriter() == null ? new PhysicalFsWriter(fs, path, opts) : opts.getPhysicalWriter();
        this.physicalWriter.writeHeader();
        this.treeWriter = TreeWriter.Factory.create(this.schema, new StreamFactory(), false);
        if (this.buildIndex && this.rowIndexStride < 1000) {
            throw new IllegalArgumentException("Row stride must be at least 1000");
        }
        this.memoryManager.addWriter(path, opts.getStripeSize(), this);
        LOG.info("ORC writer created for path: {} with stripeSize: {} blockSize: {} compression: {} bufferSize: {}", new Object[]{path, this.adjustedStripeSize, opts.getBlockSize(), this.compress, this.bufferSize});
    }

    @Override
    public boolean checkMemory(double newScale) throws IOException {
        long limit = Math.round((double)this.adjustedStripeSize * newScale);
        long size = this.treeWriter.estimateMemory();
        if (LOG.isDebugEnabled()) {
            LOG.debug("ORC writer " + this.physicalWriter + " size = " + size + " limit = " + limit);
        }
        if (size > limit) {
            this.flushStripe();
            return true;
        }
        return false;
    }

    CompressionCodec getCustomizedCodec(OrcProto.Stream.Kind kind) {
        CompressionCodec result = this.physicalWriter.getCompressionCodec();
        if (result != null) {
            switch (kind) {
                case BLOOM_FILTER: 
                case DATA: 
                case DICTIONARY_DATA: 
                case BLOOM_FILTER_UTF8: {
                    if (this.compressionStrategy == OrcFile.CompressionStrategy.SPEED) {
                        result = result.modify(EnumSet.of(CompressionCodec.Modifier.FAST, CompressionCodec.Modifier.TEXT));
                        break;
                    }
                    result = result.modify(EnumSet.of(CompressionCodec.Modifier.DEFAULT, CompressionCodec.Modifier.TEXT));
                    break;
                }
                case LENGTH: 
                case DICTIONARY_COUNT: 
                case PRESENT: 
                case ROW_INDEX: 
                case SECONDARY: {
                    result = result.modify(EnumSet.of(CompressionCodec.Modifier.FASTEST, CompressionCodec.Modifier.BINARY));
                    break;
                }
                default: {
                    LOG.info("Missing ORC compression modifiers for " + kind);
                }
            }
        }
        return result;
    }

    @Override
    public void increaseCompressionSize(int newSize) {
        if (newSize > this.bufferSize) {
            this.bufferSize = newSize;
        }
    }

    private static void writeTypes(OrcProto.Footer.Builder builder, TypeDescription schema) {
        builder.addAllTypes(OrcUtils.getOrcTypes(schema));
    }

    private void createRowIndexEntry() throws IOException {
        this.treeWriter.createRowIndexEntry();
        this.rowsInIndex = 0;
    }

    private void flushStripe() throws IOException {
        if (this.buildIndex && this.rowsInIndex != 0) {
            this.createRowIndexEntry();
        }
        if (this.rowsInStripe != 0L) {
            if (this.callback != null) {
                this.callback.preStripeWrite(this.callbackContext);
            }
            int requiredIndexEntries = this.rowIndexStride == 0 ? 0 : (int)((this.rowsInStripe + (long)this.rowIndexStride - 1L) / (long)this.rowIndexStride);
            OrcProto.StripeFooter.Builder builder = OrcProto.StripeFooter.newBuilder();
            if (this.writeTimeZone) {
                if (this.useUTCTimeZone) {
                    builder.setWriterTimezone("UTC");
                } else {
                    builder.setWriterTimezone(TimeZone.getDefault().getID());
                }
            }
            OrcProto.StripeStatistics.Builder stats = OrcProto.StripeStatistics.newBuilder();
            this.treeWriter.flushStreams();
            this.treeWriter.writeStripe(builder, stats, requiredIndexEntries);
            OrcProto.StripeInformation.Builder dirEntry = OrcProto.StripeInformation.newBuilder().setNumberOfRows(this.rowsInStripe);
            this.physicalWriter.finalizeStripe(builder, dirEntry);
            this.fileMetadata.addStripeStats(stats.build());
            this.stripes.add(dirEntry.build());
            this.rowCount += this.rowsInStripe;
            this.rowsInStripe = 0L;
        }
    }

    private long computeRawDataSize() {
        return this.treeWriter.getRawDataSize();
    }

    private OrcProto.CompressionKind writeCompressionKind(CompressionKind kind) {
        switch (kind) {
            case NONE: {
                return OrcProto.CompressionKind.NONE;
            }
            case ZLIB: {
                return OrcProto.CompressionKind.ZLIB;
            }
            case SNAPPY: {
                return OrcProto.CompressionKind.SNAPPY;
            }
            case LZO: {
                return OrcProto.CompressionKind.LZO;
            }
            case LZ4: {
                return OrcProto.CompressionKind.LZ4;
            }
        }
        throw new IllegalArgumentException("Unknown compression " + (Object)((Object)kind));
    }

    private void writeFileStatistics(OrcProto.Footer.Builder builder, TreeWriter writer) throws IOException {
        writer.writeFileStatistics(builder);
    }

    private void writeMetadata() throws IOException {
        this.physicalWriter.writeFileMetadata(this.fileMetadata);
    }

    private long writePostScript() throws IOException {
        OrcProto.PostScript.Builder builder = OrcProto.PostScript.newBuilder().setCompression(this.writeCompressionKind(this.compress)).setMagic("ORC").addVersion(this.version.getMajor()).addVersion(this.version.getMinor()).setWriterVersion(this.writerVersion.getId());
        if (this.compress != CompressionKind.NONE) {
            builder.setCompressionBlockSize(this.bufferSize);
        }
        return this.physicalWriter.writePostScript(builder);
    }

    private long writeFooter() throws IOException {
        this.writeMetadata();
        OrcProto.Footer.Builder builder = OrcProto.Footer.newBuilder();
        builder.setNumberOfRows(this.rowCount);
        builder.setRowIndexStride(this.rowIndexStride);
        this.rawDataSize = this.computeRawDataSize();
        WriterImplV2.writeTypes(builder, this.schema);
        for (OrcProto.StripeInformation stripeInformation : this.stripes) {
            builder.addStripes(stripeInformation);
        }
        this.writeFileStatistics(builder, this.treeWriter);
        for (Map.Entry entry : this.userMetadata.entrySet()) {
            builder.addMetadata(OrcProto.UserMetadataItem.newBuilder().setName((String)entry.getKey()).setValue((ByteString)entry.getValue()));
        }
        builder.setWriter(OrcFile.WriterImplementation.ORC_JAVA.getId());
        this.physicalWriter.writeFileFooter(builder);
        return this.writePostScript();
    }

    @Override
    public TypeDescription getSchema() {
        return this.schema;
    }

    @Override
    public void addUserMetadata(String name, ByteBuffer value) {
        this.userMetadata.put(name, ByteString.copyFrom(value));
    }

    @Override
    public void addRowBatch(VectorizedRowBatch batch) throws IOException {
        if (this.buildIndex) {
            int posn = 0;
            while (posn < batch.size) {
                int chunkSize = Math.min(batch.size - posn, this.rowIndexStride - this.rowsInIndex);
                this.treeWriter.writeRootBatch(batch, posn, chunkSize);
                posn += chunkSize;
                this.rowsInIndex += chunkSize;
                this.rowsInStripe += (long)chunkSize;
                if (this.rowsInIndex < this.rowIndexStride) continue;
                this.createRowIndexEntry();
            }
        } else {
            this.rowsInStripe += (long)batch.size;
            this.treeWriter.writeRootBatch(batch, 0, batch.size);
        }
        this.memoryManager.addedRow(batch.size);
    }

    @Override
    public void close() throws IOException {
        if (this.callback != null) {
            this.callback.preFooterWrite(this.callbackContext);
        }
        this.memoryManager.removeWriter(this.path);
        this.flushStripe();
        this.lastFlushOffset = this.writeFooter();
        this.physicalWriter.close();
    }

    @Override
    public long getRawDataSize() {
        return this.rawDataSize;
    }

    @Override
    public long getNumberOfRows() {
        return this.rowCount;
    }

    @Override
    public long writeIntermediateFooter() throws IOException {
        this.flushStripe();
        if (this.stripesAtLastFlush != this.stripes.size()) {
            if (this.callback != null) {
                this.callback.preFooterWrite(this.callbackContext);
            }
            this.lastFlushOffset = this.writeFooter();
            this.stripesAtLastFlush = this.stripes.size();
            this.physicalWriter.flush();
        }
        return this.lastFlushOffset;
    }

    static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public void appendStripe(byte[] stripe, int offset, int length, StripeInformation stripeInfo, OrcProto.StripeStatistics stripeStatistics) throws IOException {
        WriterImplV2.checkArgument(stripe != null, "Stripe must not be null");
        WriterImplV2.checkArgument(length <= stripe.length, "Specified length must not be greater specified array length");
        WriterImplV2.checkArgument(stripeInfo != null, "Stripe information must not be null");
        WriterImplV2.checkArgument(stripeStatistics != null, "Stripe statistics must not be null");
        this.rowsInStripe = stripeInfo.getNumberOfRows();
        OrcProto.StripeInformation.Builder dirEntry = OrcProto.StripeInformation.newBuilder().setNumberOfRows(this.rowsInStripe).setIndexLength(stripeInfo.getIndexLength()).setDataLength(stripeInfo.getDataLength()).setFooterLength(stripeInfo.getFooterLength());
        this.physicalWriter.appendRawStripe(ByteBuffer.wrap(stripe, offset, length), dirEntry);
        this.treeWriter.updateFileStatistics(stripeStatistics);
        this.fileMetadata.addStripeStats(stripeStatistics);
        this.stripes.add(dirEntry.build());
        this.rowCount += this.rowsInStripe;
        this.rowsInStripe = 0L;
    }

    @Override
    public void appendUserMetadata(List<OrcProto.UserMetadataItem> userMetadata) {
        if (userMetadata != null) {
            for (OrcProto.UserMetadataItem item : userMetadata) {
                this.userMetadata.put(item.getName(), item.getValue());
            }
        }
    }

    @Override
    public ColumnStatistics[] getStatistics() throws IOException {
        OrcProto.Footer.Builder builder = OrcProto.Footer.newBuilder();
        this.writeFileStatistics(builder, this.treeWriter);
        return ReaderImpl.deserializeStats(this.schema, builder.getStatisticsList());
    }

    public CompressionCodec getCompressionCodec() {
        return this.physicalWriter.getCompressionCodec();
    }

    private static boolean hasTimestamp(TypeDescription schema) {
        if (schema.getCategory() == TypeDescription.Category.TIMESTAMP) {
            return true;
        }
        List<TypeDescription> children = schema.getChildren();
        if (children != null) {
            for (TypeDescription child : children) {
                if (!WriterImplV2.hasTimestamp(child)) continue;
                return true;
            }
        }
        return false;
    }

    private class StreamFactory
    implements WriterContext {
        private StreamFactory() {
        }

        @Override
        public OutStream createStream(int column, OrcProto.Stream.Kind kind) throws IOException {
            StreamName name = new StreamName(column, kind);
            CompressionCodec codec = WriterImplV2.this.getCustomizedCodec(kind);
            return new OutStream(WriterImplV2.this.physicalWriter.toString(), WriterImplV2.this.bufferSize, codec, WriterImplV2.this.physicalWriter.createDataStream(name));
        }

        @Override
        public int getRowIndexStride() {
            return WriterImplV2.this.rowIndexStride;
        }

        @Override
        public boolean buildIndex() {
            return WriterImplV2.this.buildIndex;
        }

        @Override
        public boolean isCompressed() {
            return WriterImplV2.this.physicalWriter.getCompressionCodec() != null;
        }

        @Override
        public OrcFile.EncodingStrategy getEncodingStrategy() {
            return WriterImplV2.this.encodingStrategy;
        }

        @Override
        public boolean[] getBloomFilterColumns() {
            return WriterImplV2.this.bloomFilterColumns;
        }

        @Override
        public double getBloomFilterFPP() {
            return WriterImplV2.this.bloomFilterFpp;
        }

        @Override
        public Configuration getConfiguration() {
            return WriterImplV2.this.conf;
        }

        @Override
        public OrcFile.Version getVersion() {
            return WriterImplV2.this.version;
        }

        @Override
        public PhysicalWriter getPhysicalWriter() {
            return WriterImplV2.this.physicalWriter;
        }

        @Override
        public OrcFile.BloomFilterVersion getBloomFilterVersion() {
            return WriterImplV2.this.bloomFilterVersion;
        }

        @Override
        public void writeIndex(StreamName name, OrcProto.RowIndex.Builder index) throws IOException {
            WriterImplV2.this.physicalWriter.writeIndex(name, index, WriterImplV2.this.getCustomizedCodec(name.getKind()));
        }

        @Override
        public void writeBloomFilter(StreamName name, OrcProto.BloomFilterIndex.Builder bloom) throws IOException {
            WriterImplV2.this.physicalWriter.writeBloomFilter(name, bloom, WriterImplV2.this.getCustomizedCodec(name.getKind()));
        }

        @Override
        public boolean getUseUTCTimestamp() {
            return WriterImplV2.this.useUTCTimeZone;
        }
    }
}

