/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector;

import hive.com.google.common.base.Charsets;
import hive.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.IntervalDayTimeColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorAssignRow;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedBatchUtil;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorPartitionConversion;
import org.apache.hadoop.hive.serde2.fast.DeserializeRead;
import org.apache.hadoop.hive.serde2.io.ByteWritable;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveCharWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalDayTimeWritable;
import org.apache.hadoop.hive.serde2.io.HiveIntervalYearMonthWritable;
import org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import org.apache.hadoop.hive.serde2.io.ShortWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritable;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.CharTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class VectorDeserializeRow<T extends DeserializeRead> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(VectorDeserializeRow.class);
    private T deserializeRead;
    private TypeInfo[] sourceTypeInfos;
    private byte[] inputBytes;
    private boolean useReadField;
    private int[] readFieldLogicalIndices;
    private boolean[] isConvert;
    private int[] projectionColumnNums;
    private ObjectInspector.Category[] sourceCategories;
    private PrimitiveObjectInspector.PrimitiveCategory[] sourcePrimitiveCategories;
    private int[] maxLengths;
    Writable[] convertSourceWritables;
    VectorAssignRow convertVectorAssignRow;

    public VectorDeserializeRow(T deserializeRead) {
        this();
        this.deserializeRead = deserializeRead;
        this.sourceTypeInfos = ((DeserializeRead)deserializeRead).typeInfos();
    }

    private VectorDeserializeRow() {
    }

    private void allocateArrays(int count) {
        this.isConvert = new boolean[count];
        this.projectionColumnNums = new int[count];
        Arrays.fill(this.projectionColumnNums, -1);
        this.sourceCategories = new ObjectInspector.Category[count];
        this.sourcePrimitiveCategories = new PrimitiveObjectInspector.PrimitiveCategory[count];
        this.maxLengths = new int[count];
    }

    private void allocateConvertArrays(int count) {
        this.convertSourceWritables = new Writable[count];
    }

    private void initSourceEntry(int logicalColumnIndex, int projectionColumnNum, TypeInfo sourceTypeInfo) {
        ObjectInspector.Category sourceCategory;
        this.isConvert[logicalColumnIndex] = false;
        this.projectionColumnNums[logicalColumnIndex] = projectionColumnNum;
        this.sourceCategories[logicalColumnIndex] = sourceCategory = sourceTypeInfo.getCategory();
        if (sourceCategory == ObjectInspector.Category.PRIMITIVE) {
            PrimitiveObjectInspector.PrimitiveCategory sourcePrimitiveCategory;
            PrimitiveTypeInfo sourcePrimitiveTypeInfo = (PrimitiveTypeInfo)sourceTypeInfo;
            this.sourcePrimitiveCategories[logicalColumnIndex] = sourcePrimitiveCategory = sourcePrimitiveTypeInfo.getPrimitiveCategory();
            switch (sourcePrimitiveCategory) {
                case CHAR: {
                    this.maxLengths[logicalColumnIndex] = ((CharTypeInfo)sourcePrimitiveTypeInfo).getLength();
                    break;
                }
                case VARCHAR: {
                    this.maxLengths[logicalColumnIndex] = ((VarcharTypeInfo)sourcePrimitiveTypeInfo).getLength();
                    break;
                }
            }
        } else {
            Preconditions.checkState(false);
        }
    }

    private void initConvertTargetEntry(int logicalColumnIndex) {
        this.isConvert[logicalColumnIndex] = true;
        if (this.sourceCategories[logicalColumnIndex] == ObjectInspector.Category.PRIMITIVE) {
            this.convertSourceWritables[logicalColumnIndex] = VectorizedBatchUtil.getPrimitiveWritable(this.sourcePrimitiveCategories[logicalColumnIndex]);
        } else {
            Preconditions.checkState(false);
        }
    }

    public void init(int[] outputColumns) throws HiveException {
        int count = this.sourceTypeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int outputColumn = outputColumns[i];
            this.initSourceEntry(i, outputColumn, this.sourceTypeInfos[i]);
        }
    }

    public void init(List<Integer> outputColumns) throws HiveException {
        int count = this.sourceTypeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int outputColumn = outputColumns.get(i);
            this.initSourceEntry(i, outputColumn, this.sourceTypeInfos[i]);
        }
    }

    public void init(int startColumn) throws HiveException {
        int count = this.sourceTypeInfos.length;
        this.allocateArrays(count);
        for (int i = 0; i < count; ++i) {
            int outputColumn = startColumn + i;
            this.initSourceEntry(i, outputColumn, this.sourceTypeInfos[i]);
        }
    }

    public void init(boolean[] columnsToIncludeTruncated) throws HiveException {
        Preconditions.checkState(columnsToIncludeTruncated == null || columnsToIncludeTruncated.length == this.sourceTypeInfos.length);
        int columnCount = this.sourceTypeInfos.length;
        this.allocateArrays(columnCount);
        int includedCount = 0;
        int[] includedIndices = new int[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            if (columnsToIncludeTruncated != null && !columnsToIncludeTruncated[i]) continue;
            this.initSourceEntry(i, i, this.sourceTypeInfos[i]);
            includedIndices[includedCount++] = i;
        }
        if (includedCount < columnCount && ((DeserializeRead)this.deserializeRead).isReadFieldSupported()) {
            this.useReadField = true;
            this.readFieldLogicalIndices = Arrays.copyOf(includedIndices, includedCount);
        }
    }

    public void initConversion(TypeInfo[] targetTypeInfos, boolean[] columnsToIncludeTruncated) throws HiveException {
        Preconditions.checkState(targetTypeInfos.length >= this.sourceTypeInfos.length);
        Preconditions.checkState(columnsToIncludeTruncated == null || columnsToIncludeTruncated.length >= this.sourceTypeInfos.length);
        int columnCount = this.sourceTypeInfos.length;
        this.allocateArrays(columnCount);
        this.allocateConvertArrays(columnCount);
        int includedCount = 0;
        int[] includedIndices = new int[columnCount];
        boolean atLeastOneConvert = false;
        for (int i = 0; i < columnCount; ++i) {
            if (columnsToIncludeTruncated != null && !columnsToIncludeTruncated[i]) continue;
            TypeInfo sourceTypeInfo = this.sourceTypeInfos[i];
            TypeInfo targetTypeInfo = targetTypeInfos[i];
            if (!sourceTypeInfo.equals(targetTypeInfo)) {
                if (VectorPartitionConversion.isImplicitVectorColumnConversion(sourceTypeInfo, targetTypeInfo)) {
                    this.initSourceEntry(i, i, sourceTypeInfo);
                } else {
                    this.initSourceEntry(i, i, sourceTypeInfo);
                    this.initConvertTargetEntry(i);
                    atLeastOneConvert = true;
                }
            } else {
                this.initSourceEntry(i, i, sourceTypeInfo);
            }
            includedIndices[includedCount++] = i;
        }
        if (includedCount < columnCount && ((DeserializeRead)this.deserializeRead).isReadFieldSupported()) {
            this.useReadField = true;
            this.readFieldLogicalIndices = Arrays.copyOf(includedIndices, includedCount);
        }
        if (atLeastOneConvert) {
            this.convertVectorAssignRow = new VectorAssignRow();
            this.convertVectorAssignRow.initConversion(this.sourceTypeInfos, targetTypeInfos, columnsToIncludeTruncated);
        }
    }

    public void init() throws HiveException {
        this.init(0);
    }

    private void storeRowColumn(VectorizedRowBatch batch, int batchIndex, int logicalColumnIndex, boolean canRetainByteRef) throws IOException {
        int projectionColumnNum = this.projectionColumnNums[logicalColumnIndex];
        block0 : switch (this.sourceCategories[logicalColumnIndex]) {
            case PRIMITIVE: {
                PrimitiveObjectInspector.PrimitiveCategory sourcePrimitiveCategory = this.sourcePrimitiveCategories[logicalColumnIndex];
                switch (sourcePrimitiveCategory) {
                    case VOID: {
                        VectorizedBatchUtil.setNullColIsNullValue(batch.cols[projectionColumnNum], batchIndex);
                        return;
                    }
                    case BOOLEAN: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentBoolean ? 1 : 0;
                        break block0;
                    }
                    case BYTE: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentByte;
                        break block0;
                    }
                    case SHORT: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentShort;
                        break block0;
                    }
                    case INT: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentInt;
                        break block0;
                    }
                    case LONG: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentLong;
                        break block0;
                    }
                    case TIMESTAMP: {
                        ((TimestampColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, ((DeserializeRead)this.deserializeRead).currentTimestampWritable.getTimestamp());
                        break block0;
                    }
                    case DATE: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentDateWritable.getDays();
                        break block0;
                    }
                    case FLOAT: {
                        ((DoubleColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentFloat;
                        break block0;
                    }
                    case DOUBLE: {
                        ((DoubleColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentDouble;
                        break block0;
                    }
                    case BINARY: 
                    case STRING: {
                        BytesColumnVector bytesColVec = (BytesColumnVector)batch.cols[projectionColumnNum];
                        if (((DeserializeRead)this.deserializeRead).currentExternalBufferNeeded) {
                            bytesColVec.ensureValPreallocated(((DeserializeRead)this.deserializeRead).currentExternalBufferNeededLen);
                            ((DeserializeRead)this.deserializeRead).copyToExternalBuffer(bytesColVec.getValPreallocatedBytes(), bytesColVec.getValPreallocatedStart());
                            bytesColVec.setValPreallocated(batchIndex, ((DeserializeRead)this.deserializeRead).currentExternalBufferNeededLen);
                            break block0;
                        }
                        if (canRetainByteRef && this.inputBytes == ((DeserializeRead)this.deserializeRead).currentBytes) {
                            bytesColVec.setRef(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength);
                            break block0;
                        }
                        bytesColVec.setVal(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength);
                        break block0;
                    }
                    case VARCHAR: {
                        BytesColumnVector bytesColVec = (BytesColumnVector)batch.cols[projectionColumnNum];
                        if (((DeserializeRead)this.deserializeRead).currentExternalBufferNeeded) {
                            bytesColVec.ensureValPreallocated(((DeserializeRead)this.deserializeRead).currentExternalBufferNeededLen);
                            byte[] convertBuffer = bytesColVec.getValPreallocatedBytes();
                            int convertBufferStart = bytesColVec.getValPreallocatedStart();
                            ((DeserializeRead)this.deserializeRead).copyToExternalBuffer(convertBuffer, convertBufferStart);
                            bytesColVec.setValPreallocated(batchIndex, StringExpr.truncate(convertBuffer, convertBufferStart, ((DeserializeRead)this.deserializeRead).currentExternalBufferNeededLen, this.maxLengths[logicalColumnIndex]));
                            break block0;
                        }
                        if (canRetainByteRef && this.inputBytes == ((DeserializeRead)this.deserializeRead).currentBytes) {
                            bytesColVec.setRef(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, StringExpr.truncate(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength, this.maxLengths[logicalColumnIndex]));
                            break block0;
                        }
                        bytesColVec.setVal(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, StringExpr.truncate(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength, this.maxLengths[logicalColumnIndex]));
                        break block0;
                    }
                    case CHAR: {
                        BytesColumnVector bytesColVec = (BytesColumnVector)batch.cols[projectionColumnNum];
                        if (((DeserializeRead)this.deserializeRead).currentExternalBufferNeeded) {
                            bytesColVec.ensureValPreallocated(((DeserializeRead)this.deserializeRead).currentExternalBufferNeededLen);
                            byte[] convertBuffer = bytesColVec.getValPreallocatedBytes();
                            int convertBufferStart = bytesColVec.getValPreallocatedStart();
                            ((DeserializeRead)this.deserializeRead).copyToExternalBuffer(convertBuffer, convertBufferStart);
                            bytesColVec.setValPreallocated(batchIndex, StringExpr.rightTrimAndTruncate(convertBuffer, convertBufferStart, ((DeserializeRead)this.deserializeRead).currentExternalBufferNeededLen, this.maxLengths[logicalColumnIndex]));
                            break block0;
                        }
                        if (canRetainByteRef && this.inputBytes == ((DeserializeRead)this.deserializeRead).currentBytes) {
                            bytesColVec.setRef(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, StringExpr.rightTrimAndTruncate(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength, this.maxLengths[logicalColumnIndex]));
                            break block0;
                        }
                        bytesColVec.setVal(batchIndex, ((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, StringExpr.rightTrimAndTruncate(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength, this.maxLengths[logicalColumnIndex]));
                        break block0;
                    }
                    case DECIMAL: {
                        ((DecimalColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, ((DeserializeRead)this.deserializeRead).currentHiveDecimalWritable);
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        ((LongColumnVector)batch.cols[projectionColumnNum]).vector[batchIndex] = ((DeserializeRead)this.deserializeRead).currentHiveIntervalYearMonthWritable.getHiveIntervalYearMonth().getTotalMonths();
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        ((IntervalDayTimeColumnVector)batch.cols[projectionColumnNum]).set(batchIndex, ((DeserializeRead)this.deserializeRead).currentHiveIntervalDayTimeWritable.getHiveIntervalDayTime());
                        break block0;
                    }
                }
                throw new RuntimeException("Primitive category " + sourcePrimitiveCategory.name() + " not supported");
            }
            default: {
                throw new RuntimeException("Category " + (Object)((Object)this.sourceCategories[logicalColumnIndex]) + " not supported");
            }
        }
        batch.cols[projectionColumnNum].isNull[batchIndex] = false;
    }

    private void convertRowColumn(VectorizedRowBatch batch, int batchIndex, int logicalColumnIndex) throws IOException {
        int projectionColumnNum = this.projectionColumnNums[logicalColumnIndex];
        Writable convertSourceWritable = this.convertSourceWritables[logicalColumnIndex];
        block0 : switch (this.sourceCategories[logicalColumnIndex]) {
            case PRIMITIVE: {
                switch (this.sourcePrimitiveCategories[logicalColumnIndex]) {
                    case VOID: {
                        convertSourceWritable = null;
                        break block0;
                    }
                    case BOOLEAN: {
                        ((BooleanWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentBoolean);
                        break block0;
                    }
                    case BYTE: {
                        ((ByteWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentByte);
                        break block0;
                    }
                    case SHORT: {
                        ((ShortWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentShort);
                        break block0;
                    }
                    case INT: {
                        ((IntWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentInt);
                        break block0;
                    }
                    case LONG: {
                        ((LongWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentLong);
                        break block0;
                    }
                    case TIMESTAMP: {
                        ((TimestampWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentTimestampWritable);
                        break block0;
                    }
                    case DATE: {
                        ((DateWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentDateWritable);
                        break block0;
                    }
                    case FLOAT: {
                        ((FloatWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentFloat);
                        break block0;
                    }
                    case DOUBLE: {
                        ((DoubleWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentDouble);
                        break block0;
                    }
                    case BINARY: {
                        if (((DeserializeRead)this.deserializeRead).currentBytes == null) {
                            LOG.info("null binary entry: batchIndex " + batchIndex + " projection column num " + projectionColumnNum);
                        }
                        ((BytesWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength);
                        break block0;
                    }
                    case STRING: {
                        if (((DeserializeRead)this.deserializeRead).currentBytes == null) {
                            throw new RuntimeException("null string entry: batchIndex " + batchIndex + " projection column num " + projectionColumnNum);
                        }
                        ((Text)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength);
                        break block0;
                    }
                    case VARCHAR: {
                        if (((DeserializeRead)this.deserializeRead).currentBytes == null) {
                            throw new RuntimeException("null varchar entry: batchIndex " + batchIndex + " projection column num " + projectionColumnNum);
                        }
                        int adjustedLength = StringExpr.truncate(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength, this.maxLengths[logicalColumnIndex]);
                        ((HiveVarcharWritable)convertSourceWritable).set(new String(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, adjustedLength, Charsets.UTF_8), -1);
                        break block0;
                    }
                    case CHAR: {
                        if (((DeserializeRead)this.deserializeRead).currentBytes == null) {
                            throw new RuntimeException("null char entry: batchIndex " + batchIndex + " projection column num " + projectionColumnNum);
                        }
                        int adjustedLength = StringExpr.rightTrimAndTruncate(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, ((DeserializeRead)this.deserializeRead).currentBytesLength, this.maxLengths[logicalColumnIndex]);
                        ((HiveCharWritable)convertSourceWritable).set(new String(((DeserializeRead)this.deserializeRead).currentBytes, ((DeserializeRead)this.deserializeRead).currentBytesStart, adjustedLength, Charsets.UTF_8), -1);
                        break block0;
                    }
                    case DECIMAL: {
                        ((HiveDecimalWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentHiveDecimalWritable);
                        break block0;
                    }
                    case INTERVAL_YEAR_MONTH: {
                        ((HiveIntervalYearMonthWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentHiveIntervalYearMonthWritable);
                        break block0;
                    }
                    case INTERVAL_DAY_TIME: {
                        ((HiveIntervalDayTimeWritable)convertSourceWritable).set(((DeserializeRead)this.deserializeRead).currentHiveIntervalDayTimeWritable);
                        break block0;
                    }
                }
                throw new RuntimeException("Primitive category " + (Object)((Object)this.sourcePrimitiveCategories[logicalColumnIndex]) + " not supported");
            }
            default: {
                throw new RuntimeException("Category " + (Object)((Object)this.sourceCategories[logicalColumnIndex]) + " not supported");
            }
        }
        this.convertVectorAssignRow.assignConvertRowColumn(batch, batchIndex, logicalColumnIndex, convertSourceWritable);
    }

    public void setBytes(byte[] bytes, int offset, int length) {
        this.inputBytes = bytes;
        ((DeserializeRead)this.deserializeRead).set(bytes, offset, length);
    }

    public void deserialize(VectorizedRowBatch batch, int batchIndex) throws IOException {
        int count = this.isConvert.length;
        if (!this.useReadField) {
            for (int i = 0; i < count; ++i) {
                int projectionColumnNum = this.projectionColumnNums[i];
                if (projectionColumnNum == -1) {
                    ((DeserializeRead)this.deserializeRead).skipNextField();
                    continue;
                }
                if (!((DeserializeRead)this.deserializeRead).readNextField()) {
                    ColumnVector colVector = batch.cols[projectionColumnNum];
                    colVector.isNull[batchIndex] = true;
                    colVector.noNulls = false;
                    continue;
                }
                if (this.isConvert[i]) {
                    this.convertRowColumn(batch, batchIndex, i);
                    continue;
                }
                this.storeRowColumn(batch, batchIndex, i, false);
            }
        } else {
            for (int logicalIndex : this.readFieldLogicalIndices) {
                if (!((DeserializeRead)this.deserializeRead).readField(logicalIndex)) {
                    ColumnVector colVector = batch.cols[this.projectionColumnNums[logicalIndex]];
                    colVector.isNull[batchIndex] = true;
                    colVector.noNulls = false;
                    continue;
                }
                if (this.isConvert[logicalIndex]) {
                    this.convertRowColumn(batch, batchIndex, logicalIndex);
                    continue;
                }
                this.storeRowColumn(batch, batchIndex, logicalIndex, false);
            }
        }
    }

    public void deserializeByRef(VectorizedRowBatch batch, int batchIndex) throws IOException {
        int count = this.isConvert.length;
        if (!this.useReadField) {
            for (int i = 0; i < count; ++i) {
                int projectionColumnNum = this.projectionColumnNums[i];
                if (projectionColumnNum == -1) {
                    ((DeserializeRead)this.deserializeRead).skipNextField();
                    continue;
                }
                if (!((DeserializeRead)this.deserializeRead).readNextField()) {
                    ColumnVector colVector = batch.cols[projectionColumnNum];
                    colVector.isNull[batchIndex] = true;
                    colVector.noNulls = false;
                    continue;
                }
                if (this.isConvert[i]) {
                    this.convertRowColumn(batch, batchIndex, i);
                    continue;
                }
                this.storeRowColumn(batch, batchIndex, i, true);
            }
        } else {
            for (int logicalIndex : this.readFieldLogicalIndices) {
                if (!((DeserializeRead)this.deserializeRead).readField(logicalIndex)) {
                    ColumnVector colVector = batch.cols[this.projectionColumnNums[logicalIndex]];
                    colVector.isNull[batchIndex] = true;
                    colVector.noNulls = false;
                    continue;
                }
                if (this.isConvert[logicalIndex]) {
                    this.convertRowColumn(batch, batchIndex, logicalIndex);
                    continue;
                }
                this.storeRowColumn(batch, batchIndex, logicalIndex, true);
            }
        }
    }

    public String getDetailedReadPositionString() {
        return ((DeserializeRead)this.deserializeRead).getDetailedReadPositionString();
    }
}

