/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import hive.org.apache.commons.lang3.tuple.ImmutablePair;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.jsonexplain.JsonParser;
import org.apache.hadoop.hive.common.jsonexplain.JsonParserFactory;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.Driver;
import org.apache.hadoop.hive.ql.DriverContext;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.vector.VectorReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.vector.reducesink.VectorReduceSinkCommonOperator;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.physical.StageIDsRearranger;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SparkWork;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationFactory;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hive.common.util.AnnotationUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExplainTask
extends Task<ExplainWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String EXPL_COLUMN_NAME = "Explain";
    public static final String OUTPUT_OPERATORS = "OutputOperators:";
    private final Set<Operator<?>> visitedOps = new HashSet();
    private boolean isLogical = false;
    protected final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());
    private static String trueCondNameVectorizationEnabled = HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED.varname + " IS true";
    private static String falseCondNameVectorizationEnabled = HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED.varname + " IS false";

    private static JSONObject getJSONDependencies(ExplainWork work) throws Exception {
        assert (work.getDependency());
        JSONObject outJSONObject = new JSONObject(new LinkedHashMap());
        JSONArray inputTableInfo = new JSONArray();
        JSONArray inputPartitionInfo = new JSONArray();
        for (ReadEntity input : work.getInputs()) {
            switch (input.getType()) {
                case TABLE: {
                    Table table = input.getTable();
                    JSONObject tableInfo = new JSONObject();
                    tableInfo.put("tablename", table.getCompleteName());
                    tableInfo.put("tabletype", table.getTableType().toString());
                    if (input.getParents() != null && !input.getParents().isEmpty()) {
                        tableInfo.put("tableParents", input.getParents().toString());
                    }
                    inputTableInfo.put(tableInfo);
                    break;
                }
                case PARTITION: {
                    JSONObject partitionInfo = new JSONObject();
                    partitionInfo.put("partitionName", input.getPartition().getCompleteName());
                    if (input.getParents() != null && !input.getParents().isEmpty()) {
                        partitionInfo.put("partitionParents", input.getParents().toString());
                    }
                    inputPartitionInfo.put(partitionInfo);
                    break;
                }
            }
        }
        outJSONObject.put("input_tables", inputTableInfo);
        outJSONObject.put("input_partitions", inputPartitionInfo);
        return outJSONObject;
    }

    public JSONObject getJSONLogicalPlan(PrintStream out, ExplainWork work) throws Exception {
        this.isLogical = true;
        JSONObject outJSONObject = new JSONObject(new LinkedHashMap());
        boolean jsonOutput = work.isFormatted();
        if (jsonOutput) {
            out = null;
        }
        if (work.getParseContext() != null) {
            if (out != null) {
                out.print("LOGICAL PLAN:");
            }
            JSONObject jsonPlan = this.outputMap(work.getParseContext().getTopOps(), true, out, work.getExtended(), jsonOutput, 0);
            if (out != null) {
                out.println();
            }
            if (jsonOutput) {
                outJSONObject.put("LOGICAL PLAN", jsonPlan);
            }
        } else {
            System.err.println("No parse context!");
        }
        return outJSONObject;
    }

    private ImmutablePair<Boolean, JSONObject> outputPlanVectorization(PrintStream out, boolean jsonOutput) throws Exception {
        if (out != null) {
            out.println("PLAN VECTORIZATION:");
        }
        JSONObject json = jsonOutput ? new JSONObject(new LinkedHashMap()) : null;
        HiveConf hiveConf = this.queryState.getConf();
        boolean isVectorizationEnabled = HiveConf.getBoolVar(hiveConf, HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED);
        String isVectorizationEnabledCondName = isVectorizationEnabled ? trueCondNameVectorizationEnabled : falseCondNameVectorizationEnabled;
        List<String> isVectorizationEnabledCondList = Arrays.asList(isVectorizationEnabledCondName);
        if (out != null) {
            out.print(ExplainTask.indentString(2));
            out.print("enabled: ");
            out.println(isVectorizationEnabled);
            out.print(ExplainTask.indentString(2));
            if (!isVectorizationEnabled) {
                out.print("enabledConditionsNotMet: ");
            } else {
                out.print("enabledConditionsMet: ");
            }
            out.println(isVectorizationEnabledCondList);
        }
        if (jsonOutput) {
            json.put("enabled", isVectorizationEnabled);
            JSONArray jsonArray = new JSONArray(Arrays.asList(isVectorizationEnabledCondName));
            if (!isVectorizationEnabled) {
                json.put("enabledConditionsNotMet", jsonArray);
            } else {
                json.put("enabledConditionsMet", jsonArray);
            }
        }
        return new ImmutablePair<Boolean, JSONObject>(isVectorizationEnabled, jsonOutput ? json : null);
    }

    public JSONObject getJSONPlan(PrintStream out, ExplainWork work) throws Exception {
        return this.getJSONPlan(out, work.getRootTasks(), work.getFetchTask(), work.isFormatted(), work.getExtended(), work.isAppendTaskType());
    }

    public JSONObject getJSONPlan(PrintStream out, List<Task<?>> tasks, Task<?> fetchTask, boolean jsonOutput, boolean isExtended, boolean appendTaskType) throws Exception {
        JSONObject outJSONObject = new JSONObject(new LinkedHashMap());
        if (jsonOutput) {
            out = null;
        }
        List<Task> ordered = StageIDsRearranger.getExplainOrder(this.conf, tasks);
        if (fetchTask != null) {
            fetchTask.setParentTasks(StageIDsRearranger.getFetchSources(tasks));
            if (fetchTask.getNumParent() == 0) {
                fetchTask.setRootTask(true);
            }
            ordered.add(fetchTask);
        }
        boolean suppressOthersForVectorization = false;
        if (this.work != null && ((ExplainWork)this.work).isVectorization()) {
            ImmutablePair<Boolean, JSONObject> planVecPair = this.outputPlanVectorization(out, jsonOutput);
            if (((ExplainWork)this.work).isVectorizationOnly()) {
                boolean bl = suppressOthersForVectorization = (Boolean)planVecPair.left == false;
            }
            if (out != null) {
                out.println();
            }
            if (jsonOutput) {
                outJSONObject.put("PLAN VECTORIZATION", planVecPair.right);
            }
        }
        if (!suppressOthersForVectorization) {
            JSONObject jsonDependencies = this.outputDependencies(out, jsonOutput, appendTaskType, ordered);
            if (out != null) {
                out.println();
            }
            if (jsonOutput) {
                outJSONObject.put("STAGE DEPENDENCIES", jsonDependencies);
            }
            JSONObject jsonPlan = this.outputStagePlans(out, ordered, jsonOutput, isExtended);
            if (jsonOutput) {
                outJSONObject.put("STAGE PLANS", jsonPlan);
            }
            if (fetchTask != null) {
                fetchTask.setParentTasks(null);
            }
        }
        return jsonOutput ? outJSONObject : null;
    }

    private List<String> toString(Collection<?> objects) {
        ArrayList<String> list = new ArrayList<String>();
        for (Object object : objects) {
            list.add(String.valueOf(object));
        }
        return list;
    }

    private Object toJson(String header, String message, PrintStream out, ExplainWork work) throws Exception {
        if (work.isFormatted()) {
            return message;
        }
        out.print(header);
        out.println(": ");
        out.print(ExplainTask.indentString(2));
        out.println(message);
        return null;
    }

    private Object toJson(String header, List<String> messages, PrintStream out, ExplainWork work) throws Exception {
        if (work.isFormatted()) {
            return new JSONArray(messages);
        }
        out.print(header);
        out.println(": ");
        for (String message : messages) {
            out.print(ExplainTask.indentString(2));
            out.print(message);
            out.println();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(DriverContext driverContext) {
        int n;
        PrintStream out = null;
        try {
            Path resFile = ((ExplainWork)this.work).getResFile();
            FSDataOutputStream outS = resFile.getFileSystem((Configuration)this.conf).create(resFile);
            out = new PrintStream((OutputStream)outS);
            if (((ExplainWork)this.work).isLogical()) {
                JSONObject jsonLogicalPlan = this.getJSONLogicalPlan(out, (ExplainWork)this.work);
                if (((ExplainWork)this.work).isFormatted()) {
                    out.print(jsonLogicalPlan);
                }
            } else if (((ExplainWork)this.work).isAuthorize()) {
                JSONObject jsonAuth = this.collectAuthRelatedEntities(out, (ExplainWork)this.work);
                if (((ExplainWork)this.work).isFormatted()) {
                    out.print(jsonAuth);
                }
            } else if (((ExplainWork)this.work).getDependency()) {
                JSONObject jsonDependencies = ExplainTask.getJSONDependencies((ExplainWork)this.work);
                out.print(jsonDependencies);
            } else if (((ExplainWork)this.work).isAst()) {
                if (((ExplainWork)this.work).getAstStringTree() != null) {
                    this.outputAST(((ExplainWork)this.work).getAstStringTree(), out, ((ExplainWork)this.work).isFormatted(), 0);
                }
            } else if (((ExplainWork)this.work).isUserLevelExplain()) {
                JsonParser jsonParser = JsonParserFactory.getParser(this.conf);
                ((ExplainWork)this.work).getConfig().setFormatted(true);
                JSONObject jsonPlan = this.getJSONPlan(out, (ExplainWork)this.work);
                if (((ExplainWork)this.work).getCboInfo() != null) {
                    jsonPlan.put("cboInfo", ((ExplainWork)this.work).getCboInfo());
                }
                try {
                    jsonParser.print(jsonPlan, out);
                }
                catch (Exception e) {
                    this.LOG.error("Running explain user level has problem: " + e.toString() + ". Falling back to normal explain");
                    ((ExplainWork)this.work).getConfig().setFormatted(false);
                    ((ExplainWork)this.work).getConfig().setUserLevelExplain(false);
                    jsonPlan = this.getJSONPlan(out, (ExplainWork)this.work);
                }
            } else {
                JSONObject jsonPlan = this.getJSONPlan(out, (ExplainWork)this.work);
                if (((ExplainWork)this.work).isFormatted()) {
                    out.print(jsonPlan);
                }
            }
            out.close();
            out = null;
            n = 0;
        }
        catch (Exception e) {
            int n2;
            try {
                this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
                n2 = 1;
            }
            catch (Throwable throwable) {
                IOUtils.closeStream(out);
                throw throwable;
            }
            IOUtils.closeStream((Closeable)out);
            return n2;
        }
        IOUtils.closeStream((Closeable)out);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject collectAuthRelatedEntities(PrintStream out, ExplainWork work) throws Exception {
        BaseSemanticAnalyzer analyzer = work.getAnalyzer();
        HiveOperation operation = this.queryState.getHiveOperation();
        JSONObject object = new JSONObject(new LinkedHashMap());
        Object jsonInput = this.toJson("INPUTS", this.toString(analyzer.getInputs()), out, work);
        if (work.isFormatted()) {
            object.put("INPUTS", jsonInput);
        }
        Object jsonOutput = this.toJson("OUTPUTS", this.toString(analyzer.getOutputs()), out, work);
        if (work.isFormatted()) {
            object.put("OUTPUTS", jsonOutput);
        }
        String userName = SessionState.get().getAuthenticator().getUserName();
        Object jsonUser = this.toJson("CURRENT_USER", userName, out, work);
        if (work.isFormatted()) {
            object.put("CURRENT_USER", jsonUser);
        }
        Object jsonOperation = this.toJson("OPERATION", operation.name(), out, work);
        if (work.isFormatted()) {
            object.put("OPERATION", jsonOperation);
        }
        if (analyzer.skipAuthorization()) {
            return object;
        }
        final ArrayList<String> exceptions = new ArrayList<String>();
        Object delegate = SessionState.get().getActiveAuthorizer();
        if (delegate != null) {
            Class<?> itface = SessionState.get().getAuthorizerInterface();
            Object authorizer = AuthorizationFactory.create(delegate, itface, new AuthorizationFactory.AuthorizationExceptionHandler(){

                @Override
                public void exception(Exception exception) {
                    exceptions.add(exception.getMessage());
                }
            });
            SessionState.get().setActiveAuthorizer(authorizer);
            try {
                Driver.doAuthorization(this.queryState.getHiveOperation(), analyzer, "");
            }
            finally {
                SessionState.get().setActiveAuthorizer(delegate);
            }
        }
        if (!exceptions.isEmpty()) {
            Object jsonFails = this.toJson("AUTHORIZATION_FAILURES", exceptions, out, work);
            if (work.isFormatted()) {
                object.put("AUTHORIZATION_FAILURES", jsonFails);
            }
        }
        return object;
    }

    private static String indentString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private JSONObject outputMap(Map<?, ?> mp, boolean hasHeader, PrintStream out, boolean extended, boolean jsonOutput, int indent) throws Exception {
        JSONObject json;
        TreeMap<Object, Object> tree = this.getBasictypeKeyedMap(mp);
        JSONObject jSONObject = json = jsonOutput ? new JSONObject(new LinkedHashMap()) : null;
        if (out != null && hasHeader && !mp.isEmpty()) {
            out.println();
        }
        for (Map.Entry<Object, Object> ent : tree.entrySet()) {
            if (out != null) {
                out.print(ExplainTask.indentString(indent));
                out.print(ent.getKey());
                out.print(" ");
            }
            if (this.isPrintable(ent.getValue())) {
                if (out != null) {
                    out.print(ent.getValue());
                    out.println();
                }
                if (!jsonOutput) continue;
                json.put(ent.getKey().toString(), ent.getValue().toString());
                continue;
            }
            if (ent.getValue() instanceof List) {
                JSONObject jsonDep;
                if (ent.getValue() != null && !((List)ent.getValue()).isEmpty() && ((List)ent.getValue()).get(0) != null && ((List)ent.getValue()).get(0) instanceof TezWork.Dependency) {
                    if (out != null) {
                        boolean isFirst = true;
                        for (Comparable<TezWork.Dependency> dep2 : (List)ent.getValue()) {
                            if (!isFirst) {
                                out.print(", ");
                            } else {
                                out.print("<- ");
                                isFirst = false;
                            }
                            out.print(((TezWork.Dependency)dep2).getName());
                            out.print(" (");
                            out.print(((TezWork.Dependency)dep2).getType());
                            out.print(")");
                        }
                        out.println();
                    }
                    if (!jsonOutput) continue;
                    for (Object dep : (List)ent.getValue()) {
                        jsonDep = new JSONObject(new LinkedHashMap());
                        jsonDep.put("parent", ((TezWork.Dependency)dep).getName());
                        jsonDep.put("type", ((TezWork.Dependency)dep).getType());
                        json.accumulate(ent.getKey().toString(), jsonDep);
                    }
                    continue;
                }
                if (ent.getValue() != null && !((List)ent.getValue()).isEmpty() && ((List)ent.getValue()).get(0) != null && ((List)ent.getValue()).get(0) instanceof SparkWork.Dependency) {
                    if (out != null) {
                        Object dep;
                        boolean isFirst = true;
                        dep = ((List)ent.getValue()).iterator();
                        while (dep.hasNext()) {
                            Comparable<TezWork.Dependency> dep2;
                            dep2 = (SparkWork.Dependency)dep.next();
                            if (!isFirst) {
                                out.print(", ");
                            } else {
                                out.print("<- ");
                                isFirst = false;
                            }
                            out.print(((SparkWork.Dependency)dep2).getName());
                            out.print(" (");
                            out.print(((SparkWork.Dependency)dep2).getShuffleType());
                            out.print(", ");
                            out.print(((SparkWork.Dependency)dep2).getNumPartitions());
                            out.print(")");
                        }
                        out.println();
                    }
                    if (!jsonOutput) continue;
                    for (Object dep : (List)ent.getValue()) {
                        jsonDep = new JSONObject(new LinkedHashMap());
                        jsonDep.put("parent", ((SparkWork.Dependency)dep).getName());
                        jsonDep.put("type", ((SparkWork.Dependency)dep).getShuffleType());
                        jsonDep.put("partitions", ((SparkWork.Dependency)dep).getNumPartitions());
                        json.accumulate(ent.getKey().toString(), jsonDep);
                    }
                    continue;
                }
                if (out != null) {
                    out.print(ent.getValue().toString());
                    out.println();
                }
                if (!jsonOutput) continue;
                json.put(ent.getKey().toString(), ent.getValue().toString());
                continue;
            }
            if (ent.getValue() instanceof Map) {
                String stringValue = this.getBasictypeKeyedMap((Map)ent.getValue()).toString();
                if (out != null) {
                    out.print(stringValue);
                    out.println();
                }
                if (!jsonOutput) continue;
                json.put(ent.getKey().toString(), stringValue);
                continue;
            }
            if (ent.getValue() != null) {
                if (out != null) {
                    out.println();
                }
                JSONObject jsonOut = this.outputPlan(ent.getValue(), out, extended, jsonOutput, jsonOutput ? 0 : indent + 2);
                if (!jsonOutput) continue;
                json.put(ent.getKey().toString(), jsonOut);
                continue;
            }
            if (out == null) continue;
            out.println();
        }
        return jsonOutput ? json : null;
    }

    private TreeMap<Object, Object> getBasictypeKeyedMap(Map<?, ?> mp) {
        TreeMap<Object, Object> ret = new TreeMap<Object, Object>();
        if (mp.size() > 0) {
            Object firstKey = mp.keySet().iterator().next();
            if (firstKey.getClass().isPrimitive() || firstKey instanceof String) {
                ret.putAll(mp);
                return ret;
            }
            for (Map.Entry<?, ?> entry : mp.entrySet()) {
                ret.put(entry.getKey().toString(), entry.getValue());
            }
        }
        return ret;
    }

    private JSONArray outputList(List<?> l, PrintStream out, boolean hasHeader, boolean extended, boolean jsonOutput, int indent) throws Exception {
        boolean first_el = true;
        boolean nl = false;
        JSONArray outputArray = new JSONArray();
        for (Object o : l) {
            if (this.isPrintable(o)) {
                String delim;
                String string = delim = first_el ? " " : ", ";
                if (out != null) {
                    out.print(delim);
                    out.print(o);
                }
                if (jsonOutput) {
                    outputArray.put(o);
                }
                nl = true;
            } else {
                if (first_el && out != null && hasHeader) {
                    out.println();
                }
                JSONObject jsonOut = this.outputPlan(o, out, extended, jsonOutput, jsonOutput ? 0 : (hasHeader ? indent + 2 : indent));
                if (jsonOutput) {
                    outputArray.put(jsonOut);
                }
            }
            first_el = false;
        }
        if (nl && out != null) {
            out.println();
        }
        return jsonOutput ? outputArray : null;
    }

    private boolean isPrintable(Object val) {
        if (val instanceof Boolean || val instanceof String || val instanceof Integer || val instanceof Long || val instanceof Byte || val instanceof Float || val instanceof Double || val instanceof Path) {
            return true;
        }
        return val != null && val.getClass().isPrimitive();
    }

    private JSONObject outputPlan(Object work, PrintStream out, boolean extended, boolean jsonOutput, int indent) throws Exception {
        return this.outputPlan(work, out, extended, jsonOutput, indent, "");
    }

    private JSONObject outputPlan(Object work, PrintStream out, boolean extended, boolean jsonOutput, int indent, String appendToHeader) throws Exception {
        JSONObject json;
        String keyJSONObject;
        Explain note;
        block59: {
            boolean invokeFlag;
            Explain xpl_note;
            block60: {
                Explain.Vectorization vectorization;
                block61: {
                    note = AnnotationUtils.getAnnotation(work.getClass(), Explain.class);
                    keyJSONObject = null;
                    if (!(note instanceof Explain)) break block59;
                    xpl_note = note;
                    invokeFlag = false;
                    invokeFlag = this.work != null && ((ExplainWork)this.work).isUserLevelExplain() ? Explain.Level.USER.in(xpl_note.explainLevels()) : (extended ? Explain.Level.EXTENDED.in(xpl_note.explainLevels()) : Explain.Level.DEFAULT.in(xpl_note.explainLevels()));
                    if (!invokeFlag) break block60;
                    vectorization = xpl_note.vectorization();
                    if (this.work == null || !((ExplainWork)this.work).isVectorization()) break block61;
                    boolean desireOnly = ((ExplainWork)this.work).isVectorizationOnly();
                    ExplainConfiguration.VectorizationDetailLevel desiredVecDetailLevel = ((ExplainWork)this.work).isVectorizationDetailLevel();
                    switch (vectorization) {
                        case NON_VECTORIZED: {
                            if (desireOnly) {
                                invokeFlag = false;
                                break;
                            }
                            break block60;
                        }
                        case SUMMARY: 
                        case OPERATOR: 
                        case EXPRESSION: 
                        case DETAIL: {
                            if (vectorization.rank < desiredVecDetailLevel.rank) {
                                invokeFlag = false;
                                break;
                            }
                            break block60;
                        }
                        case SUMMARY_PATH: 
                        case OPERATOR_PATH: {
                            if (desireOnly && vectorization.rank < desiredVecDetailLevel.rank) {
                                invokeFlag = false;
                                break;
                            }
                            break block60;
                        }
                        default: {
                            throw new RuntimeException("Unknown EXPLAIN vectorization " + (Object)((Object)vectorization));
                        }
                    }
                    break block60;
                }
                switch (vectorization) {
                    case SUMMARY: 
                    case OPERATOR: 
                    case EXPRESSION: 
                    case DETAIL: {
                        invokeFlag = false;
                        break;
                    }
                    case NON_VECTORIZED: {
                        break;
                    }
                    case SUMMARY_PATH: 
                    case OPERATOR_PATH: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown EXPLAIN vectorization " + (Object)((Object)vectorization));
                    }
                }
            }
            if (invokeFlag) {
                keyJSONObject = xpl_note.displayName();
                if (out != null) {
                    out.print(ExplainTask.indentString(indent));
                    if (appendToHeader != null && !appendToHeader.isEmpty()) {
                        out.println(xpl_note.displayName() + appendToHeader);
                    } else {
                        out.println(xpl_note.displayName());
                    }
                }
            }
        }
        JSONObject jSONObject = json = jsonOutput ? new JSONObject(new LinkedHashMap()) : null;
        if (work instanceof Operator) {
            Operator operator = (Operator)work;
            if (operator.getConf() != null) {
                String appender = this.isLogical ? " (" + operator.getOperatorId() + ")" : "";
                JSONObject jsonOut = this.outputPlan(operator.getConf(), out, extended, jsonOutput, jsonOutput ? 0 : indent, appender);
                if (this.work != null && (((ExplainWork)this.work).isUserLevelExplain() || ((ExplainWork)this.work).isFormatted()) && jsonOut != null && jsonOut.length() > 0) {
                    List<String> outputOperators;
                    ((JSONObject)jsonOut.get(JSONObject.getNames(jsonOut)[0])).put("OperatorId:", operator.getOperatorId());
                    if (!((ExplainWork)this.work).isUserLevelExplain() && ((ExplainWork)this.work).isFormatted() && (operator instanceof ReduceSinkOperator || operator instanceof VectorReduceSinkOperator || operator instanceof VectorReduceSinkCommonOperator) && (outputOperators = ((ReduceSinkDesc)operator.getConf()).getOutputOperators()) != null) {
                        ((JSONObject)jsonOut.get(JSONObject.getNames(jsonOut)[0])).put(OUTPUT_OPERATORS, Arrays.toString(outputOperators.toArray()));
                    }
                }
                if (jsonOutput) {
                    json = jsonOut;
                }
            }
            if (!this.visitedOps.contains(operator) || !this.isLogical) {
                this.visitedOps.add(operator);
                if (operator.getChildOperators() != null) {
                    int cindent = jsonOutput ? 0 : indent + 2;
                    for (Operator<OperatorDesc> op : operator.getChildOperators()) {
                        JSONObject jsonOut = this.outputPlan(op, out, extended, jsonOutput, cindent);
                        if (!jsonOutput) continue;
                        ((JSONObject)json.get(JSONObject.getNames(json)[0])).accumulate("children", jsonOut);
                    }
                }
            }
            if (jsonOutput) {
                return json;
            }
            return null;
        }
        Method[] methods = work.getClass().getMethods();
        Arrays.sort(methods, new MethodComparator());
        for (Method m : methods) {
            Object jsonOut;
            boolean invokeFlag;
            Explain xpl_note;
            int prop_indents;
            block62: {
                Explain.Vectorization vectorization;
                block63: {
                    prop_indents = jsonOutput ? 0 : indent + 2;
                    note = AnnotationUtils.getAnnotation(m, Explain.class);
                    if (!(note instanceof Explain)) continue;
                    xpl_note = note;
                    invokeFlag = false;
                    invokeFlag = this.work != null && ((ExplainWork)this.work).isUserLevelExplain() ? Explain.Level.USER.in(xpl_note.explainLevels()) : (extended ? Explain.Level.EXTENDED.in(xpl_note.explainLevels()) : Explain.Level.DEFAULT.in(xpl_note.explainLevels()));
                    if (!invokeFlag) break block62;
                    vectorization = xpl_note.vectorization();
                    if (this.work == null || !((ExplainWork)this.work).isVectorization()) break block63;
                    boolean desireOnly = ((ExplainWork)this.work).isVectorizationOnly();
                    ExplainConfiguration.VectorizationDetailLevel desiredVecDetailLevel = ((ExplainWork)this.work).isVectorizationDetailLevel();
                    switch (vectorization) {
                        case NON_VECTORIZED: {
                            if (desireOnly) {
                                invokeFlag = false;
                                break;
                            }
                            break block62;
                        }
                        case SUMMARY: 
                        case OPERATOR: 
                        case EXPRESSION: 
                        case DETAIL: {
                            if (vectorization.rank < desiredVecDetailLevel.rank) {
                                invokeFlag = false;
                                break;
                            }
                            break block62;
                        }
                        case SUMMARY_PATH: 
                        case OPERATOR_PATH: {
                            if (desireOnly && vectorization.rank < desiredVecDetailLevel.rank) {
                                invokeFlag = false;
                                break;
                            }
                            break block62;
                        }
                        default: {
                            throw new RuntimeException("Unknown EXPLAIN vectorization " + (Object)((Object)vectorization));
                        }
                    }
                    break block62;
                }
                switch (vectorization) {
                    case SUMMARY: 
                    case OPERATOR: 
                    case EXPRESSION: 
                    case DETAIL: {
                        invokeFlag = false;
                        break;
                    }
                    case NON_VECTORIZED: {
                        break;
                    }
                    case SUMMARY_PATH: 
                    case OPERATOR_PATH: {
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown EXPLAIN vectorization " + (Object)((Object)vectorization));
                    }
                }
            }
            if (!invokeFlag) continue;
            Object val = null;
            try {
                val = m.invoke(work, new Object[0]);
            }
            catch (InvocationTargetException ex) {
                val = null;
            }
            if (val == null) continue;
            String header = null;
            boolean skipHeader = xpl_note.skipHeader();
            boolean emptyHeader = false;
            if (!xpl_note.displayName().equals("")) {
                header = ExplainTask.indentString(prop_indents) + xpl_note.displayName() + ":";
            } else {
                emptyHeader = true;
                prop_indents = indent;
                header = ExplainTask.indentString(prop_indents);
            }
            if (this.isPrintable(val)) {
                if (out != null && this.shouldPrint(xpl_note, val)) {
                    if (!skipHeader) {
                        out.print(header);
                        out.print(" ");
                    }
                    out.println(val);
                }
                if (!jsonOutput || !this.shouldPrint(xpl_note, val)) continue;
                json.put(header, val.toString());
                continue;
            }
            int ind = 0;
            if (!jsonOutput) {
                ind = !skipHeader ? prop_indents + 2 : indent;
            }
            if (val instanceof Map) {
                Map mp = (Map)val;
                if (out != null && !skipHeader && mp != null && !mp.isEmpty()) {
                    out.print(header);
                }
                jsonOut = this.outputMap(mp, !skipHeader && !emptyHeader, out, extended, jsonOutput, ind);
                if (!jsonOutput || mp.isEmpty()) continue;
                json.put(header, jsonOut);
                continue;
            }
            if (val instanceof List || val instanceof Set) {
                List l;
                List list = l = val instanceof List ? (List)val : new ArrayList((Set)val);
                if (out != null && !skipHeader && l != null && !l.isEmpty()) {
                    out.print(header);
                }
                jsonOut = this.outputList(l, out, !skipHeader && !emptyHeader, extended, jsonOutput, ind);
                if (!jsonOutput || l.isEmpty()) continue;
                json.put(header, jsonOut);
                continue;
            }
            try {
                if (!skipHeader && out != null) {
                    out.println(header);
                }
                JSONObject jsonOut2 = this.outputPlan(val, out, extended, jsonOutput, ind);
                if (!jsonOutput || jsonOut2 == null || jsonOut2.length() == 0) continue;
                if (!skipHeader) {
                    json.put(header, jsonOut2);
                    continue;
                }
                for (String k : JSONObject.getNames(jsonOut2)) {
                    json.put(k, jsonOut2.get(k));
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (jsonOutput) {
            if (keyJSONObject != null) {
                JSONObject ret = new JSONObject(new LinkedHashMap());
                ret.put(keyJSONObject, json);
                return ret;
            }
            return json;
        }
        return null;
    }

    private boolean shouldPrint(Explain exp, Object val) {
        return !exp.displayOnlyOnTrue() || !(val instanceof Boolean & (Boolean)val == false);
    }

    private JSONObject outputPlan(Task<?> task, PrintStream out, JSONObject parentJSON, boolean extended, boolean jsonOutput, int indent) throws Exception {
        if (out != null) {
            out.print(ExplainTask.indentString(indent));
            out.print("Stage: ");
            out.print(task.getId());
            out.print("\n");
        }
        JSONObject jsonOutputPlan = this.outputPlan(task.getWork(), out, extended, jsonOutput, jsonOutput ? 0 : indent + 2);
        if (out != null) {
            out.println();
        }
        if (jsonOutput) {
            parentJSON.put(task.getId(), jsonOutputPlan);
        }
        return null;
    }

    private JSONObject outputDependencies(Task<?> task, PrintStream out, JSONObject parentJson, boolean jsonOutput, boolean taskType, int indent) throws Exception {
        Task<Serializable> currBackupTask;
        JSONObject json;
        boolean first = true;
        JSONObject jSONObject = json = jsonOutput ? new JSONObject(new LinkedHashMap()) : null;
        if (out != null) {
            out.print(ExplainTask.indentString(indent));
            out.print(task.getId());
        }
        if (task.getParentTasks() == null || task.getParentTasks().isEmpty()) {
            if (task.isRootTask()) {
                if (out != null) {
                    out.print(" is a root stage");
                }
                if (jsonOutput) {
                    json.put("ROOT STAGE", "TRUE");
                }
            }
        } else {
            StringBuilder s = new StringBuilder();
            first = true;
            for (Task<Serializable> parent : task.getParentTasks()) {
                if (!first) {
                    s.append(", ");
                }
                first = false;
                s.append(parent.getId());
            }
            if (out != null) {
                out.print(" depends on stages: ");
                out.print(s.toString());
            }
            if (jsonOutput) {
                json.put("DEPENDENT STAGES", s.toString());
            }
        }
        if ((currBackupTask = task.getBackupTask()) != null) {
            if (out != null) {
                out.print(" has a backup stage: ");
                out.print(currBackupTask.getId());
            }
            if (jsonOutput) {
                json.put("BACKUP STAGE", currBackupTask.getId());
            }
        }
        if (task instanceof ConditionalTask && ((ConditionalTask)task).getListTasks() != null) {
            StringBuilder s = new StringBuilder();
            first = true;
            for (Task<? extends Serializable> con : ((ConditionalTask)task).getListTasks()) {
                if (!first) {
                    s.append(", ");
                }
                first = false;
                s.append(con.getId());
            }
            if (out != null) {
                out.print(" , consists of ");
                out.print(s.toString());
            }
            if (jsonOutput) {
                json.put("CONDITIONAL CHILD TASKS", s.toString());
            }
        }
        if (taskType) {
            if (out != null) {
                out.print(" [");
                out.print(task.getType());
                out.print("]");
            }
            if (jsonOutput) {
                json.put("TASK TYPE", task.getType().name());
            }
        }
        if (out != null) {
            out.println();
        }
        return jsonOutput ? json : null;
    }

    public String outputAST(String treeString, PrintStream out, boolean jsonOutput, int indent) throws JSONException {
        if (out != null) {
            out.print(ExplainTask.indentString(indent));
            out.println("ABSTRACT SYNTAX TREE:");
            out.print(ExplainTask.indentString(indent + 2));
            out.println(treeString);
        }
        return jsonOutput ? treeString : null;
    }

    public JSONObject outputDependencies(PrintStream out, boolean jsonOutput, boolean appendTaskType, List<Task> tasks) throws Exception {
        if (out != null) {
            out.println("STAGE DEPENDENCIES:");
        }
        JSONObject json = jsonOutput ? new JSONObject(new LinkedHashMap()) : null;
        for (Task task : tasks) {
            JSONObject jsonOut = this.outputDependencies(task, out, json, jsonOutput, appendTaskType, 2);
            if (!jsonOutput || jsonOut == null) continue;
            json.put(task.getId(), jsonOut);
        }
        return jsonOutput ? json : null;
    }

    public JSONObject outputStagePlans(PrintStream out, List<Task> tasks, boolean jsonOutput, boolean isExtended) throws Exception {
        if (out != null) {
            out.println("STAGE PLANS:");
        }
        JSONObject json = jsonOutput ? new JSONObject(new LinkedHashMap()) : null;
        for (Task task : tasks) {
            this.outputPlan(task, out, json, isExtended, jsonOutput, 2);
        }
        return jsonOutput ? json : null;
    }

    @Override
    public StageType getType() {
        return StageType.EXPLAIN;
    }

    @Override
    public String getName() {
        return "EXPLAIN";
    }

    public List<FieldSchema> getResultSchema() {
        FieldSchema tmpFieldSchema = new FieldSchema();
        ArrayList<FieldSchema> colList = new ArrayList<FieldSchema>();
        tmpFieldSchema.setName(EXPL_COLUMN_NAME);
        tmpFieldSchema.setType("string");
        colList.add(tmpFieldSchema);
        return colList;
    }

    public class MethodComparator
    implements Comparator<Method> {
        @Override
        public int compare(Method m1, Method m2) {
            return m1.getName().compareTo(m2.getName());
        }
    }
}

