/*
 * Decompiled with CFR 0.152.
 */
package hive.org.apache.avro.mapred;

import hive.org.apache.avro.Schema;
import hive.org.apache.avro.file.CodecFactory;
import hive.org.apache.avro.file.DataFileWriter;
import hive.org.apache.avro.generic.GenericData;
import hive.org.apache.avro.hadoop.file.HadoopCodecFactory;
import hive.org.apache.avro.mapred.AvroJob;
import hive.org.apache.avro.mapred.AvroWrapper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.Progressable;

public class AvroOutputFormat<T>
extends FileOutputFormat<AvroWrapper<T>, NullWritable> {
    public static final String EXT = ".avro";
    public static final String DEFLATE_LEVEL_KEY = "avro.mapred.deflate.level";
    public static final String XZ_LEVEL_KEY = "avro.mapred.xz.level";
    public static final String SYNC_INTERVAL_KEY = "avro.mapred.sync.interval";

    public static void setDeflateLevel(JobConf job, int level) {
        FileOutputFormat.setCompressOutput((JobConf)job, (boolean)true);
        job.setInt(DEFLATE_LEVEL_KEY, level);
    }

    public static void setSyncInterval(JobConf job, int syncIntervalInBytes) {
        job.setInt(SYNC_INTERVAL_KEY, syncIntervalInBytes);
    }

    static <T> void configureDataFileWriter(DataFileWriter<T> writer, JobConf job) throws UnsupportedEncodingException {
        CodecFactory factory = AvroOutputFormat.getCodecFactory(job);
        if (factory != null) {
            writer.setCodec(factory);
        }
        writer.setSyncInterval(job.getInt(SYNC_INTERVAL_KEY, 64000));
        for (Map.Entry e : job) {
            if (((String)e.getKey()).startsWith("avro.meta.text.")) {
                writer.setMeta(((String)e.getKey()).substring("avro.meta.text.".length()), (String)e.getValue());
            }
            if (!((String)e.getKey()).startsWith("avro.meta.binary.")) continue;
            writer.setMeta(((String)e.getKey()).substring("avro.meta.binary.".length()), URLDecoder.decode((String)e.getValue(), StandardCharsets.ISO_8859_1.name()).getBytes(StandardCharsets.ISO_8859_1));
        }
    }

    static CodecFactory getCodecFactory(JobConf job) {
        CodecFactory factory = null;
        if (FileOutputFormat.getCompressOutput((JobConf)job)) {
            int deflateLevel = job.getInt(DEFLATE_LEVEL_KEY, -1);
            int xzLevel = job.getInt(XZ_LEVEL_KEY, 6);
            String codecName = job.get("avro.output.codec");
            if (codecName == null) {
                String codecClassName = job.get("mapred.output.compression.codec", null);
                String avroCodecName = HadoopCodecFactory.getAvroCodecName(codecClassName);
                if (codecClassName != null && avroCodecName != null) {
                    factory = HadoopCodecFactory.fromHadoopString(codecClassName);
                    job.set("avro.output.codec", avroCodecName);
                    return factory;
                }
                return CodecFactory.deflateCodec(deflateLevel);
            }
            factory = codecName.equals("deflate") ? CodecFactory.deflateCodec(deflateLevel) : (codecName.equals("xz") ? CodecFactory.xzCodec(xzLevel) : CodecFactory.fromString(codecName));
        }
        return factory;
    }

    public RecordWriter<AvroWrapper<T>, NullWritable> getRecordWriter(FileSystem ignore, JobConf job, String name, Progressable prog) throws IOException {
        boolean isMapOnly = job.getNumReduceTasks() == 0;
        Schema schema = isMapOnly ? AvroJob.getMapOutputSchema((Configuration)job) : AvroJob.getOutputSchema((Configuration)job);
        GenericData dataModel = AvroJob.createDataModel((Configuration)job);
        final DataFileWriter writer = new DataFileWriter(dataModel.createDatumWriter(null));
        AvroOutputFormat.configureDataFileWriter(writer, job);
        Path path = FileOutputFormat.getTaskOutputPath((JobConf)job, (String)(name + EXT));
        writer.create(schema, (OutputStream)path.getFileSystem((Configuration)job).create(path));
        return new RecordWriter<AvroWrapper<T>, NullWritable>(){

            public void write(AvroWrapper<T> wrapper, NullWritable ignore) throws IOException {
                writer.append(wrapper.datum());
            }

            public void close(Reporter reporter) throws IOException {
                writer.close();
            }
        };
    }
}

