/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.udfs;

import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.BeforeClass;
import org.junit.Test;

public class TestDistributionFunctions
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher);
        TestDistributionFunctions.startCluster((ClusterFixtureBuilder)builder);
    }

    @Test
    public void testWidthBucket() throws Exception {
        String query = "SELECT width_bucket(5.35, 0,10,5) AS bucket FROM (VALUES(1))";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"bucket"}).baselineValues(new Object[]{3}).go();
        query = "SELECT width_bucket(2, 0,10,5) AS bucket FROM (VALUES(1))";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"bucket"}).baselineValues(new Object[]{2}).go();
        query = "SELECT width_bucket('9', 0,10,5) AS bucket FROM (VALUES(1))";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"bucket"}).baselineValues(new Object[]{5}).go();
        query = "SELECT width_bucket(-5, 0,10,5) AS too_low_bucket, width_bucket(505, 0,10,5) AS too_high_bucket FROM (VALUES(1))";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"too_low_bucket", "too_high_bucket"}).baselineValues(new Object[]{0, 6}).go();
    }

    @Test
    public void testKendall() throws Exception {
        String query = "SELECT kendall_correlation(col1,col2) AS R FROM cp.`test_data.csvh`";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"R"}).baselineValues(new Object[]{0.16666666666666666}).go();
    }

    @Test
    public void testRegrSlope() throws Exception {
        String query = "SELECT regr_slope(spend,sales) AS slope FROM cp.`regr_test.csvh`";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"slope"}).baselineValues(new Object[]{10.619633290847284}).go();
    }

    @Test
    public void testRegrIntercept() throws Exception {
        String query = "SELECT regr_intercept(spend,sales) AS intercept FROM cp.`regr_test.csvh`";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"intercept"}).baselineValues(new Object[]{1400.2322223740048}).go();
    }
}

