/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.udfs;

import org.apache.drill.categories.SqlFunctionTest;
import org.apache.drill.categories.UnlikelyTest;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnlikelyTest.class, SqlFunctionTest.class})
public class TestCryptoFunctions
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher);
        TestCryptoFunctions.startCluster((ClusterFixtureBuilder)builder);
    }

    @Test
    public void testMD5() throws Exception {
        String query = "select md5('testing') as md5Hash from (values(1))";
        this.testBuilder().sqlQuery("select md5('testing') as md5Hash from (values(1))").ordered().baselineColumns(new String[]{"md5Hash"}).baselineValues(new Object[]{"ae2b1fca515949e5d54fb22b8ed95575"}).go();
    }

    @Test
    public void testMD2() throws Exception {
        String query = "select md2('testing') as md2Hash from (values(1))";
        this.testBuilder().sqlQuery("select md2('testing') as md2Hash from (values(1))").ordered().baselineColumns(new String[]{"md2Hash"}).baselineValues(new Object[]{"fc134df10d6ecafceb5c75861d01b41f"}).go();
    }

    @Test
    public void testSHA1() throws Exception {
        String query = "select sha('testing') as shaHash from (values(1))";
        this.testBuilder().sqlQuery("select sha('testing') as shaHash from (values(1))").ordered().baselineColumns(new String[]{"shaHash"}).baselineValues(new Object[]{"dc724af18fbdd4e59189f5fe768a5f8311527050"}).go();
    }

    @Test
    public void testSHA384() throws Exception {
        String query = "select sha384('testing') as shaHash from (values(1))";
        this.testBuilder().sqlQuery("select sha384('testing') as shaHash from (values(1))").ordered().baselineColumns(new String[]{"shaHash"}).baselineValues(new Object[]{"cf4811d74fd40504674fc3273f824fa42f755b9660a2e902b57f1df74873db1a91a037bcee65f1a88ecd1ef57ff254c9"}).go();
    }

    @Test
    public void testSHA512() throws Exception {
        String query = "select sha512('testing') as shaHash from (values(1))";
        this.testBuilder().sqlQuery("select sha512('testing') as shaHash from (values(1))").ordered().baselineColumns(new String[]{"shaHash"}).baselineValues(new Object[]{"521b9ccefbcd14d179e7a1bb877752870a6d620938b28a66a107eac6e6805b9d0989f45b5730508041aa5e710847d439ea74cd312c9355f1f2dae08d40e41d50"}).go();
    }

    @Test
    public void testAESEncrypt() throws Exception {
        this.testBuilder().sqlQuery("select aes_encrypt('testing', 'secret_key') as encrypted from (values(1))").ordered().baselineColumns(new String[]{"encrypted"}).baselineValues(new Object[]{"ICf+zdOrLitogB8HUDru0w=="}).go();
        this.testBuilder().sqlQuery("select aes_encrypt(cast(null as varchar), 'secret_key') as encrypted from (values(1))").ordered().baselineColumns(new String[]{"encrypted"}).baselineValues(new Object[]{null}).go();
        this.testBuilder().sqlQuery("select aes_encrypt('testing', cast (null as varchar)) as encrypted from (values(1))").ordered().baselineColumns(new String[]{"encrypted"}).baselineValues(new Object[]{null}).go();
    }

    @Test
    public void testAESDecrypt() throws Exception {
        this.testBuilder().sqlQuery("select aes_decrypt('ICf+zdOrLitogB8HUDru0w==', 'secret_key') as decrypt from (values(1))").ordered().baselineColumns(new String[]{"decrypt"}).baselineValues(new Object[]{"testing"}).go();
        this.testBuilder().sqlQuery("select aes_decrypt(cast(null as varchar), 'secret_key') as decrypt from (values(1))").ordered().baselineColumns(new String[]{"decrypt"}).baselineValues(new Object[]{null}).go();
        this.testBuilder().sqlQuery("select aes_decrypt('ICf+zdOrLitogB8HUDru0w==', cast(null as varchar)) as decrypt from (values(1))").ordered().baselineColumns(new String[]{"decrypt"}).baselineValues(new Object[]{null}).go();
    }
}

