/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.udfs;

import org.apache.drill.categories.SqlFunctionTest;
import org.apache.drill.categories.UnlikelyTest;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.rpc.RpcException;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnlikelyTest.class, SqlFunctionTest.class})
public class TestComplexSchemaFunctions
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher);
        TestComplexSchemaFunctions.startCluster((ClusterFixtureBuilder)builder);
    }

    @Test
    public void testMapSchemaFunction() throws RpcException {
        String sql = "SELECT getMapSchema(record) AS schema FROM cp.`json/nestedSchema.json`";
        QueryBuilder q = client.queryBuilder().sql(sql);
        DirectRowSet results = q.rowSet();
        Assert.assertEquals((long)results.rowCount(), (long)1L);
        TupleMetadata expectedSchema = new SchemaBuilder().addMap("schema").addNullable("int_field", TypeProtos.MinorType.VARCHAR).addNullable("double_field", TypeProtos.MinorType.VARCHAR).addNullable("string_field", TypeProtos.MinorType.VARCHAR).addNullable("boolean_field", TypeProtos.MinorType.VARCHAR).addNullable("int_list", TypeProtos.MinorType.VARCHAR).addNullable("double_list", TypeProtos.MinorType.VARCHAR).addNullable("boolean_list", TypeProtos.MinorType.VARCHAR).addNullable("map", TypeProtos.MinorType.VARCHAR).addNullable("repeated_map", TypeProtos.MinorType.VARCHAR).resumeSchema().build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.strArray((String[])new String[]{"BIGINT", "FLOAT8", "VARCHAR", "BIT", "REPEATED_BIGINT", "REPEATED_FLOAT8", "REPEATED_BIT", "MAP", "REPEATED_MAP"})}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testMapSchemaFunctionWithInnerMap() throws RpcException {
        String sql = "SELECT getMapSchema(t1.record.map) AS schema FROM cp.`json/nestedSchema.json` AS t1";
        QueryBuilder q = client.queryBuilder().sql(sql);
        DirectRowSet results = q.rowSet();
        Assert.assertEquals((long)results.rowCount(), (long)1L);
        TupleMetadata expectedSchema = new SchemaBuilder().addMap("schema").addNullable("nested_int_field", TypeProtos.MinorType.VARCHAR).addNullable("nested_double_field", TypeProtos.MinorType.VARCHAR).addNullable("nested_string_field", TypeProtos.MinorType.VARCHAR).resumeSchema().build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.strArray((String[])new String[]{"BIGINT", "FLOAT8", "VARCHAR"})}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }

    @Test
    public void testMapSchemaFunctionWithNull() throws RpcException {
        String sql = "SELECT getMapSchema(null) AS schema FROM cp.`json/nestedSchema.json` AS t1";
        QueryBuilder q = client.queryBuilder().sql(sql);
        DirectRowSet results = q.rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("schema", TypeProtos.MinorType.MAP).build();
        RowSet.SingleRowSet expected = client.rowSetBuilder(expectedSchema).addRow(new Object[]{RowSetUtilities.mapArray((Object[][])new Object[0][])}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)results);
    }
}

