/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.udfs;

import java.util.Collections;
import java.util.Map;
import org.apache.drill.categories.SqlFunctionTest;
import org.apache.drill.categories.UnlikelyTest;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={UnlikelyTest.class, SqlFunctionTest.class})
public class TestUserAgentFunctions
extends ClusterTest {
    @BeforeClass
    public static void setup() throws Exception {
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher);
        TestUserAgentFunctions.startCluster((ClusterFixtureBuilder)builder);
    }

    @Test
    public void testParseUserAgentString() throws Exception {
        String query = "SELECT t1.ua.DeviceClass AS DeviceClass,\nt1.ua.DeviceName AS DeviceName,\nt1.ua.DeviceBrand AS DeviceBrand,\nt1.ua.DeviceCpuBits AS DeviceCpuBits,\nt1.ua.OperatingSystemClass AS OperatingSystemClass,\nt1.ua.OperatingSystemName AS OperatingSystemName,\nt1.ua.OperatingSystemVersion AS OperatingSystemVersion,\nt1.ua.OperatingSystemVersionMajor AS OperatingSystemVersionMajor,\nt1.ua.OperatingSystemNameVersion AS OperatingSystemNameVersion,\nt1.ua.OperatingSystemNameVersionMajor AS OperatingSystemNameVersionMajor,\nt1.ua.LayoutEngineClass AS LayoutEngineClass,\nt1.ua.LayoutEngineName AS LayoutEngineName,\nt1.ua.LayoutEngineVersion AS LayoutEngineVersion,\nt1.ua.LayoutEngineVersionMajor AS LayoutEngineVersionMajor,\nt1.ua.LayoutEngineNameVersion AS LayoutEngineNameVersion,\nt1.ua.LayoutEngineBuild AS LayoutEngineBuild,\nt1.ua.AgentClass AS AgentClass,\nt1.ua.AgentName AS AgentName,\nt1.ua.AgentVersion AS AgentVersion,\nt1.ua.AgentVersionMajor AS AgentVersionMajor,\nt1.ua.AgentNameVersionMajor AS AgentNameVersionMajor,\nt1.ua.AgentLanguage AS AgentLanguage,\nt1.ua.AgentLanguageCode AS AgentLanguageCode,\nt1.ua.AgentSecurity AS AgentSecurity\nFROM (SELECT parse_user_agent('Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11') AS ua FROM (values(1))) AS t1";
        this.testBuilder().sqlQuery(query).unOrdered().baselineColumns(new String[]{"DeviceClass", "DeviceName", "DeviceBrand", "DeviceCpuBits", "OperatingSystemClass", "OperatingSystemName", "OperatingSystemVersion", "OperatingSystemVersionMajor", "OperatingSystemNameVersion", "OperatingSystemNameVersionMajor", "LayoutEngineClass", "LayoutEngineName", "LayoutEngineVersion", "LayoutEngineVersionMajor", "LayoutEngineNameVersion", "LayoutEngineBuild", "AgentClass", "AgentName", "AgentVersion", "AgentVersionMajor", "AgentNameVersionMajor", "AgentLanguage", "AgentLanguageCode", "AgentSecurity"}).baselineValues(new Object[]{"Desktop", "Desktop", "Unknown", "32", "Desktop", "Windows NT", "XP", "XP", "Windows XP", "Windows XP", "Browser", "Gecko", "1.8.1.11", "1", "Gecko 1.8.1.11", "20071127", "Browser", "Firefox", "2.0.0.11", "2", "Firefox 2", "English (United States)", "en-us", "Strong security"}).go();
    }

    @Test
    public void testGetHostName() throws Exception {
        String query = "SELECT parse_user_agent('Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11', 'AgentSecurity') AS agent FROM (values(1))";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"agent"}).baselineValues(new Object[]{"Strong security"}).go();
    }

    @Test
    public void testEmptyFieldName() throws Exception {
        String query = "SELECT parse_user_agent('Mozilla/5.0 (Windows; U; Windows NT 5.1; en-US; rv:1.8.1.11) Gecko/20071127 Firefox/2.0.0.11', '') AS agent FROM (values(1))";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"agent"}).baselineValues(new Object[]{"Unknown"}).go();
    }

    @Test
    public void testNullUserAgent() throws Exception {
        String query = "SELECT parse_user_agent(CAST(null as VARCHAR)) AS agent FROM (values(1))";
        Map emptyMap = Collections.emptyMap();
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"agent"}).baselineValues(new Object[]{emptyMap}).go();
    }

    @Test
    public void testEmptyUAStringAndFieldName() throws Exception {
        String query = "SELECT parse_user_agent('', '') AS agent FROM (values(1))";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"agent"}).baselineValues(new Object[]{"Unknown"}).go();
    }

    @Test
    public void testNullUAStringAndEmptyFieldName() throws Exception {
        String query = "SELECT parse_user_agent(CAST(null as VARCHAR), '') AS agent FROM (values(1))";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"agent"}).baselineValues(new Object[]{null}).go();
    }

    @Test
    public void testNullUAStringAndNullFieldName() throws Exception {
        String query = "SELECT parse_user_agent(CAST(null as VARCHAR), CAST(null as VARCHAR)) AS agent FROM (values(1))";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"agent"}).baselineValues(new Object[]{null}).go();
    }

    @Test
    public void testNullUAStringAndFieldName() throws Exception {
        String query = "SELECT parse_user_agent(CAST(null as VARCHAR), 'AgentSecurity') AS agent FROM (values(1))";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"agent"}).baselineValues(new Object[]{null}).go();
    }

    @Test
    public void testEmptyUAString() throws Exception {
        String query = "SELECT t1.ua.AgentName AS AgentName FROM (SELECT parse_user_agent('') AS ua FROM (values(1))) as t1";
        this.testBuilder().sqlQuery(query).ordered().baselineColumns(new String[]{"AgentName"}).baselineValues(new Object[]{"Hacker"}).go();
    }
}

