/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.drill.plugin;

import java.util.Properties;
import org.apache.drill.common.AutoCloseables;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.drill.plugin.DrillStoragePluginConfig;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClientFixture;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DrillPluginQueriesTest
extends ClusterTest {
    private static final String TABLE_NAME = "dfs.tmp.test_table";
    private static ClusterFixture drill;
    private static ClientFixture drillClient;

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        DrillPluginQueriesTest.initPlugin();
    }

    @AfterClass
    public static void shutdown() throws Exception {
        AutoCloseables.close((AutoCloseable[])new AutoCloseable[]{drill, drillClient});
    }

    private static void initPlugin() throws Exception {
        DrillPluginQueriesTest.startCluster((ClusterFixtureBuilder)ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher));
        drill = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher).build();
        DrillStoragePluginConfig config = new DrillStoragePluginConfig("jdbc:drill:drillbit=localhost:" + drill.drillbit().getUserPort(), new Properties(), null, null);
        config.setEnabled(Boolean.valueOf(true));
        cluster.defineStoragePlugin("drill", (StoragePluginConfig)config);
        cluster.defineStoragePlugin("drill2", (StoragePluginConfig)config);
        drillClient = drill.clientFixture();
        drillClient.queryBuilder().sql("create table %s as select * from cp.`tpch/nation.parquet`", new Object[]{TABLE_NAME}).run();
    }

    @Test
    public void testSerDe() throws Exception {
        String plan = this.queryBuilder().sql("select * from drill.%s", new Object[]{TABLE_NAME}).explainJson();
        long count = this.queryBuilder().physical(plan).run().recordCount();
        Assert.assertEquals((long)25L, (long)count);
    }

    @Test
    public void testShowDatabases() throws Exception {
        this.testBuilder().sqlQuery("show databases where SCHEMA_NAME='drill.dfs.tmp'").unOrdered().baselineColumns(new String[]{"SCHEMA_NAME"}).baselineValues(new Object[]{"drill.dfs.tmp"}).go();
    }

    @Test
    public void testShowTables() throws Exception {
        this.testBuilder().sqlQuery("show tables IN drill.INFORMATION_SCHEMA").unOrdered().baselineColumns(new String[]{"TABLE_SCHEMA", "TABLE_NAME"}).baselineValues(new Object[]{"drill.information_schema", "VIEWS"}).baselineValues(new Object[]{"drill.information_schema", "CATALOGS"}).baselineValues(new Object[]{"drill.information_schema", "COLUMNS"}).baselineValues(new Object[]{"drill.information_schema", "PARTITIONS"}).baselineValues(new Object[]{"drill.information_schema", "FILES"}).baselineValues(new Object[]{"drill.information_schema", "SCHEMATA"}).baselineValues(new Object[]{"drill.information_schema", "TABLES"}).go();
    }

    @Test
    public void testProjectPushDown() throws Exception {
        String query = "select n_nationkey, n_regionkey, n_name from drill.%s";
        this.queryBuilder().sql(query, new Object[]{TABLE_NAME}).planMatcher().include(new String[]{"query=\"SELECT `n_nationkey`, `n_regionkey`, `n_name`"}).exclude(new String[]{"\\*"}).match();
        DirectRowSet sets = this.queryBuilder().sql(query, new Object[]{TABLE_NAME}).rowSet();
        TupleMetadata schema = new SchemaBuilder().add("n_nationkey", TypeProtos.MinorType.INT).add("n_regionkey", TypeProtos.MinorType.INT).add("n_name", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{0, 0, "ALGERIA"}).addRow(new Object[]{1, 1, "ARGENTINA"}).addRow(new Object[]{2, 1, "BRAZIL"}).addRow(new Object[]{3, 1, "CANADA"}).addRow(new Object[]{4, 4, "EGYPT"}).addRow(new Object[]{5, 0, "ETHIOPIA"}).addRow(new Object[]{6, 3, "FRANCE"}).addRow(new Object[]{7, 3, "GERMANY"}).addRow(new Object[]{8, 2, "INDIA"}).addRow(new Object[]{9, 2, "INDONESIA"}).addRow(new Object[]{10, 4, "IRAN"}).addRow(new Object[]{11, 4, "IRAQ"}).addRow(new Object[]{12, 2, "JAPAN"}).addRow(new Object[]{13, 4, "JORDAN"}).addRow(new Object[]{14, 0, "KENYA"}).addRow(new Object[]{15, 0, "MOROCCO"}).addRow(new Object[]{16, 0, "MOZAMBIQUE"}).addRow(new Object[]{17, 1, "PERU"}).addRow(new Object[]{18, 2, "CHINA"}).addRow(new Object[]{19, 3, "ROMANIA"}).addRow(new Object[]{20, 4, "SAUDI ARABIA"}).addRow(new Object[]{21, 2, "VIETNAM"}).addRow(new Object[]{22, 3, "RUSSIA"}).addRow(new Object[]{23, 3, "UNITED KINGDOM"}).addRow(new Object[]{24, 1, "UNITED STATES"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testFilterPushDown() throws Exception {
        String query = "select n_name, n_nationkey from drill.%s where n_nationkey = 0";
        this.queryBuilder().sql(query, new Object[]{TABLE_NAME}).planMatcher().include(new String[]{"WHERE"}).exclude(new String[]{"Filter"}).match();
        this.testBuilder().unOrdered().sqlQuery(query, new Object[]{TABLE_NAME}).baselineColumns(new String[]{"n_name", "n_nationkey"}).baselineValues(new Object[]{"ALGERIA", 0}).go();
    }

    @Test
    public void testFilterPushDownWithJoin() throws Exception {
        String query = "select * from drill.%s e\njoin drill.%s s on e.n_nationkey = s.n_nationkey where e.n_name = 'BRAZIL'";
        this.queryBuilder().sql(query, new Object[]{TABLE_NAME, TABLE_NAME}).planMatcher().include(new String[]{"INNER JOIN"}).match();
        this.testBuilder().ordered().sqlQuery(query, new Object[]{TABLE_NAME, TABLE_NAME}).baselineColumns(new String[]{"n_nationkey", "n_name", "n_regionkey", "n_comment", "n_nationkey0", "n_name0", "n_regionkey0", "n_comment0"}).baselineValues(new Object[]{2, "BRAZIL", 1, "y alongside of the pending deposits. carefully special packages are about the ironic forges. slyly special ", 2, "BRAZIL", 1, "y alongside of the pending deposits. carefully special packages are about the ironic forges. slyly special "}).go();
    }

    @Test
    public void testJoinDifferentDrillPlugins() throws Exception {
        String query = "select * from drill.%s e\njoin drill2.cp.`tpch/nation.parquet` s on e.n_nationkey = s.n_nationkey where e.n_name = 'BRAZIL'";
        this.queryBuilder().sql(query, new Object[]{TABLE_NAME, TABLE_NAME}).planMatcher().include(new String[]{"HashJoin"}).exclude(new String[]{"INNER JOIN"}).match();
        this.testBuilder().unOrdered().sqlQuery(query, new Object[]{TABLE_NAME, TABLE_NAME}).baselineColumns(new String[]{"n_nationkey", "n_name", "n_regionkey", "n_comment", "n_nationkey0", "n_name0", "n_regionkey0", "n_comment0"}).baselineValues(new Object[]{2, "BRAZIL", 1, "y alongside of the pending deposits. carefully special packages are about the ironic forges. slyly special ", 2, "BRAZIL", 1, "y alongside of the pending deposits. carefully special packages are about the ironic forges. slyly special "}).go();
    }

    @Test
    public void testAggregationPushDown() throws Exception {
        String query = "select count(*) c from drill.%s";
        this.queryBuilder().sql(query, new Object[]{TABLE_NAME}).planMatcher().include(new String[]{"query=\"SELECT COUNT\\(\\*\\)"}).match();
        this.testBuilder().unOrdered().sqlQuery(query, new Object[]{TABLE_NAME}).baselineColumns(new String[]{"c"}).baselineValues(new Object[]{25L}).go();
    }

    @Test
    public void testLimitPushDown() throws Exception {
        String query = "select n_name from drill.%s FETCH NEXT 1 ROWS ONLY";
        this.queryBuilder().sql(query, new Object[]{TABLE_NAME}).planMatcher().include(new String[]{"FETCH NEXT 1 ROWS ONLY"}).match();
        this.testBuilder().unOrdered().sqlQuery(query, new Object[]{TABLE_NAME}).baselineColumns(new String[]{"n_name"}).baselineValues(new Object[]{"ALGERIA"}).go();
    }

    @Test
    public void testLimitWithSortPushDown() throws Exception {
        String query = "select n_nationkey from drill.%s order by n_name limit 3";
        this.queryBuilder().sql(query, new Object[]{TABLE_NAME}).planMatcher().include(new String[]{"ORDER BY `n_name`", "FETCH NEXT 3 ROWS ONLY"}).match();
        this.testBuilder().unOrdered().sqlQuery(query, new Object[]{TABLE_NAME}).baselineColumns(new String[]{"n_nationkey"}).baselineValues(new Object[]{0}).baselineValues(new Object[]{1}).baselineValues(new Object[]{2}).go();
    }

    @Test
    public void testAggregationWithGroupByPushDown() throws Exception {
        String query = "select sum(n_nationkey) s from drill.%s group by n_regionkey";
        this.queryBuilder().sql(query, new Object[]{TABLE_NAME}).planMatcher().include(new String[]{"query=\"SELECT SUM\\(`n_nationkey`\\)", "GROUP BY `n_regionkey`"}).match();
        this.testBuilder().unOrdered().sqlQuery(query, new Object[]{TABLE_NAME}).baselineColumns(new String[]{"s"}).baselineValues(new Object[]{47L}).baselineValues(new Object[]{50L}).baselineValues(new Object[]{58L}).baselineValues(new Object[]{68L}).baselineValues(new Object[]{77L}).go();
    }

    @Test
    public void testUnionAllPushDown() throws Exception {
        String query = "select col1, col2 from drill.%s union all select col1, col2 from drill.%s";
        this.queryBuilder().sql(query, new Object[]{TABLE_NAME, TABLE_NAME}).planMatcher().include(new String[]{"UNION ALL"}).match();
        long recordCount = this.queryBuilder().sql(query, new Object[]{TABLE_NAME, TABLE_NAME}).run().recordCount();
        Assert.assertEquals((long)50L, (long)recordCount);
    }
}

