/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.splunk;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.common.logical.security.CredentialsProvider;
import org.apache.drill.common.logical.security.PlainCredentialsProvider;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.splunk.SplunkConnectionTest;
import org.apache.drill.exec.store.splunk.SplunkIndexesTest;
import org.apache.drill.exec.store.splunk.SplunkLimitPushDownTest;
import org.apache.drill.exec.store.splunk.SplunkPluginConfig;
import org.apache.drill.exec.store.splunk.SplunkPluginTest;
import org.apache.drill.exec.store.splunk.SplunkQueryBuilderTest;
import org.apache.drill.exec.store.splunk.SplunkTestSplunkUtils;
import org.apache.drill.exec.store.splunk.SplunkWriterTest;
import org.apache.drill.exec.store.splunk.TestSplunkUserTranslation;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.utility.DockerImageName;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={SplunkConnectionTest.class, SplunkQueryBuilderTest.class, SplunkLimitPushDownTest.class, SplunkIndexesTest.class, SplunkPluginTest.class, SplunkTestSplunkUtils.class, TestSplunkUserTranslation.class, SplunkWriterTest.class})
@Category(value={SlowTest.class})
public class SplunkTestSuite
extends ClusterTest {
    private static final Logger logger = LoggerFactory.getLogger(SplunkTestSuite.class);
    protected static SplunkPluginConfig SPLUNK_STORAGE_PLUGIN_CONFIG = null;
    protected static SplunkPluginConfig SPLUNK_STORAGE_PLUGIN_CONFIG_WITH_USER_TRANSLATION = null;
    public static final String SPLUNK_LOGIN = "admin";
    public static final String SPLUNK_PASS = "password";
    private static volatile boolean runningSuite = true;
    private static AtomicInteger initCount = new AtomicInteger(0);
    @ClassRule
    public static GenericContainer<?> splunk = new GenericContainer(DockerImageName.parse((String)"splunk/splunk:9.0.2")).withExposedPorts(new Integer[]{8089, 8089}).withEnv("SPLUNK_START_ARGS", "--accept-license").withEnv("SPLUNK_PASSWORD", "password").withEnv("SPLUNKD_SSL_ENABLE", "false");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void initSplunk() throws Exception {
        Class<SplunkTestSuite> clazz = SplunkTestSuite.class;
        synchronized (SplunkTestSuite.class) {
            if (initCount.get() == 0) {
                ClusterFixtureBuilder builder = new ClusterFixtureBuilder(dirTestWatcher).configProperty("drill.exec.http.enabled", (Object)true).configProperty("drill.exec.http.porthunt", (Object)true).configProperty("drill.exec.impersonation.enabled", (Object)true);
                SplunkTestSuite.startCluster((ClusterFixtureBuilder)builder);
                splunk.start();
                String hostname = splunk.getHost();
                Integer port = splunk.getFirstMappedPort();
                StoragePluginRegistry pluginRegistry = cluster.drillbit().getContext().getStorage();
                SPLUNK_STORAGE_PLUGIN_CONFIG = new SplunkPluginConfig(SPLUNK_LOGIN, SPLUNK_PASS, "http", hostname, port, null, null, null, null, false, "1", "now", null, Integer.valueOf(4), StoragePluginConfig.AuthMode.SHARED_USER.name(), true, null);
                SPLUNK_STORAGE_PLUGIN_CONFIG.setEnabled(Boolean.valueOf(true));
                pluginRegistry.put("splunk", (StoragePluginConfig)SPLUNK_STORAGE_PLUGIN_CONFIG);
                runningSuite = true;
                logger.info("Take a time to ready more Splunk events (10 sec)...");
                Thread.sleep(10000L);
                PlainCredentialsProvider credentialsProvider = new PlainCredentialsProvider(new HashMap());
                credentialsProvider.setUserCredentials(SPLUNK_LOGIN, SPLUNK_PASS, "testUser1");
                credentialsProvider.setUserCredentials("nope", "no way dude", "testUser2");
                SPLUNK_STORAGE_PLUGIN_CONFIG_WITH_USER_TRANSLATION = new SplunkPluginConfig(null, null, "http", hostname, port, null, null, null, null, false, "1", "now", (CredentialsProvider)credentialsProvider, Integer.valueOf(4), StoragePluginConfig.AuthMode.USER_TRANSLATION.name(), true, null);
                SPLUNK_STORAGE_PLUGIN_CONFIG_WITH_USER_TRANSLATION.setEnabled(Boolean.valueOf(true));
                pluginRegistry.put("ut_splunk", (StoragePluginConfig)SPLUNK_STORAGE_PLUGIN_CONFIG_WITH_USER_TRANSLATION);
            }
            initCount.incrementAndGet();
            runningSuite = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            logger.info("Initialized Splunk in Docker container");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownCluster() {
        Class<SplunkTestSuite> clazz = SplunkTestSuite.class;
        synchronized (SplunkTestSuite.class) {
            if (initCount.decrementAndGet() == 0) {
                splunk.close();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isRunningSuite() {
        return runningSuite;
    }
}

