/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.splunk;

import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.splunk.SplunkBaseTest;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class})
public class SplunkLimitPushDownTest
extends SplunkBaseTest {
    @Test
    public void testLimit() throws Exception {
        String sql = "SELECT * FROM splunk._audit LIMIT 5";
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Limit", "maxRecords=5"}).match();
    }

    @Test
    public void testLimitWithOrderBy() throws Exception {
        String sql = "SELECT * FROM splunk._audit ORDER BY ip LIMIT 4";
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Limit", "maxRecords=-1"}).match();
    }

    @Test
    public void testLimitWithOffset() throws Exception {
        String sql = "SELECT * FROM splunk._audit LIMIT 4 OFFSET 5";
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Limit", "maxRecords=9"}).match();
    }

    @Test
    public void testLimitWithFilter() throws Exception {
        String sql = "SELECT * FROM splunk._audit WHERE rating = 52.17 LIMIT 4";
        this.queryBuilder().sql(sql).planMatcher().include(new String[]{"Limit", "maxRecords=4"}).match();
    }
}

