/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.splunk;

import org.apache.drill.categories.SlowTest;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.store.splunk.SplunkBaseTest;
import org.apache.drill.test.ClientFixture;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.jupiter.api.Assertions;

@Category(value={SlowTest.class})
public class TestSplunkUserTranslation
extends SplunkBaseTest {
    @Test
    public void testInfoSchemaQueryWithMissingCredentials() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"admin").property("password", (Object)"adminUserPw").build();
        String sql = "SHOW DATABASES WHERE schema_name LIKE '%splunk%'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)1L, (long)results.rowCount());
        results.clear();
    }

    @Test
    public void testInfoSchemaQueryWithValidCredentials() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser1").property("password", (Object)"testUser1Password").build();
        String sql = "SHOW DATABASES WHERE schema_name LIKE '%splunk'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)2L, (long)results.rowCount());
        results.clear();
    }

    @Test
    public void testSplunkQueryWithUserTranslation() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"testUser1").property("password", (Object)"testUser1Password").build();
        String sql = "SELECT acceleration_id, action, add_offset, add_timestamp FROM ut_splunk._audit LIMIT 1";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)1L, (long)results.rowCount());
        results.clear();
    }

    @Test
    public void testSplunkQueryWithUserTranslationAndInvalidCredentials() throws Exception {
        ClientFixture client = cluster.clientBuilder().property("user", (Object)"admin").property("password", (Object)"adminUserPw").build();
        String sql = "SELECT acceleration_id, action, add_offset, add_timestamp FROM ut_splunk._audit LIMIT 2";
        try {
            client.queryBuilder().sql(sql).rowSet();
            Assertions.fail();
        }
        catch (UserRemoteException e) {
            MatcherAssert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"Object 'ut_splunk' not found"));
        }
    }
}

