/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.splunk;

import com.splunk.EntityCollection;
import com.splunk.Index;
import java.util.ArrayList;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.splunk.SplunkBaseTest;
import org.apache.drill.exec.store.splunk.SplunkConnection;
import org.apache.drill.exec.store.splunk.SplunkPluginConfig;
import org.apache.drill.exec.store.splunk.SplunkTestSuite;
import org.junit.Assert;
import org.junit.Test;

public class SplunkConnectionTest
extends SplunkBaseTest {
    @Test
    public void testConnection() {
        SplunkConnection sc = new SplunkConnection(SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG, null);
        sc.connect();
    }

    @Test
    public void testConnectionFail() {
        try {
            SplunkPluginConfig invalidSplunkConfig = new SplunkPluginConfig("hacker", "hacker", SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG.getScheme(), SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG.getHostname(), Integer.valueOf(SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG.getPort()), SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG.getApp(), SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG.getOwner(), SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG.getToken(), SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG.getCookie(), SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG.getValidateCertificates(), SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG.getEarliestTime(), SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG.getLatestTime(), null, Integer.valueOf(SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG.getReconnectRetries()), StoragePluginConfig.AuthMode.SHARED_USER.name(), true, null);
            SplunkConnection sc = new SplunkConnection(invalidSplunkConfig, null);
            sc.connect();
            Assert.fail();
        }
        catch (UserException e) {
            Assert.assertTrue((boolean)e.getMessage().contains("CONNECTION ERROR: Unable to connect to Splunk"));
        }
    }

    @Test
    public void testGetIndexes() {
        SplunkConnection sc = new SplunkConnection(SplunkTestSuite.SPLUNK_STORAGE_PLUGIN_CONFIG, null);
        EntityCollection indexes = sc.getIndexes();
        Assert.assertEquals((long)10L, (long)indexes.size());
        ArrayList<String> expectedIndexNames = new ArrayList<String>();
        expectedIndexNames.add("_audit");
        expectedIndexNames.add("_configtracker");
        expectedIndexNames.add("_internal");
        expectedIndexNames.add("_introspection");
        expectedIndexNames.add("_telemetry");
        expectedIndexNames.add("_thefishbucket");
        expectedIndexNames.add("history");
        expectedIndexNames.add("main");
        expectedIndexNames.add("splunklogger");
        expectedIndexNames.add("summary");
        ArrayList<String> indexNames = new ArrayList<String>();
        for (Index index : indexes.values()) {
            indexNames.add(index.getName());
        }
        Assert.assertEquals(indexNames, expectedIndexNames);
    }
}

