/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.splunk;

import java.util.HashMap;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.store.base.filter.ConstantHolder;
import org.apache.drill.exec.store.base.filter.ExprNode;
import org.apache.drill.exec.store.base.filter.RelOp;
import org.apache.drill.exec.store.splunk.SplunkQueryBuilder;
import org.junit.Assert;
import org.junit.Test;

public class SplunkQueryBuilderTest {
    @Test
    public void testSimpleQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main | table *", (Object)query);
    }

    @Test
    public void testAddSingleFieldQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        builder.addField("field1");
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main | fields field1 | table field1", (Object)query);
    }

    @Test
    public void testAddMultipleFieldQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        builder.addField("field1");
        builder.addField("field2");
        builder.addField("field3");
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main | fields field1,field2,field3 | table field1,field2,field3", (Object)query);
    }

    @Test
    public void testFieldsAndFiltersQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        HashMap<String, ExprNode.ColRelOpConstNode> filters = new HashMap<String, ExprNode.ColRelOpConstNode>();
        filters.put("field1", new ExprNode.ColRelOpConstNode("field1", RelOp.EQ, new ConstantHolder(TypeProtos.MinorType.VARCHAR, (Object)"foo")));
        builder.addField("field1");
        builder.addField("field2");
        builder.addField("field3");
        builder.addFilters(filters);
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main field1=\"foo\" | fields field1,field2,field3 | table field1,field2,field3", (Object)query);
    }

    @Test
    public void testFieldsAndSourcetypeQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        HashMap<String, ExprNode.ColRelOpConstNode> filters = new HashMap<String, ExprNode.ColRelOpConstNode>();
        filters.put("field1", new ExprNode.ColRelOpConstNode("field1", RelOp.EQ, new ConstantHolder(TypeProtos.MinorType.VARCHAR, (Object)"foo")));
        filters.put("sourcetype", new ExprNode.ColRelOpConstNode("sourcetype", RelOp.EQ, new ConstantHolder(TypeProtos.MinorType.VARCHAR, (Object)"st")));
        builder.addField("field1");
        builder.addField("field2");
        builder.addField("field3");
        builder.addFilters(filters);
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main sourcetype=\"st\" field1=\"foo\" | fields field1,field2,field3 | table field1,field2,field3", (Object)query);
    }

    @Test
    public void testGTQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        HashMap<String, ExprNode.ColRelOpConstNode> filters = new HashMap<String, ExprNode.ColRelOpConstNode>();
        filters.put("field1", new ExprNode.ColRelOpConstNode("field1", RelOp.GT, new ConstantHolder(TypeProtos.MinorType.INT, (Object)5)));
        builder.addField("field1");
        builder.addFilters(filters);
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main field1>5 | fields field1 | table field1", (Object)query);
    }

    @Test
    public void testGEQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        HashMap<String, ExprNode.ColRelOpConstNode> filters = new HashMap<String, ExprNode.ColRelOpConstNode>();
        filters.put("field1", new ExprNode.ColRelOpConstNode("field1", RelOp.GE, new ConstantHolder(TypeProtos.MinorType.INT, (Object)5)));
        builder.addField("field1");
        builder.addFilters(filters);
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main field1>=5 | fields field1 | table field1", (Object)query);
    }

    @Test
    public void testLEQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        HashMap<String, ExprNode.ColRelOpConstNode> filters = new HashMap<String, ExprNode.ColRelOpConstNode>();
        filters.put("field1", new ExprNode.ColRelOpConstNode("field1", RelOp.LE, new ConstantHolder(TypeProtos.MinorType.INT, (Object)5)));
        builder.addField("field1");
        builder.addFilters(filters);
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main field1<=5 | fields field1 | table field1", (Object)query);
    }

    @Test
    public void testLTQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        HashMap<String, ExprNode.ColRelOpConstNode> filters = new HashMap<String, ExprNode.ColRelOpConstNode>();
        filters.put("field1", new ExprNode.ColRelOpConstNode("field1", RelOp.LT, new ConstantHolder(TypeProtos.MinorType.INT, (Object)5)));
        builder.addField("field1");
        builder.addFilters(filters);
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main field1<5 | fields field1 | table field1", (Object)query);
    }

    @Test
    public void testStarAndSourcetypeQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        HashMap<String, ExprNode.ColRelOpConstNode> filters = new HashMap<String, ExprNode.ColRelOpConstNode>();
        filters.put("field1", new ExprNode.ColRelOpConstNode("field1", RelOp.EQ, new ConstantHolder(TypeProtos.MinorType.VARCHAR, (Object)"foo")));
        filters.put("sourcetype", new ExprNode.ColRelOpConstNode("sourcetype", RelOp.EQ, new ConstantHolder(TypeProtos.MinorType.VARCHAR, (Object)"st")));
        builder.addField("field1");
        builder.addField("field2");
        builder.addField("field3");
        builder.addFilters(filters);
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main sourcetype=\"st\" field1=\"foo\" | fields field1,field2,field3 | table field1,field2,field3", (Object)query);
    }

    @Test
    public void testLimitQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        builder.addLimit(5);
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main | head 5 | table *", (Object)query);
    }

    @Test
    public void testAddSingleSourcetypeQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        builder.addSourceType("access_combined_wcookie");
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main sourcetype=\"access_combined_wcookie\" | table *", (Object)query);
    }

    @Test
    public void testSingleFilterQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        builder.addFilter("field1", "value1", "=");
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main field1=\"value1\" | table *", (Object)query);
    }

    @Test
    public void testMultipleFilterQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        builder.addFilter("field1", "value1", "=");
        builder.addFilter("field2", "value2", "=");
        builder.addFilter("field3", "value3", "=");
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main field1=\"value1\" field2=\"value2\" field3=\"value3\" | table *", (Object)query);
    }

    @Test
    public void testAddMultipleSourcetypeQuery() {
        SplunkQueryBuilder builder = new SplunkQueryBuilder("main");
        builder.addSourceType("access_combined_wcookie");
        builder.addSourceType("sourcetype2");
        builder.addSourceType("sourcetype3");
        String query = builder.build();
        Assert.assertEquals((Object)"search index=main (sourcetype=\"access_combined_wcookie\" OR sourcetype=\"sourcetype2\" OR sourcetype=\"sourcetype3\") | table *", (Object)query);
    }
}

