/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.splunk;

import org.apache.drill.categories.SlowTest;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.splunk.SplunkBaseTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
@Category(value={SlowTest.class})
public class SplunkWriterTest
extends SplunkBaseTest {
    @Test
    public void testBasicCTAS() throws Exception {
        String sql = "SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_SCHEMA = 'splunk' AND TABLE_NAME LIKE 't1'";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)0L, (long)results.rowCount());
        results.clear();
        sql = "CREATE TABLE `splunk`.`t1` AS SELECT * FROM cp.`test_data.csvh`";
        QueryBuilder.QuerySummary summary = client.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)summary.succeeded());
        sql = "SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_SCHEMA = 'splunk' AND TABLE_NAME LIKE 't1'";
        results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)1L, (long)results.rowCount());
        results.clear();
        Thread.sleep(30000L);
        sql = "SELECT clientip, categoryId FROM splunk.`t1`";
        results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("clientip", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("categoryId", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"198.35.2.120", "ACCESSORIES"}).addRow(new Object[]{"198.35.2.120", null}).addRow(new Object[]{"198.35.2.120", null}).addRow(new Object[]{"198.35.2.120", "STRATEGY"}).addRow(new Object[]{"198.35.2.120", "NULL"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        sql = "DROP TABLE splunk.`t1`";
        summary = client.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)summary.succeeded());
        sql = "SELECT * FROM INFORMATION_SCHEMA.`TABLES` WHERE TABLE_SCHEMA = 'splunk' AND TABLE_NAME LIKE 't1'";
        results = client.queryBuilder().sql(sql).rowSet();
        Assert.assertEquals((long)0L, (long)results.rowCount());
        results.clear();
    }

    @Test
    @Ignore(value="Run manually because of an unpredictable delay before newly inserted data gets indexed.")
    public void testBasicCTASWithScalarDataTypes() throws Exception {
        String query = "CREATE TABLE splunk.t2 AS SELECT CAST(1 AS INTEGER) AS int_field,CAST(2 AS BIGINT) AS bigint_field,CAST(3.0 AS FLOAT) AS float4_field,CAST(4.0 AS DOUBLE) AS float8_field,'5.0' AS varchar_field,CAST('2021-01-01' AS DATE) as date_field,CAST('12:00:00' AS TIME) as time_field, CAST('2015-12-30 22:55:55.23' AS TIMESTAMP) as timestamp_field, true AS boolean_field FROM (VALUES(1))";
        QueryBuilder.QuerySummary insertResults = this.queryBuilder().sql(query).run();
        Assert.assertTrue((boolean)insertResults.succeeded());
        Thread.sleep(15000L);
        String testQuery = "SELECT int_field, bigint_field, float4_field, float8_field, varchar_field,date_field, time_field, timestamp_field, boolean_field FROM splunk.t2";
        DirectRowSet results = this.queryBuilder().sql(testQuery).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().addNullable("int_field", TypeProtos.MinorType.VARCHAR).addNullable("bigint_field", TypeProtos.MinorType.VARCHAR).addNullable("float4_field", TypeProtos.MinorType.VARCHAR).addNullable("float8_field", TypeProtos.MinorType.VARCHAR).addNullable("varchar_field", TypeProtos.MinorType.VARCHAR).addNullable("date_field", TypeProtos.MinorType.VARCHAR).addNullable("time_field", TypeProtos.MinorType.VARCHAR).addNullable("timestamp_field", TypeProtos.MinorType.VARCHAR).addNullable("boolean_field", TypeProtos.MinorType.VARCHAR).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"1", "2", "3.0", "4.0", "5.0", "2021-01-01", "12:00", "2015-12-30T22:55:55.230", "true"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
        String dropQuery = "DROP TABLE splunk.t2";
        QueryBuilder.QuerySummary dropResults = this.queryBuilder().sql(dropQuery).run();
        Assert.assertTrue((boolean)dropResults.succeeded());
    }

    @Test
    public void testInsert() throws Exception {
        String sql = "CREATE TABLE `splunk`.`t3` AS SELECT * FROM cp.`test_data.csvh`";
        QueryBuilder.QuerySummary summary = client.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)summary.succeeded());
        Thread.sleep(30000L);
        sql = "INSERT INTO `splunk`.`t3`  SELECT * FROM cp.`test_data2.csvh`";
        summary = client.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)summary.succeeded());
        Thread.sleep(30000L);
        sql = "SELECT COUNT(*) as row_count FROM splunk.`t3`";
        long resultCount = client.queryBuilder().sql(sql).singletonLong();
        Assert.assertEquals((long)15L, (long)resultCount);
        sql = "DROP TABLE splunk.`t3`";
        summary = client.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)summary.succeeded());
    }

    @Test
    public void testComplexFields() throws Exception {
        String sql = "CREATE TABLE `splunk`.`t4` AS SELECT record FROM cp.`schema_test.json`";
        QueryBuilder.QuerySummary summary = client.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)summary.succeeded());
        Thread.sleep(30000L);
        sql = "SELECT COUNT(*) FROM splunk.t4";
        long resultCount = client.queryBuilder().sql(sql).singletonLong();
        Assert.assertEquals((long)1L, (long)resultCount);
        sql = "DROP TABLE splunk.`t4`";
        summary = client.queryBuilder().sql(sql).run();
        Assert.assertTrue((boolean)summary.succeeded());
    }
}

