/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.splunk;

import org.apache.drill.categories.SlowTest;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.splunk.SplunkBaseTest;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class})
public class SplunkIndexesTest
extends SplunkBaseTest {
    @Test
    public void testGetSplunkIndexes() throws Exception {
        String sql = "SHOW TABLES IN `splunk`";
        DirectRowSet results = client.queryBuilder().sql(sql).rowSet();
        TupleMetadata expectedSchema = new SchemaBuilder().add("TABLE_SCHEMA", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).add("TABLE_NAME", TypeProtos.MinorType.VARCHAR, TypeProtos.DataMode.OPTIONAL).buildSchema();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), expectedSchema).addRow(new Object[]{"splunk", "summary"}).addRow(new Object[]{"splunk", "splunklogger"}).addRow(new Object[]{"splunk", "_configtracker"}).addRow(new Object[]{"splunk", "_thefishbucket"}).addRow(new Object[]{"splunk", "_audit"}).addRow(new Object[]{"splunk", "_internal"}).addRow(new Object[]{"splunk", "_introspection"}).addRow(new Object[]{"splunk", "main"}).addRow(new Object[]{"splunk", "history"}).addRow(new Object[]{"splunk", "spl"}).addRow(new Object[]{"splunk", "_telemetry"}).build();
        RowSetUtilities.verify((RowSet)expected, (RowSet)results);
    }
}

