/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix.secured;

import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.categories.RowSetTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.exec.store.phoenix.PhoenixBasicsIT;
import org.apache.drill.exec.store.phoenix.secured.ImpersonationPhoenixIT;
import org.apache.drill.exec.store.phoenix.secured.SecuredPhoenixCommandTest;
import org.apache.drill.exec.store.phoenix.secured.SecuredPhoenixDataTypeTest;
import org.apache.drill.exec.store.phoenix.secured.SecuredPhoenixSQLTest;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Suite.class)
@Suite.SuiteClasses(value={SecuredPhoenixDataTypeTest.class, SecuredPhoenixSQLTest.class, SecuredPhoenixCommandTest.class})
@Category(value={SlowTest.class, RowSetTest.class})
public class SecuredPhoenixTestSuite {
    private static final Logger logger = LoggerFactory.getLogger(SecuredPhoenixTestSuite.class);
    private static volatile boolean runningSuite = false;
    private static final AtomicInteger initCount = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeClass
    public static void initPhoenix() throws Exception {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Class<SecuredPhoenixTestSuite> clazz = SecuredPhoenixTestSuite.class;
        synchronized (SecuredPhoenixTestSuite.class) {
            if (initCount.get() == 0) {
                logger.info("Boot the test cluster...");
                ImpersonationPhoenixIT.startPhoenixEnvironment();
            }
            initCount.incrementAndGet();
            runningSuite = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void tearDownCluster() throws Exception {
        Class<SecuredPhoenixTestSuite> clazz = SecuredPhoenixTestSuite.class;
        synchronized (SecuredPhoenixTestSuite.class) {
            if (initCount.decrementAndGet() == 0) {
                logger.info("Shutdown all instances of test cluster.");
                PhoenixBasicsIT.afterClass();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isRunningSuite() {
        return runningSuite;
    }
}

