/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix.secured;

import org.apache.drill.categories.RowSetTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.phoenix.secured.SecuredPhoenixBaseTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SlowTest.class, RowSetTest.class})
public class SecuredPhoenixCommandTest
extends SecuredPhoenixBaseTest {
    @Test
    public void testShowTablesLike() throws Exception {
        this.runForThreeClients(this::doTestShowTablesLike);
    }

    private void doTestShowTablesLike() throws Exception {
        this.runAndPrint("SHOW SCHEMAS");
        SecuredPhoenixCommandTest.run((String)"USE phoenix123.V1", (Object[])new Object[0]);
        Assert.assertEquals((long)1L, (long)this.queryBuilder().sql("SHOW TABLES LIKE '%REGION%'").run().recordCount());
    }

    @Test
    public void testShowTables() throws Exception {
        this.runForThreeClients(this::doTestShowTables);
    }

    private void doTestShowTables() throws Exception {
        String sql = "SHOW TABLES FROM phoenix123.v1";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("TABLE_SCHEMA", TypeProtos.MinorType.VARCHAR).addNullable("TABLE_NAME", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"phoenix123.v1", "ARRAYTYPE"}).addRow(new Object[]{"phoenix123.v1", "DATATYPE"}).addRow(new Object[]{"phoenix123.v1", "NATION"}).addRow(new Object[]{"phoenix123.v1", "REGION"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testDescribe() throws Exception {
        this.runForThreeClients(this::doTestDescribe);
    }

    private void doTestDescribe() throws Exception {
        SecuredPhoenixCommandTest.run((String)"USE phoenix123.v1", (Object[])new Object[0]);
        Assert.assertEquals((long)4L, (long)this.queryBuilder().sql("DESCRIBE NATION").run().recordCount());
    }
}

