/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix;

import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import org.apache.drill.categories.RowSetTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.phoenix.PhoenixBaseTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.apache.drill.test.rowSet.RowSetUtilities;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
@Category(value={SlowTest.class, RowSetTest.class})
public class PhoenixDataTypeTest
extends PhoenixBaseTest {
    @Test
    public void testDataType() throws Exception {
        String sql = "select * from phoenix123.v1.datatype";
        QueryBuilder builder = this.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("T_UUID", TypeProtos.MinorType.VARCHAR).addNullable("T_VARCHAR", TypeProtos.MinorType.VARCHAR).addNullable("T_CHAR", TypeProtos.MinorType.VARCHAR).addNullable("T_BIGINT", TypeProtos.MinorType.BIGINT).addNullable("T_INTEGER", TypeProtos.MinorType.INT).addNullable("T_SMALLINT", TypeProtos.MinorType.INT).addNullable("T_TINYINT", TypeProtos.MinorType.INT).addNullable("T_DOUBLE", TypeProtos.MinorType.FLOAT8).addNullable("T_FLOAT", TypeProtos.MinorType.FLOAT4).addNullable("T_DECIMAL", TypeProtos.MinorType.VARDECIMAL).addNullable("T_DATE", TypeProtos.MinorType.DATE).addNullable("T_TIME", TypeProtos.MinorType.TIME).addNullable("T_TIMESTAMP", TypeProtos.MinorType.TIMESTAMP).addNullable("T_BINARY", TypeProtos.MinorType.VARBINARY).addNullable("T_VARBINARY", TypeProtos.MinorType.VARBINARY).addNullable("T_BOOLEAN", TypeProtos.MinorType.BIT).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{U_U_I_D, "apache", "drill", Long.MAX_VALUE, Integer.MAX_VALUE, (short)Short.MAX_VALUE, (byte)127, Double.MAX_VALUE, Float.valueOf(Float.MAX_VALUE), BigDecimal.valueOf(10.11), LocalDate.parse("2021-12-12"), LocalTime.parse("12:12:12"), Instant.ofEpochMilli(1639311132000L), "a_b_c_d_e_".getBytes(StandardCharsets.UTF_8), "12345".getBytes(StandardCharsets.UTF_8), Boolean.TRUE}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testArrayType() throws Exception {
        String sql = "select * from phoenix123.v1.arraytype";
        QueryBuilder builder = this.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("T_UUID", TypeProtos.MinorType.VARCHAR).addArray("T_VARCHAR", TypeProtos.MinorType.VARCHAR).addArray("T_CHAR", TypeProtos.MinorType.VARCHAR).addArray("T_BIGINT", TypeProtos.MinorType.BIGINT).addArray("T_INTEGER", TypeProtos.MinorType.INT).addArray("T_DOUBLE", TypeProtos.MinorType.FLOAT8).addArray("T_SMALLINT", TypeProtos.MinorType.SMALLINT).addArray("T_TINYINT", TypeProtos.MinorType.TINYINT).addArray("T_BOOLEAN", TypeProtos.MinorType.BIT).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{U_U_I_D, RowSetUtilities.strArray((String[])new String[]{"apache", "drill", "1.20"}), RowSetUtilities.strArray((String[])new String[]{"a", "b", "c"}), RowSetUtilities.longArray((Long[])new Long[]{Long.MIN_VALUE, Long.MAX_VALUE}), RowSetUtilities.intArray((Integer[])new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE}), RowSetUtilities.doubleArray((Double[])new Double[]{Double.MIN_VALUE, Double.MAX_VALUE}), RowSetUtilities.shortArray((Short[])new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE}), RowSetUtilities.byteArray((Integer[])new Integer[]{-128, 127}), RowSetUtilities.boolArray((Boolean[])new Boolean[]{Boolean.TRUE, Boolean.FALSE})}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }
}

