/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixBasicsIT {
    private static final HBaseTestingUtility util = new HBaseTestingUtility();
    private static final Logger logger = LoggerFactory.getLogger(PhoenixBasicsIT.class);
    protected static String CONN_STRING;
    static LocalHBaseCluster hbaseCluster;

    public static synchronized void doSetup() throws Exception {
        Configuration conf = util.getConfiguration();
        util.startMiniZKCluster();
        Path rootdir = util.getDataTestDirOnTestFS(PhoenixBasicsIT.class.getSimpleName());
        conf.set("hbase.rootdir", rootdir.toString());
        hbaseCluster = new LocalHBaseCluster(conf, 1);
        hbaseCluster.startup();
        CONN_STRING = "jdbc:phoenix:localhost:" + PhoenixBasicsIT.getZookeeperPort();
        logger.info("JDBC connection string is " + CONN_STRING);
    }

    public static int getZookeeperPort() {
        return util.getConfiguration().getInt("hbase.zookeeper.property.clientPort", 2181);
    }

    public static void testCatalogs() throws Exception {
        try (Connection connection = DriverManager.getConnection(CONN_STRING);){
            Assert.assertFalse((boolean)connection.isClosed());
            try (ResultSet resultSet = connection.getMetaData().getCatalogs();){
                ResultSetMetaData metaData = resultSet.getMetaData();
                Assert.assertFalse((String)"unexpected populated resultSet", (boolean)resultSet.next());
                Assert.assertEquals((long)1L, (long)metaData.getColumnCount());
                Assert.assertEquals((Object)"TABLE_CAT", (Object)metaData.getColumnName(1));
            }
        }
    }

    public static synchronized void afterClass() throws IOException {
        Optional.of(hbaseCluster).ifPresent(LocalHBaseCluster::shutdown);
        util.shutdownMiniCluster();
    }
}

