/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix.secured;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.http.HttpConfig;
import org.apache.hadoop.minikdc.MiniKdc;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.util.KerberosName;
import org.apache.phoenix.query.ConfigurationFactory;
import org.apache.phoenix.util.InstanceResolver;
import org.junit.Assert;

public class PhoenixEnvironment {
    private final File tempDir = new File(PhoenixEnvironment.getTempDir());
    private final File keytabDir = new File(this.tempDir, "keytabs");
    private final List<File> userKeytabFiles = new ArrayList<File>();
    private static final String LOCAL_HOST_REVERSE_DNS_LOOKUP_NAME;
    static final String LOGIN_USER;
    private static final String SPNEGO_PRINCIPAL;
    private static final String PQS_PRINCIPAL;
    private static final String SERVICE_PRINCIPAL;
    private final File keytab;
    private final MiniKdc kdc;
    private final HBaseTestingUtility util = new HBaseTestingUtility(PhoenixEnvironment.conf());
    private final LocalHBaseCluster hbaseCluster;
    private int numCreatedUsers;
    private final String phoenixUrl;

    private static Configuration conf() {
        Configuration configuration = HBaseConfiguration.create();
        configuration.set("hbase.security.authentication", "kerberos");
        return configuration;
    }

    private static String getTempDir() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(System.getProperty("user.dir")).append(File.separator);
        sb.append("target").append(File.separator);
        sb.append(PhoenixEnvironment.class.getSimpleName());
        sb.append("-").append(UUID.randomUUID());
        return sb.toString();
    }

    public String getPhoenixUrl() {
        return this.phoenixUrl;
    }

    public HBaseTestingUtility getUtil() {
        return this.util;
    }

    public File getServiceKeytab() {
        return this.keytab;
    }

    private static void updateDefaultRealm() throws Exception {
        Field f = KerberosName.class.getDeclaredField("defaultRealm");
        f.setAccessible(true);
        f.set(null, "EXAMPLE.COM");
    }

    private void createUsers(int numUsers) throws Exception {
        Assert.assertNotNull((String)"KDC is null, was setup method called?", (Object)this.kdc);
        this.numCreatedUsers = numUsers;
        for (int i = 1; i <= numUsers; ++i) {
            String principal = "user" + i;
            File keytabFile = new File(this.keytabDir, principal + ".keytab");
            this.kdc.createPrincipal(keytabFile, new String[]{principal});
            this.userKeytabFiles.add(keytabFile);
        }
    }

    public Map.Entry<String, File> getUser(int offset) {
        if (offset <= 0 || offset > this.numCreatedUsers) {
            throw new IllegalArgumentException();
        }
        return new AbstractMap.SimpleImmutableEntry<String, File>("user" + offset, this.userKeytabFiles.get(offset - 1));
    }

    private void setHdfsSecuredConfiguration(Configuration conf) throws Exception {
        conf.set("dfs.namenode.kerberos.principal", SERVICE_PRINCIPAL + "@" + this.kdc.getRealm());
        conf.set("dfs.namenode.keytab.file", this.keytab.getAbsolutePath());
        conf.set("dfs.datanode.kerberos.principal", SERVICE_PRINCIPAL + "@" + this.kdc.getRealm());
        conf.set("dfs.datanode.keytab.file", this.keytab.getAbsolutePath());
        conf.set("dfs.web.authentication.kerberos.principal", SPNEGO_PRINCIPAL + "@" + this.kdc.getRealm());
        conf.setBoolean("dfs.block.access.token.enable", true);
        conf.set("dfs.http.policy", HttpConfig.Policy.HTTPS_ONLY.name());
        conf.set("dfs.namenode.https-address", "localhost:0");
        conf.set("dfs.datanode.https.address", "localhost:0");
        File keystoresDir = new File(this.util.getDataTestDir("keystore").toUri().getPath());
        keystoresDir.mkdirs();
        conf.setBoolean("ignore.secure.ports.for.testing", true);
    }

    private static void ensureIsEmptyDirectory(File f) throws IOException {
        if (f.exists()) {
            if (f.isDirectory()) {
                FileUtils.deleteDirectory((File)f);
            } else {
                Assert.assertTrue((String)"Failed to delete keytab directory", (boolean)f.delete());
            }
        }
        Assert.assertTrue((String)"Failed to create keytab directory", (boolean)f.mkdirs());
    }

    public PhoenixEnvironment(Configuration confIn, int numberOfUsers, boolean tls) throws Exception {
        final Configuration conf = this.util.getConfiguration();
        conf.addResource(confIn);
        PhoenixEnvironment.ensureIsEmptyDirectory(this.tempDir);
        PhoenixEnvironment.ensureIsEmptyDirectory(this.keytabDir);
        this.keytab = new File(this.keytabDir, "test.keytab");
        this.kdc = this.util.setupMiniKdc(this.keytab);
        this.kdc.createPrincipal(this.keytab, new String[]{SPNEGO_PRINCIPAL, PQS_PRINCIPAL, SERVICE_PRINCIPAL});
        this.util.startMiniZKCluster();
        this.createUsers(numberOfUsers);
        HBaseKerberosUtils.setPrincipalForTesting((String)(SERVICE_PRINCIPAL + "@" + this.kdc.getRealm()));
        HBaseKerberosUtils.setSecuredConfiguration((Configuration)conf);
        this.setHdfsSecuredConfiguration(conf);
        UserGroupInformation.setConfiguration((Configuration)conf);
        conf.setInt("hbase.master.port", 0);
        conf.setInt("hbase.master.info.port", 0);
        conf.setInt("hbase.regionserver.port", 0);
        conf.setInt("hbase.regionserver.info.port", 0);
        InstanceResolver.clearSingletons();
        InstanceResolver.getSingleton(ConfigurationFactory.class, (Object)new ConfigurationFactory(){

            public Configuration getConfiguration() {
                return conf;
            }

            public Configuration getConfiguration(Configuration confToClone) {
                Configuration copy = new Configuration(conf);
                copy.addResource(confToClone);
                return copy;
            }
        });
        PhoenixEnvironment.updateDefaultRealm();
        Path rootdir = this.util.getDataTestDirOnTestFS(PhoenixEnvironment.class.getSimpleName());
        conf.set("hbase.rootdir", rootdir.toString());
        this.hbaseCluster = new LocalHBaseCluster(conf, 1);
        this.hbaseCluster.startup();
        this.phoenixUrl = "jdbc:phoenix:localhost:" + this.getZookeeperPort();
    }

    public int getZookeeperPort() {
        return this.util.getConfiguration().getInt("hbase.zookeeper.property.clientPort", 2181);
    }

    public void stop() throws Exception {
        InstanceResolver.clearSingletons();
        if (this.hbaseCluster != null) {
            this.hbaseCluster.shutdown();
            this.hbaseCluster.join();
        }
        this.util.shutdownMiniCluster();
        if (this.kdc != null) {
            this.kdc.stop();
        }
        this.util.closeConnection();
    }

    static {
        try {
            LOCAL_HOST_REVERSE_DNS_LOOKUP_NAME = InetAddress.getByName("127.0.0.1").getCanonicalHostName();
            String userName = System.getProperty("user.name");
            LOGIN_USER = userName != null ? userName : "securecluster";
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SPNEGO_PRINCIPAL = "HTTP/" + LOCAL_HOST_REVERSE_DNS_LOOKUP_NAME;
        PQS_PRINCIPAL = "phoenixqs/" + LOCAL_HOST_REVERSE_DNS_LOOKUP_NAME;
        SERVICE_PRINCIPAL = LOGIN_USER + "/" + LOCAL_HOST_REVERSE_DNS_LOOKUP_NAME;
    }
}

