/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix;

import org.apache.drill.categories.RowSetTest;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.phoenix.PhoenixBaseTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
@Category(value={SlowTest.class, RowSetTest.class})
public class PhoenixCommandTest
extends PhoenixBaseTest {
    @Test
    public void testShowTablesLike() throws Exception {
        this.runAndPrint("SHOW SCHEMAS");
        PhoenixCommandTest.run((String)"USE phoenix123.v1", (Object[])new Object[0]);
        Assert.assertEquals((long)1L, (long)this.queryBuilder().sql("SHOW TABLES LIKE '%REGION%'").run().recordCount());
    }

    @Test
    public void testShowTables() throws Exception {
        String sql = "SHOW TABLES FROM phoenix123.v1";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("TABLE_SCHEMA", TypeProtos.MinorType.VARCHAR).addNullable("TABLE_NAME", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"phoenix123.v1", "ARRAYTYPE"}).addRow(new Object[]{"phoenix123.v1", "DATATYPE"}).addRow(new Object[]{"phoenix123.v1", "NATION"}).addRow(new Object[]{"phoenix123.v1", "REGION"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testDescribe() throws Exception {
        Assert.assertEquals((long)4L, (long)this.queryBuilder().sql("DESCRIBE phoenix123.v1.NATION").run().recordCount());
    }

    @Test
    public void testDescribeCaseInsensitive() throws Exception {
        String sql = "DESCRIBE phoenix123.v1.nation";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("COLUMN_NAME", TypeProtos.MinorType.VARCHAR).addNullable("DATA_TYPE", TypeProtos.MinorType.VARCHAR).addNullable("IS_NULLABLE", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"N_NATIONKEY", "BIGINT", "NO"}).addRow(new Object[]{"N_NAME", "CHARACTER VARYING", "YES"}).addRow(new Object[]{"N_REGIONKEY", "BIGINT", "YES"}).addRow(new Object[]{"N_COMMENT", "CHARACTER VARYING", "YES"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }
}

