/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix.secured;

import ch.qos.logback.classic.Level;
import com.sun.security.auth.module.Krb5LoginModule;
import java.io.File;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.common.exceptions.UserRemoteException;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.rpc.security.ServerAuthenticationHandler;
import org.apache.drill.exec.rpc.security.kerberos.KerberosFactory;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.phoenix.PhoenixBaseTest;
import org.apache.drill.exec.store.phoenix.PhoenixDataSource;
import org.apache.drill.exec.store.phoenix.PhoenixStoragePluginConfig;
import org.apache.drill.exec.store.phoenix.secured.HttpParamImpersonationQueryServerIT;
import org.apache.drill.exec.store.phoenix.secured.QueryServerEnvironment;
import org.apache.drill.exec.store.phoenix.secured.SecuredPhoenixTestSuite;
import org.apache.drill.exec.util.ImpersonationUtil;
import org.apache.drill.shaded.guava.com.google.common.collect.Lists;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.drill.test.LogFixture;
import org.apache.hadoop.hbase.security.HBaseKerberosUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.phoenix.queryserver.server.QueryServer;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SecuredPhoenixBaseTest
extends ClusterTest {
    private static final Logger logger = LoggerFactory.getLogger(PhoenixDataSource.class);
    protected static LogFixture logFixture;
    private static final Level CURRENT_LOG_LEVEL;
    private static final AtomicInteger initCount;

    @BeforeAll
    public static void setUpBeforeClass() throws Exception {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        SecuredPhoenixTestSuite.initPhoenixQueryServer();
        SecuredPhoenixBaseTest.startSecuredDrillCluster();
        SecuredPhoenixBaseTest.initializeDatabase();
    }

    private static void startSecuredDrillCluster() throws Exception {
        logFixture = LogFixture.builder().toConsole().logger(QueryServerEnvironment.class, CURRENT_LOG_LEVEL).logger(SecuredPhoenixBaseTest.class, CURRENT_LOG_LEVEL).logger(KerberosFactory.class, CURRENT_LOG_LEVEL).logger(Krb5LoginModule.class, CURRENT_LOG_LEVEL).logger(QueryServer.class, CURRENT_LOG_LEVEL).logger(ServerAuthenticationHandler.class, CURRENT_LOG_LEVEL).build();
        Map.Entry<String, File> user1 = HttpParamImpersonationQueryServerIT.environment.getUser(1);
        Map.Entry<String, File> user2 = HttpParamImpersonationQueryServerIT.environment.getUser(2);
        Map.Entry<String, File> user3 = HttpParamImpersonationQueryServerIT.environment.getUser(3);
        dirTestWatcher.start(SecuredPhoenixTestSuite.class);
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher).configProperty("drill.exec.security.user.auth.enabled", (Object)true).configProperty("drill.exec.security.user.auth.impl", (Object)"drillTestAuthenticator").configNonStringProperty("drill.exec.security.auth.mechanisms", (Object)Lists.newArrayList((Object[])new String[]{"kerberos"})).configProperty("drill.exec.impersonation.enabled", (Object)true).configProperty("drill.exec.security.bit.auth.enabled", (Object)true).configProperty("drill.exec.security.bit.auth.mechanism", (Object)"kerberos").configProperty("drill.exec.security.auth.principal", (Object)HBaseKerberosUtils.getPrincipalForTesting()).configProperty("drill.exec.security.auth.keytab", (Object)HttpParamImpersonationQueryServerIT.environment.getServiceKeytab().getAbsolutePath()).configClientProperty("principal", (Object)HBaseKerberosUtils.getPrincipalForTesting()).configClientProperty("user", (Object)user1.getKey()).configClientProperty("keytab", (Object)user1.getValue().getAbsolutePath());
        SecuredPhoenixBaseTest.startCluster((ClusterFixtureBuilder)builder);
        Properties user2ClientProperties = new Properties();
        user2ClientProperties.setProperty("principal", HBaseKerberosUtils.getPrincipalForTesting());
        user2ClientProperties.setProperty("user", user2.getKey());
        user2ClientProperties.setProperty("keytab", user2.getValue().getAbsolutePath());
        cluster.addClientFixture(user2ClientProperties);
        Properties user3ClientProperties = new Properties();
        user3ClientProperties.setProperty("principal", HBaseKerberosUtils.getPrincipalForTesting());
        user3ClientProperties.setProperty("user", user3.getKey());
        user3ClientProperties.setProperty("keytab", user3.getValue().getAbsolutePath());
        cluster.addClientFixture(user3ClientProperties);
        HashMap<String, Object> phoenixProps = new HashMap<String, Object>();
        phoenixProps.put("phoenix.query.timeoutMs", 90000);
        phoenixProps.put("phoenix.query.keepAliveMs", "30000");
        phoenixProps.put("phoenix.queryserver.withRemoteUserExtractor", true);
        StoragePluginRegistry registry = cluster.drillbit().getContext().getStorage();
        String doAsUrl = String.format(HttpParamImpersonationQueryServerIT.getUrlTemplate(), "$user");
        logger.debug("Phoenix Query Server URL: {}", (Object)HttpParamImpersonationQueryServerIT.environment.getPqsUrl());
        PhoenixStoragePluginConfig config = new PhoenixStoragePluginConfig(null, 0, null, null, doAsUrl, null, phoenixProps);
        config.setEnabled(Boolean.valueOf(true));
        registry.put("phoenix123", (StoragePluginConfig)config);
    }

    private static void initializeDatabase() throws Exception {
        dirTestWatcher.copyResourceToRoot(Paths.get("", new String[0]));
        if (initCount.incrementAndGet() == 1) {
            Map.Entry<String, File> user1 = HttpParamImpersonationQueryServerIT.environment.getUser(1);
            Map.Entry<String, File> user2 = HttpParamImpersonationQueryServerIT.environment.getUser(2);
            UserGroupInformation serviceUgi = ImpersonationUtil.getProcessUserUGI();
            serviceUgi.doAs(() -> {
                PhoenixBaseTest.createSchema(HttpParamImpersonationQueryServerIT.environment.getPqsUrl());
                PhoenixBaseTest.createTables(HttpParamImpersonationQueryServerIT.environment.getPqsUrl());
                PhoenixBaseTest.createSampleData(HttpParamImpersonationQueryServerIT.environment.getPqsUrl());
                HttpParamImpersonationQueryServerIT.grantUsersToPhoenixSystemTables(Arrays.asList((String)user1.getKey(), (String)user2.getKey()));
                HttpParamImpersonationQueryServerIT.grantUsersToGlobalPhoenixUserTables(Arrays.asList((String)user1.getKey()));
                return null;
            });
        }
    }

    public void runForThreeClients(TestWrapper wrapper) throws Exception {
        this.runForThreeClients(wrapper, UserRemoteException.class, RuntimeException.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runForThreeClients(TestWrapper wrapper, Class user2ExpectedException, Class user3ExpectedException) throws Exception {
        try {
            client = cluster.client(0);
            wrapper.apply();
            client = cluster.client(1);
            Assertions.assertThrows((Class)user2ExpectedException, wrapper::apply);
            client = cluster.client(2);
            Assertions.assertThrows((Class)user3ExpectedException, wrapper::apply);
        }
        finally {
            client = cluster.client(0);
        }
    }

    @AfterAll
    public static void tearDownCluster() throws Exception {
        if (!SecuredPhoenixTestSuite.isRunningSuite() && HttpParamImpersonationQueryServerIT.environment != null) {
            HttpParamImpersonationQueryServerIT.stopEnvironment();
        }
    }

    static {
        CURRENT_LOG_LEVEL = Level.INFO;
        initCount = new AtomicInteger(0);
    }

    protected static interface TestWrapper {
        public void apply() throws Exception;
    }
}

