/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix;

import org.apache.drill.categories.RowSetTests;
import org.apache.drill.categories.SlowTest;
import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.exec.physical.rowSet.DirectRowSet;
import org.apache.drill.exec.physical.rowSet.RowSet;
import org.apache.drill.exec.physical.rowSet.RowSetBuilder;
import org.apache.drill.exec.planner.physical.PlannerSettings;
import org.apache.drill.exec.record.metadata.SchemaBuilder;
import org.apache.drill.exec.record.metadata.TupleMetadata;
import org.apache.drill.exec.store.phoenix.PhoenixBaseTest;
import org.apache.drill.test.QueryBuilder;
import org.apache.drill.test.rowSet.RowSetComparison;
import org.junit.Assert;
import org.junit.FixMethodOrder;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runners.MethodSorters;

@FixMethodOrder(value=MethodSorters.JVM)
@Category(value={SlowTest.class, RowSetTests.class})
public class PhoenixSQLTest
extends PhoenixBaseTest {
    @Test
    public void testStarQuery() throws Exception {
        String sql = "select * from phoenix123.v1.nation";
        this.queryBuilder().sql(sql).run();
    }

    @Test
    public void testExplicitQuery() throws Exception {
        String sql = "select n_nationkey, n_regionkey, n_name from phoenix123.v1.nation";
        QueryBuilder builder = this.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        TupleMetadata schema = new SchemaBuilder().addNullable("n_nationkey", TypeProtos.MinorType.BIGINT).addNullable("n_regionkey", TypeProtos.MinorType.BIGINT).addNullable("n_name", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{0, 0, "ALGERIA"}).addRow(new Object[]{1, 1, "ARGENTINA"}).addRow(new Object[]{2, 1, "BRAZIL"}).addRow(new Object[]{3, 1, "CANADA"}).addRow(new Object[]{4, 4, "EGYPT"}).addRow(new Object[]{5, 0, "ETHIOPIA"}).addRow(new Object[]{6, 3, "FRANCE"}).addRow(new Object[]{7, 3, "GERMANY"}).addRow(new Object[]{8, 2, "INDIA"}).addRow(new Object[]{9, 2, "INDONESIA"}).addRow(new Object[]{10, 4, "IRAN"}).addRow(new Object[]{11, 4, "IRAQ"}).addRow(new Object[]{12, 2, "JAPAN"}).addRow(new Object[]{13, 4, "JORDAN"}).addRow(new Object[]{14, 0, "KENYA"}).addRow(new Object[]{15, 0, "MOROCCO"}).addRow(new Object[]{16, 0, "MOZAMBIQUE"}).addRow(new Object[]{17, 1, "PERU"}).addRow(new Object[]{18, 2, "CHINA"}).addRow(new Object[]{19, 3, "ROMANIA"}).addRow(new Object[]{20, 4, "SAUDI ARABIA"}).addRow(new Object[]{21, 2, "VIETNAM"}).addRow(new Object[]{22, 3, "RUSSIA"}).addRow(new Object[]{23, 3, "UNITED KINGDOM"}).addRow(new Object[]{24, 1, "UNITED STATES"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testLimitPushdown() throws Exception {
        String sql = "select n_name, n_regionkey from phoenix123.v1.nation limit 20 offset 10";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        builder.planMatcher().exclude(new String[]{"Limit"}).include(new String[]{"OFFSET .* ROWS FETCH NEXT .* ROWS ONLY"}).match();
        Assert.assertEquals((long)15L, (long)sets.rowCount());
        TupleMetadata schema = new SchemaBuilder().addNullable("n_name", TypeProtos.MinorType.VARCHAR).addNullable("n_regionkey", TypeProtos.MinorType.BIGINT).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"IRAN", 4}).addRow(new Object[]{"IRAQ", 4}).addRow(new Object[]{"JAPAN", 2}).addRow(new Object[]{"JORDAN", 4}).addRow(new Object[]{"KENYA", 0}).addRow(new Object[]{"MOROCCO", 0}).addRow(new Object[]{"MOZAMBIQUE", 0}).addRow(new Object[]{"PERU", 1}).addRow(new Object[]{"CHINA", 2}).addRow(new Object[]{"ROMANIA", 3}).addRow(new Object[]{"SAUDI ARABIA", 4}).addRow(new Object[]{"VIETNAM", 2}).addRow(new Object[]{"RUSSIA", 3}).addRow(new Object[]{"UNITED KINGDOM", 3}).addRow(new Object[]{"UNITED STATES", 1}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testFilterPushdown() throws Exception {
        String sql = "select * from phoenix123.v1.region where r_name = 'ASIA'";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        builder.planMatcher().exclude(new String[]{"Filter"}).include(new String[]{"WHERE .* = 'ASIA'"}).match();
        TupleMetadata schema = new SchemaBuilder().addNullable("R_REGIONKEY", TypeProtos.MinorType.BIGINT).addNullable("R_NAME", TypeProtos.MinorType.VARCHAR).addNullable("R_COMMENT", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{2, "ASIA", "ges. thinly even pinto beans ca"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testSerDe() throws Exception {
        String sql = "select count(*) as total from phoenix123.v1.nation";
        String plan = this.queryBuilder().sql(sql).explainJson();
        long cnt = this.queryBuilder().physical(plan).singletonLong();
        Assert.assertEquals((String)"Counts should match", (long)25L, (long)cnt);
    }

    @Test
    public void testJoinPushdown() throws Exception {
        String sql = "select a.n_name, b.r_name from phoenix123.v1.nation a join phoenix123.v1.region b on a.n_regionkey = b.r_regionkey";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        builder.planMatcher().exclude(new String[]{"Join"}).include(new String[]{"Phoenix\\(.* INNER JOIN"}).match();
        TupleMetadata schema = new SchemaBuilder().addNullable("n_name", TypeProtos.MinorType.VARCHAR).addNullable("r_name", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"ALGERIA", "AFRICA"}).addRow(new Object[]{"ARGENTINA", "AMERICA"}).addRow(new Object[]{"BRAZIL", "AMERICA"}).addRow(new Object[]{"CANADA", "AMERICA"}).addRow(new Object[]{"EGYPT", "MIDDLE EAST"}).addRow(new Object[]{"ETHIOPIA", "AFRICA"}).addRow(new Object[]{"FRANCE", "EUROPE"}).addRow(new Object[]{"GERMANY", "EUROPE"}).addRow(new Object[]{"INDIA", "ASIA"}).addRow(new Object[]{"INDONESIA", "ASIA"}).addRow(new Object[]{"IRAN", "MIDDLE EAST"}).addRow(new Object[]{"IRAQ", "MIDDLE EAST"}).addRow(new Object[]{"JAPAN", "ASIA"}).addRow(new Object[]{"JORDAN", "MIDDLE EAST"}).addRow(new Object[]{"KENYA", "AFRICA"}).addRow(new Object[]{"MOROCCO", "AFRICA"}).addRow(new Object[]{"MOZAMBIQUE", "AFRICA"}).addRow(new Object[]{"PERU", "AMERICA"}).addRow(new Object[]{"CHINA", "ASIA"}).addRow(new Object[]{"ROMANIA", "EUROPE"}).addRow(new Object[]{"SAUDI ARABIA", "MIDDLE EAST"}).addRow(new Object[]{"VIETNAM", "ASIA"}).addRow(new Object[]{"RUSSIA", "EUROPE"}).addRow(new Object[]{"UNITED KINGDOM", "EUROPE"}).addRow(new Object[]{"UNITED STATES", "AMERICA"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testCrossJoin() throws Exception {
        String sql = "select a.n_name, b.n_comment from phoenix123.v1.nation a cross join phoenix123.v1.nation b";
        client.alterSession(PlannerSettings.NLJOIN_FOR_SCALAR.getOptionName(), (Object)false);
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        builder.planMatcher().exclude(new String[]{"Join"}).match();
        Assert.assertEquals((String)"Counts should match", (long)625L, (long)sets.rowCount());
        sets.clear();
    }

    @Ignore(value="use the remote query server directly without minicluster")
    @Test
    public void testJoinWithFilterPushdown() throws Exception {
        String sql = "select 10 as DRILL, a.n_name, b.r_name from phoenix123.v1.nation a join phoenix123.v1.region b on a.n_regionkey = b.r_regionkey where b.r_name = 'ASIA'";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        builder.planMatcher().exclude(new String[]{"Join"}).exclude(new String[]{"Filter"}).include(new String[]{"Phoenix\\(.* INNER JOIN .* WHERE"}).match();
        TupleMetadata schema = new SchemaBuilder().addNullable("DRILL", TypeProtos.MinorType.INT).addNullable("n_name", TypeProtos.MinorType.VARCHAR).addNullable("r_name", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{10, "INDIA", "ASIA"}).addRow(new Object[]{10, "INDONESIA", "ASIA"}).addRow(new Object[]{10, "JAPAN", "ASIA"}).addRow(new Object[]{10, "CHINA", "ASIA"}).addRow(new Object[]{10, "VIETNAM", "ASIA"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testGroupByPushdown() throws Exception {
        String sql = "select n_regionkey, count(1) as total from phoenix123.v1.nation group by n_regionkey";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        builder.planMatcher().exclude(new String[]{"Aggregate"}).include(new String[]{"Phoenix\\(.* GROUP BY"}).match();
        TupleMetadata schema = new SchemaBuilder().addNullable("n_regionkey", TypeProtos.MinorType.BIGINT).addNullable("total", TypeProtos.MinorType.BIGINT).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{0, 5}).addRow(new Object[]{1, 5}).addRow(new Object[]{2, 5}).addRow(new Object[]{3, 5}).addRow(new Object[]{4, 5}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testDistinctPushdown() throws Exception {
        String sql = "select distinct n_name from phoenix123.v1.nation";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        builder.planMatcher().exclude(new String[]{"Aggregate"}).include(new String[]{"Phoenix\\(.* GROUP BY \"N_NAME"}).match();
        TupleMetadata schema = new SchemaBuilder().addNullable("n_name", TypeProtos.MinorType.VARCHAR).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{"ALGERIA"}).addRow(new Object[]{"ARGENTINA"}).addRow(new Object[]{"BRAZIL"}).addRow(new Object[]{"CANADA"}).addRow(new Object[]{"CHINA"}).addRow(new Object[]{"EGYPT"}).addRow(new Object[]{"ETHIOPIA"}).addRow(new Object[]{"FRANCE"}).addRow(new Object[]{"GERMANY"}).addRow(new Object[]{"INDIA"}).addRow(new Object[]{"INDONESIA"}).addRow(new Object[]{"IRAN"}).addRow(new Object[]{"IRAQ"}).addRow(new Object[]{"JAPAN"}).addRow(new Object[]{"JORDAN"}).addRow(new Object[]{"KENYA"}).addRow(new Object[]{"MOROCCO"}).addRow(new Object[]{"MOZAMBIQUE"}).addRow(new Object[]{"PERU"}).addRow(new Object[]{"ROMANIA"}).addRow(new Object[]{"RUSSIA"}).addRow(new Object[]{"SAUDI ARABIA"}).addRow(new Object[]{"UNITED KINGDOM"}).addRow(new Object[]{"UNITED STATES"}).addRow(new Object[]{"VIETNAM"}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }

    @Test
    public void testHavingPushdown() throws Exception {
        String sql = "select n_regionkey, max(n_nationkey) from phoenix123.v1.nation group by n_regionkey having max(n_nationkey) > 20";
        QueryBuilder builder = client.queryBuilder().sql(sql);
        DirectRowSet sets = builder.rowSet();
        builder.planMatcher().exclude(new String[]{"Aggregate"}).include(new String[]{"Phoenix\\(.* GROUP BY .* HAVING MAX"}).match();
        TupleMetadata schema = new SchemaBuilder().addNullable("n_regionkey", TypeProtos.MinorType.BIGINT).addNullable("EXPR$1", TypeProtos.MinorType.BIGINT).build();
        RowSet.SingleRowSet expected = new RowSetBuilder(client.allocator(), schema).addRow(new Object[]{1, 24}).addRow(new Object[]{2, 21}).addRow(new Object[]{3, 23}).build();
        new RowSetComparison((RowSet)expected).verifyAndClearAll((RowSet)sets);
    }
}

