/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix;

import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.file.Paths;
import java.sql.Array;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.common.logical.StoragePluginConfig;
import org.apache.drill.exec.store.StoragePluginRegistry;
import org.apache.drill.exec.store.phoenix.PhoenixStoragePluginConfig;
import org.apache.drill.exec.store.phoenix.PhoenixTestSuite;
import org.apache.drill.exec.store.phoenix.QueryServerBasicsIT;
import org.apache.drill.shaded.guava.com.google.common.collect.Maps;
import org.apache.drill.test.BaseDirTestWatcher;
import org.apache.drill.test.ClusterFixture;
import org.apache.drill.test.ClusterFixtureBuilder;
import org.apache.drill.test.ClusterTest;
import org.apache.hadoop.fs.Path;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PhoenixBaseTest
extends ClusterTest {
    private static final Logger logger = LoggerFactory.getLogger(PhoenixBaseTest.class);
    public static final String U_U_I_D = UUID.randomUUID().toString();
    private static final AtomicInteger initCount = new AtomicInteger(0);

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        PhoenixTestSuite.initPhoenixQueryServer();
        if (PhoenixTestSuite.isRunningSuite()) {
            QueryServerBasicsIT.testCatalogs();
        }
        PhoenixBaseTest.startDrillCluster();
        if (initCount.incrementAndGet() == 1) {
            PhoenixBaseTest.createSchema(QueryServerBasicsIT.CONN_STRING);
            PhoenixBaseTest.createTables(QueryServerBasicsIT.CONN_STRING);
            PhoenixBaseTest.createSampleData(QueryServerBasicsIT.CONN_STRING);
        }
    }

    @AfterClass
    public static void tearDownCluster() throws Exception {
        if (!PhoenixTestSuite.isRunningSuite()) {
            PhoenixTestSuite.tearDownCluster();
        }
    }

    public static void startDrillCluster() throws Exception {
        ClusterFixtureBuilder builder = ClusterFixture.builder((BaseDirTestWatcher)dirTestWatcher);
        PhoenixBaseTest.startCluster((ClusterFixtureBuilder)builder);
        HashMap props = Maps.newHashMap();
        props.put("phoenix.query.timeoutMs", 90000);
        props.put("phoenix.query.keepAliveMs", "30000");
        StoragePluginRegistry registry = cluster.drillbit().getContext().getStorage();
        PhoenixStoragePluginConfig config = new PhoenixStoragePluginConfig(null, 0, null, null, QueryServerBasicsIT.CONN_STRING, null, (Map)props);
        config.setEnabled(Boolean.valueOf(true));
        registry.put("phoenix123", (StoragePluginConfig)config);
        dirTestWatcher.copyResourceToRoot(Paths.get("", new String[0]));
    }

    public static void createSchema(String connString) throws Exception {
        try (Connection connection = DriverManager.getConnection(connString);){
            logger.debug("Phoenix connection established with the specified url : {}", (Object)connString);
            Assert.assertFalse((boolean)connection.isClosed());
            connection.setAutoCommit(true);
            try (Statement stmt = connection.createStatement();){
                Assert.assertFalse((boolean)stmt.execute("CREATE SCHEMA IF NOT EXISTS V1"));
            }
        }
    }

    public static void createTables(String connString) throws Exception {
        try (Connection connection = DriverManager.getConnection(connString);){
            Assert.assertFalse((boolean)connection.isClosed());
            connection.setAutoCommit(true);
            try (Statement stmt = connection.createStatement();){
                String region_sql = " CREATE TABLE V1.REGION (    R_REGIONKEY BIGINT not null,    R_NAME      VARCHAR,    R_COMMENT   VARCHAR    CONSTRAINT  REGION_PK PRIMARY KEY (R_REGIONKEY))";
                String nation_sql = " CREATE TABLE V1.NATION (    N_NATIONKEY BIGINT not null primary key,    N_NAME      VARCHAR(100),    N_REGIONKEY BIGINT,    N_COMMENT   VARCHAR(255))";
                String datatype_sql = " CREATE TABLE V1.DATATYPE (    T_UUID      VARCHAR not null primary key,    T_VARCHAR   VARCHAR,    T_CHAR      CHAR(5),    T_BIGINT    BIGINT,    T_INTEGER   INTEGER,    T_SMALLINT  SMALLINT,    T_TINYINT   TINYINT,    T_DOUBLE    DOUBLE,    T_FLOAT     FLOAT,    T_DECIMAL   DECIMAL(4,2),    T_DATE      DATE,    T_TIME      TIME,    T_TIMESTAMP TIMESTAMP,    T_BINARY    BINARY(10),    T_VARBINARY VARBINARY,    T_BOOLEAN   BOOLEAN)";
                String arrytype_sql = " CREATE TABLE V1.ARRAYTYPE (    T_UUID      VARCHAR not null primary key,    T_VARCHAR   VARCHAR ARRAY,    T_CHAR      CHAR(5) ARRAY,    T_BIGINT    BIGINT  ARRAY,    T_INTEGER   INTEGER ARRAY,    T_DOUBLE    DOUBLE  ARRAY,    T_SMALLINT  SMALLINT ARRAY,    T_TINYINT   TINYINT  ARRAY,    T_BOOLEAN   BOOLEAN  ARRAY)";
                Assert.assertFalse((boolean)stmt.execute(region_sql));
                Assert.assertFalse((boolean)stmt.execute(nation_sql));
                Assert.assertFalse((boolean)stmt.execute(datatype_sql));
                Assert.assertFalse((boolean)stmt.execute(arrytype_sql));
            }
        }
    }

    public static void createSampleData(String connString) throws Exception {
        Object[] paths = new String[]{"data/region.tbl", "data/nation.tbl"};
        String[] sqls = new String[]{"UPSERT INTO V1.REGION VALUES(?,?,?)", "UPSERT INTO V1.NATION VALUES(?,?,?,?)", "UPSERT INTO V1.DATATYPE VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", "UPSERT INTO V1.ARRAYTYPE VALUES(?,?,ARRAY['a','b','c'],?,?,?,?,?,?)"};
        Path region_path = new Path(dirTestWatcher.getRootDir().getAbsolutePath(), paths[0]);
        Path nation_path = new Path(dirTestWatcher.getRootDir().getAbsolutePath(), paths[1]);
        logger.info("Loading the .tbl file : " + Arrays.toString(paths));
        List<String[]> allRows = PhoenixBaseTest.parseTblFile(String.valueOf(region_path));
        try (Connection connection = DriverManager.getConnection(connString);){
            Assert.assertFalse((boolean)connection.isClosed());
            connection.setAutoCommit(false);
            try (PreparedStatement pstmt = connection.prepareStatement(sqls[0]);){
                for (String[] row : allRows) {
                    pstmt.setLong(1, Long.valueOf(row[0]));
                    pstmt.setString(2, row[1]);
                    pstmt.setString(3, row[2]);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            connection.commit();
            allRows = PhoenixBaseTest.parseTblFile(String.valueOf(nation_path));
            pstmt = connection.prepareStatement(sqls[1]);
            try {
                for (String[] row : allRows) {
                    pstmt.setLong(1, Long.valueOf(row[0]));
                    pstmt.setString(2, row[1]);
                    pstmt.setLong(3, Long.valueOf(row[2]));
                    pstmt.setString(4, row[3]);
                    pstmt.addBatch();
                }
                pstmt.executeBatch();
            }
            finally {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            connection.commit();
            pstmt = connection.prepareStatement(sqls[2]);
            try {
                pstmt.setString(1, U_U_I_D);
                pstmt.setString(2, "apache");
                pstmt.setString(3, "drill");
                pstmt.setLong(4, Long.MAX_VALUE);
                pstmt.setInt(5, Integer.MAX_VALUE);
                pstmt.setShort(6, (short)Short.MAX_VALUE);
                pstmt.setByte(7, (byte)127);
                pstmt.setDouble(8, Double.MAX_VALUE);
                pstmt.setFloat(9, Float.MAX_VALUE);
                pstmt.setBigDecimal(10, BigDecimal.valueOf(10.11));
                pstmt.setDate(11, Date.valueOf("2021-12-12"));
                pstmt.setTime(12, Time.valueOf("12:12:12"));
                pstmt.setTimestamp(13, Timestamp.valueOf("2021-12-12 12:12:12"));
                pstmt.setBytes(14, "a_b_c_d_e_".getBytes());
                pstmt.setBytes(15, "12345".getBytes());
                pstmt.setBoolean(16, Boolean.TRUE);
                pstmt.addBatch();
                pstmt.executeBatch();
            }
            finally {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            connection.commit();
            pstmt = connection.prepareStatement(sqls[3]);
            try {
                Array t_varchar = connection.createArrayOf("VARCHAR", new String[]{"apache", "drill", "1.20"});
                Array t_char = connection.createArrayOf("CHAR", new String[]{"a", "b", "c"});
                Array t_bigint = connection.createArrayOf("BIGINT", new Long[]{Long.MIN_VALUE, Long.MAX_VALUE});
                Array t_integer = connection.createArrayOf("INTEGER", new Integer[]{Integer.MIN_VALUE, Integer.MAX_VALUE});
                Array t_double = connection.createArrayOf("DOUBLE", new Double[]{Double.MIN_VALUE, Double.MAX_VALUE});
                Array t_float = connection.createArrayOf("FLOAT", new Float[]{Float.valueOf(Float.MIN_VALUE), Float.valueOf(Float.MAX_VALUE)});
                Array t_smallint = connection.createArrayOf("SMALLINT", new Short[]{(short)Short.MIN_VALUE, (short)Short.MAX_VALUE});
                Array t_tinyint = connection.createArrayOf("TINYINT", new Byte[]{(byte)-128, (byte)127});
                Array t_boolean = connection.createArrayOf("BOOLEAN", new Boolean[]{Boolean.TRUE, Boolean.FALSE});
                pstmt.setString(1, U_U_I_D);
                pstmt.setArray(2, t_varchar);
                pstmt.setArray(3, t_bigint);
                pstmt.setArray(4, t_integer);
                pstmt.setArray(5, t_double);
                pstmt.setArray(6, t_smallint);
                pstmt.setArray(7, t_tinyint);
                pstmt.setArray(8, t_boolean);
                pstmt.addBatch();
                pstmt.executeBatch();
            }
            finally {
                if (pstmt != null) {
                    pstmt.close();
                }
            }
            connection.commit();
            logger.info("Loaded {} rows.", (Object)allRows.size());
        }
    }

    private static List<String[]> parseTblFile(String path) throws Exception {
        CsvParserSettings settings = new CsvParserSettings();
        ((CsvFormat)settings.getFormat()).setDelimiter("|");
        ((CsvFormat)settings.getFormat()).setLineSeparator("\n");
        CsvParser parser = new CsvParser(settings);
        return parser.parseAll(PhoenixBaseTest.getReader(path));
    }

    private static Reader getReader(String path) throws Exception {
        return new InputStreamReader((InputStream)new FileInputStream(path), "UTF-8");
    }
}

