/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.exec.store.phoenix.secured;

import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.drill.exec.store.phoenix.QueryServerBasicsIT;
import org.apache.drill.exec.store.phoenix.secured.HttpParamImpersonationQueryServerIT;
import org.apache.drill.exec.store.phoenix.secured.SecuredPhoenixCommandTest;
import org.apache.drill.exec.store.phoenix.secured.SecuredPhoenixDataTypeTest;
import org.apache.drill.exec.store.phoenix.secured.SecuredPhoenixSQLTest;
import org.apache.drill.test.BaseTest;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.platform.suite.api.SelectClasses;
import org.junit.platform.suite.api.Suite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Suite
@SelectClasses(value={SecuredPhoenixDataTypeTest.class, SecuredPhoenixSQLTest.class, SecuredPhoenixCommandTest.class})
@Disabled
@Tags(value={@Tag(value="slow-test"), @Tag(value="row-set-tests")})
public class SecuredPhoenixTestSuite
extends BaseTest {
    private static final Logger logger = LoggerFactory.getLogger(SecuredPhoenixTestSuite.class);
    private static volatile boolean runningSuite = false;
    private static final AtomicInteger initCount = new AtomicInteger(0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeAll
    public static void initPhoenixQueryServer() throws Exception {
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        Class<SecuredPhoenixTestSuite> clazz = SecuredPhoenixTestSuite.class;
        synchronized (SecuredPhoenixTestSuite.class) {
            if (initCount.get() == 0) {
                logger.info("Boot the test cluster...");
                HttpParamImpersonationQueryServerIT.startQueryServerEnvironment();
            }
            initCount.incrementAndGet();
            runningSuite = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterAll
    public static void tearDownCluster() throws Exception {
        Class<SecuredPhoenixTestSuite> clazz = SecuredPhoenixTestSuite.class;
        synchronized (SecuredPhoenixTestSuite.class) {
            if (initCount.decrementAndGet() == 0) {
                logger.info("Shutdown all instances of test cluster.");
                QueryServerBasicsIT.afterClass();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isRunningSuite() {
        return runningSuite;
    }
}

